/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CloudWatchEventSource {
    EC2("EC2"),
    CODE_DEPLOY("CODE_DEPLOY"),
    HEALTH("HEALTH"),
    RDS("RDS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CloudWatchEventSource> VALUE_MAP;
    private final String value;

    private CloudWatchEventSource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CloudWatchEventSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CloudWatchEventSource> knownValues() {
        EnumSet<CloudWatchEventSource> knownValues = EnumSet.allOf(CloudWatchEventSource.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CloudWatchEventSource.class, CloudWatchEventSource::toString);
    }
}

