/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that defines the log patterns that belongs to a <code>LogPatternSet</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogPattern implements SdkPojo, Serializable, ToCopyableBuilder<LogPattern.Builder, LogPattern> {
    private static final SdkField<String> PATTERN_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PatternSetName").getter(getter(LogPattern::patternSetName)).setter(setter(Builder::patternSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatternSetName").build()).build();

    private static final SdkField<String> PATTERN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PatternName").getter(getter(LogPattern::patternName)).setter(setter(Builder::patternName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatternName").build()).build();

    private static final SdkField<String> PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Pattern")
            .getter(getter(LogPattern::pattern)).setter(setter(Builder::pattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pattern").build()).build();

    private static final SdkField<Integer> RANK_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Rank")
            .getter(getter(LogPattern::rank)).setter(setter(Builder::rank))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rank").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATTERN_SET_NAME_FIELD,
            PATTERN_NAME_FIELD, PATTERN_FIELD, RANK_FIELD));

    private static final long serialVersionUID = 1L;

    private final String patternSetName;

    private final String patternName;

    private final String pattern;

    private final Integer rank;

    private LogPattern(BuilderImpl builder) {
        this.patternSetName = builder.patternSetName;
        this.patternName = builder.patternName;
        this.pattern = builder.pattern;
        this.rank = builder.rank;
    }

    /**
     * <p>
     * The name of the log pattern. A log pattern name can contain as many as 30 characters, and it cannot be empty. The
     * characters can be Unicode letters, digits, or one of the following symbols: period, dash, underscore.
     * </p>
     * 
     * @return The name of the log pattern. A log pattern name can contain as many as 30 characters, and it cannot be
     *         empty. The characters can be Unicode letters, digits, or one of the following symbols: period, dash,
     *         underscore.
     */
    public final String patternSetName() {
        return patternSetName;
    }

    /**
     * <p>
     * The name of the log pattern. A log pattern name can contain as many as 50 characters, and it cannot be empty. The
     * characters can be Unicode letters, digits, or one of the following symbols: period, dash, underscore.
     * </p>
     * 
     * @return The name of the log pattern. A log pattern name can contain as many as 50 characters, and it cannot be
     *         empty. The characters can be Unicode letters, digits, or one of the following symbols: period, dash,
     *         underscore.
     */
    public final String patternName() {
        return patternName;
    }

    /**
     * <p>
     * A regular expression that defines the log pattern. A log pattern can contain as many as 50 characters, and it
     * cannot be empty. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference
     * constructions are not supported.
     * </p>
     * 
     * @return A regular expression that defines the log pattern. A log pattern can contain as many as 50 characters,
     *         and it cannot be empty. The pattern must be DFA compatible. Patterns that utilize forward lookahead or
     *         backreference constructions are not supported.
     */
    public final String pattern() {
        return pattern;
    }

    /**
     * <p>
     * Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are
     * sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern of
     * rank <code>1</code> will be the first to get matched to a log line. A pattern of rank <code>1,000,000</code> will
     * be last to get matched. When you configure custom log patterns from the console, a <code>Low</code> severity
     * pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity pattern translates to a
     * <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a <code>250,000</code> rank.
     * Rank values less than <code>1</code> or greater than <code>1,000,000</code> are reserved for Amazon Web Services
     * provided patterns.
     * </p>
     * 
     * @return Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns
     *         are sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A
     *         pattern of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank
     *         <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the
     *         console, a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A
     *         <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a <code>High</code>
     *         severity pattern translates to a <code>250,000</code> rank. Rank values less than <code>1</code> or
     *         greater than <code>1,000,000</code> are reserved for Amazon Web Services provided patterns.
     */
    public final Integer rank() {
        return rank;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(patternSetName());
        hashCode = 31 * hashCode + Objects.hashCode(patternName());
        hashCode = 31 * hashCode + Objects.hashCode(pattern());
        hashCode = 31 * hashCode + Objects.hashCode(rank());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogPattern)) {
            return false;
        }
        LogPattern other = (LogPattern) obj;
        return Objects.equals(patternSetName(), other.patternSetName()) && Objects.equals(patternName(), other.patternName())
                && Objects.equals(pattern(), other.pattern()) && Objects.equals(rank(), other.rank());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogPattern").add("PatternSetName", patternSetName()).add("PatternName", patternName())
                .add("Pattern", pattern()).add("Rank", rank()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PatternSetName":
            return Optional.ofNullable(clazz.cast(patternSetName()));
        case "PatternName":
            return Optional.ofNullable(clazz.cast(patternName()));
        case "Pattern":
            return Optional.ofNullable(clazz.cast(pattern()));
        case "Rank":
            return Optional.ofNullable(clazz.cast(rank()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogPattern, T> g) {
        return obj -> g.apply((LogPattern) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogPattern> {
        /**
         * <p>
         * The name of the log pattern. A log pattern name can contain as many as 30 characters, and it cannot be empty.
         * The characters can be Unicode letters, digits, or one of the following symbols: period, dash, underscore.
         * </p>
         * 
         * @param patternSetName
         *        The name of the log pattern. A log pattern name can contain as many as 30 characters, and it cannot be
         *        empty. The characters can be Unicode letters, digits, or one of the following symbols: period, dash,
         *        underscore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patternSetName(String patternSetName);

        /**
         * <p>
         * The name of the log pattern. A log pattern name can contain as many as 50 characters, and it cannot be empty.
         * The characters can be Unicode letters, digits, or one of the following symbols: period, dash, underscore.
         * </p>
         * 
         * @param patternName
         *        The name of the log pattern. A log pattern name can contain as many as 50 characters, and it cannot be
         *        empty. The characters can be Unicode letters, digits, or one of the following symbols: period, dash,
         *        underscore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patternName(String patternName);

        /**
         * <p>
         * A regular expression that defines the log pattern. A log pattern can contain as many as 50 characters, and it
         * cannot be empty. The pattern must be DFA compatible. Patterns that utilize forward lookahead or backreference
         * constructions are not supported.
         * </p>
         * 
         * @param pattern
         *        A regular expression that defines the log pattern. A log pattern can contain as many as 50 characters,
         *        and it cannot be empty. The pattern must be DFA compatible. Patterns that utilize forward lookahead or
         *        backreference constructions are not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pattern(String pattern);

        /**
         * <p>
         * Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The patterns are
         * sorted by rank, so we recommend that you set your highest priority patterns with the lowest rank. A pattern
         * of rank <code>1</code> will be the first to get matched to a log line. A pattern of rank
         * <code>1,000,000</code> will be last to get matched. When you configure custom log patterns from the console,
         * a <code>Low</code> severity pattern translates to a <code>750,000</code> rank. A <code>Medium</code> severity
         * pattern translates to a <code>500,000</code> rank. And a <code>High</code> severity pattern translates to a
         * <code>250,000</code> rank. Rank values less than <code>1</code> or greater than <code>1,000,000</code> are
         * reserved for Amazon Web Services provided patterns.
         * </p>
         * 
         * @param rank
         *        Rank of the log pattern. Must be a value between <code>1</code> and <code>1,000,000</code>. The
         *        patterns are sorted by rank, so we recommend that you set your highest priority patterns with the
         *        lowest rank. A pattern of rank <code>1</code> will be the first to get matched to a log line. A
         *        pattern of rank <code>1,000,000</code> will be last to get matched. When you configure custom log
         *        patterns from the console, a <code>Low</code> severity pattern translates to a <code>750,000</code>
         *        rank. A <code>Medium</code> severity pattern translates to a <code>500,000</code> rank. And a
         *        <code>High</code> severity pattern translates to a <code>250,000</code> rank. Rank values less than
         *        <code>1</code> or greater than <code>1,000,000</code> are reserved for Amazon Web Services provided
         *        patterns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rank(Integer rank);
    }

    static final class BuilderImpl implements Builder {
        private String patternSetName;

        private String patternName;

        private String pattern;

        private Integer rank;

        private BuilderImpl() {
        }

        private BuilderImpl(LogPattern model) {
            patternSetName(model.patternSetName);
            patternName(model.patternName);
            pattern(model.pattern);
            rank(model.rank);
        }

        public final String getPatternSetName() {
            return patternSetName;
        }

        public final void setPatternSetName(String patternSetName) {
            this.patternSetName = patternSetName;
        }

        @Override
        public final Builder patternSetName(String patternSetName) {
            this.patternSetName = patternSetName;
            return this;
        }

        public final String getPatternName() {
            return patternName;
        }

        public final void setPatternName(String patternName) {
            this.patternName = patternName;
        }

        @Override
        public final Builder patternName(String patternName) {
            this.patternName = patternName;
            return this;
        }

        public final String getPattern() {
            return pattern;
        }

        public final void setPattern(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public final Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public final Integer getRank() {
            return rank;
        }

        public final void setRank(Integer rank) {
            this.rank = rank;
        }

        @Override
        public final Builder rank(Integer rank) {
            this.rank = rank;
            return this;
        }

        @Override
        public LogPattern build() {
            return new LogPattern(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
