/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProblemObservationsResponse extends ApplicationInsightsResponse implements
        ToCopyableBuilder<DescribeProblemObservationsResponse.Builder, DescribeProblemObservationsResponse> {
    private static final SdkField<RelatedObservations> RELATED_OBSERVATIONS_FIELD = SdkField
            .<RelatedObservations> builder(MarshallingType.SDK_POJO).memberName("RelatedObservations")
            .getter(getter(DescribeProblemObservationsResponse::relatedObservations))
            .setter(setter(Builder::relatedObservations)).constructor(RelatedObservations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedObservations").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATED_OBSERVATIONS_FIELD));

    private final RelatedObservations relatedObservations;

    private DescribeProblemObservationsResponse(BuilderImpl builder) {
        super(builder);
        this.relatedObservations = builder.relatedObservations;
    }

    /**
     * <p>
     * Observations related to the problem.
     * </p>
     * 
     * @return Observations related to the problem.
     */
    public final RelatedObservations relatedObservations() {
        return relatedObservations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(relatedObservations());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProblemObservationsResponse)) {
            return false;
        }
        DescribeProblemObservationsResponse other = (DescribeProblemObservationsResponse) obj;
        return Objects.equals(relatedObservations(), other.relatedObservations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeProblemObservationsResponse").add("RelatedObservations", relatedObservations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RelatedObservations":
            return Optional.ofNullable(clazz.cast(relatedObservations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProblemObservationsResponse, T> g) {
        return obj -> g.apply((DescribeProblemObservationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationInsightsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeProblemObservationsResponse> {
        /**
         * <p>
         * Observations related to the problem.
         * </p>
         * 
         * @param relatedObservations
         *        Observations related to the problem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedObservations(RelatedObservations relatedObservations);

        /**
         * <p>
         * Observations related to the problem.
         * </p>
         * This is a convenience method that creates an instance of the {@link RelatedObservations.Builder} avoiding the
         * need to create one manually via {@link RelatedObservations#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RelatedObservations.Builder#build()} is called immediately and
         * its result is passed to {@link #relatedObservations(RelatedObservations)}.
         * 
         * @param relatedObservations
         *        a consumer that will call methods on {@link RelatedObservations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relatedObservations(RelatedObservations)
         */
        default Builder relatedObservations(Consumer<RelatedObservations.Builder> relatedObservations) {
            return relatedObservations(RelatedObservations.builder().applyMutation(relatedObservations).build());
        }
    }

    static final class BuilderImpl extends ApplicationInsightsResponse.BuilderImpl implements Builder {
        private RelatedObservations relatedObservations;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProblemObservationsResponse model) {
            super(model);
            relatedObservations(model.relatedObservations);
        }

        public final RelatedObservations.Builder getRelatedObservations() {
            return relatedObservations != null ? relatedObservations.toBuilder() : null;
        }

        public final void setRelatedObservations(RelatedObservations.BuilderImpl relatedObservations) {
            this.relatedObservations = relatedObservations != null ? relatedObservations.build() : null;
        }

        @Override
        public final Builder relatedObservations(RelatedObservations relatedObservations) {
            this.relatedObservations = relatedObservations;
            return this;
        }

        @Override
        public DescribeProblemObservationsResponse build() {
            return new DescribeProblemObservationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
