/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationinsights.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a standalone resource or similarly grouped resources that the application is made up of.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationComponent implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationComponent.Builder, ApplicationComponent> {
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComponentName").getter(getter(ApplicationComponent::componentName))
            .setter(setter(Builder::componentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentName").build()).build();

    private static final SdkField<String> COMPONENT_REMARKS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComponentRemarks").getter(getter(ApplicationComponent::componentRemarks))
            .setter(setter(Builder::componentRemarks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentRemarks").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ApplicationComponent::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> OS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("OsType")
            .getter(getter(ApplicationComponent::osTypeAsString)).setter(setter(Builder::osType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OsType").build()).build();

    private static final SdkField<String> TIER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tier")
            .getter(getter(ApplicationComponent::tierAsString)).setter(setter(Builder::tier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()).build();

    private static final SdkField<Boolean> MONITOR_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Monitor").getter(getter(ApplicationComponent::monitor)).setter(setter(Builder::monitor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitor").build()).build();

    private static final SdkField<Map<String, Map<String, String>>> DETECTED_WORKLOAD_FIELD = SdkField
            .<Map<String, Map<String, String>>> builder(MarshallingType.MAP)
            .memberName("DetectedWorkload")
            .getter(getter(ApplicationComponent::detectedWorkloadAsStrings))
            .setter(setter(Builder::detectedWorkloadWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectedWorkload").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_NAME_FIELD,
            COMPONENT_REMARKS_FIELD, RESOURCE_TYPE_FIELD, OS_TYPE_FIELD, TIER_FIELD, MONITOR_FIELD, DETECTED_WORKLOAD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String componentName;

    private final String componentRemarks;

    private final String resourceType;

    private final String osType;

    private final String tier;

    private final Boolean monitor;

    private final Map<String, Map<String, String>> detectedWorkload;

    private ApplicationComponent(BuilderImpl builder) {
        this.componentName = builder.componentName;
        this.componentRemarks = builder.componentRemarks;
        this.resourceType = builder.resourceType;
        this.osType = builder.osType;
        this.tier = builder.tier;
        this.monitor = builder.monitor;
        this.detectedWorkload = builder.detectedWorkload;
    }

    /**
     * <p>
     * The name of the component.
     * </p>
     * 
     * @return The name of the component.
     */
    public final String componentName() {
        return componentName;
    }

    /**
     * <p>
     * If logging is supported for the resource type, indicates whether the component has configured logs to be
     * monitored.
     * </p>
     * 
     * @return If logging is supported for the resource type, indicates whether the component has configured logs to be
     *         monitored.
     */
    public final String componentRemarks() {
        return componentRemarks;
    }

    /**
     * <p>
     * The resource type. Supported resource types include EC2 instances, Auto Scaling group, Classic ELB, Application
     * ELB, and SQS Queue.
     * </p>
     * 
     * @return The resource type. Supported resource types include EC2 instances, Auto Scaling group, Classic ELB,
     *         Application ELB, and SQS Queue.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The operating system of the component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #osType} will
     * return {@link OsType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #osTypeAsString}.
     * </p>
     * 
     * @return The operating system of the component.
     * @see OsType
     */
    public final OsType osType() {
        return OsType.fromValue(osType);
    }

    /**
     * <p>
     * The operating system of the component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #osType} will
     * return {@link OsType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #osTypeAsString}.
     * </p>
     * 
     * @return The operating system of the component.
     * @see OsType
     */
    public final String osTypeAsString() {
        return osType;
    }

    /**
     * <p>
     * The stack tier of the application component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link Tier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The stack tier of the application component.
     * @see Tier
     */
    public final Tier tier() {
        return Tier.fromValue(tier);
    }

    /**
     * <p>
     * The stack tier of the application component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tier} will return
     * {@link Tier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tierAsString}.
     * </p>
     * 
     * @return The stack tier of the application component.
     * @see Tier
     */
    public final String tierAsString() {
        return tier;
    }

    /**
     * <p>
     * Indicates whether the application component is monitored.
     * </p>
     * 
     * @return Indicates whether the application component is monitored.
     */
    public final Boolean monitor() {
        return monitor;
    }

    /**
     * <p>
     * Workloads detected in the application component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDetectedWorkload} method.
     * </p>
     * 
     * @return Workloads detected in the application component.
     */
    public final Map<Tier, Map<String, String>> detectedWorkload() {
        return DetectedWorkloadCopier.copyStringToEnum(detectedWorkload);
    }

    /**
     * For responses, this returns true if the service returned a value for the DetectedWorkload property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDetectedWorkload() {
        return detectedWorkload != null && !(detectedWorkload instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Workloads detected in the application component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDetectedWorkload} method.
     * </p>
     * 
     * @return Workloads detected in the application component.
     */
    public final Map<String, Map<String, String>> detectedWorkloadAsStrings() {
        return detectedWorkload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentName());
        hashCode = 31 * hashCode + Objects.hashCode(componentRemarks());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(osTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(monitor());
        hashCode = 31 * hashCode + Objects.hashCode(hasDetectedWorkload() ? detectedWorkloadAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationComponent)) {
            return false;
        }
        ApplicationComponent other = (ApplicationComponent) obj;
        return Objects.equals(componentName(), other.componentName())
                && Objects.equals(componentRemarks(), other.componentRemarks())
                && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(osTypeAsString(), other.osTypeAsString())
                && Objects.equals(tierAsString(), other.tierAsString()) && Objects.equals(monitor(), other.monitor())
                && hasDetectedWorkload() == other.hasDetectedWorkload()
                && Objects.equals(detectedWorkloadAsStrings(), other.detectedWorkloadAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationComponent").add("ComponentName", componentName())
                .add("ComponentRemarks", componentRemarks()).add("ResourceType", resourceType()).add("OsType", osTypeAsString())
                .add("Tier", tierAsString()).add("Monitor", monitor())
                .add("DetectedWorkload", hasDetectedWorkload() ? detectedWorkloadAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComponentName":
            return Optional.ofNullable(clazz.cast(componentName()));
        case "ComponentRemarks":
            return Optional.ofNullable(clazz.cast(componentRemarks()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "OsType":
            return Optional.ofNullable(clazz.cast(osTypeAsString()));
        case "Tier":
            return Optional.ofNullable(clazz.cast(tierAsString()));
        case "Monitor":
            return Optional.ofNullable(clazz.cast(monitor()));
        case "DetectedWorkload":
            return Optional.ofNullable(clazz.cast(detectedWorkloadAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationComponent, T> g) {
        return obj -> g.apply((ApplicationComponent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationComponent> {
        /**
         * <p>
         * The name of the component.
         * </p>
         * 
         * @param componentName
         *        The name of the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentName(String componentName);

        /**
         * <p>
         * If logging is supported for the resource type, indicates whether the component has configured logs to be
         * monitored.
         * </p>
         * 
         * @param componentRemarks
         *        If logging is supported for the resource type, indicates whether the component has configured logs to
         *        be monitored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentRemarks(String componentRemarks);

        /**
         * <p>
         * The resource type. Supported resource types include EC2 instances, Auto Scaling group, Classic ELB,
         * Application ELB, and SQS Queue.
         * </p>
         * 
         * @param resourceType
         *        The resource type. Supported resource types include EC2 instances, Auto Scaling group, Classic ELB,
         *        Application ELB, and SQS Queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The operating system of the component.
         * </p>
         * 
         * @param osType
         *        The operating system of the component.
         * @see OsType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OsType
         */
        Builder osType(String osType);

        /**
         * <p>
         * The operating system of the component.
         * </p>
         * 
         * @param osType
         *        The operating system of the component.
         * @see OsType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OsType
         */
        Builder osType(OsType osType);

        /**
         * <p>
         * The stack tier of the application component.
         * </p>
         * 
         * @param tier
         *        The stack tier of the application component.
         * @see Tier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tier
         */
        Builder tier(String tier);

        /**
         * <p>
         * The stack tier of the application component.
         * </p>
         * 
         * @param tier
         *        The stack tier of the application component.
         * @see Tier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Tier
         */
        Builder tier(Tier tier);

        /**
         * <p>
         * Indicates whether the application component is monitored.
         * </p>
         * 
         * @param monitor
         *        Indicates whether the application component is monitored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitor(Boolean monitor);

        /**
         * <p>
         * Workloads detected in the application component.
         * </p>
         * 
         * @param detectedWorkload
         *        Workloads detected in the application component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectedWorkloadWithStrings(Map<String, ? extends Map<String, String>> detectedWorkload);

        /**
         * <p>
         * Workloads detected in the application component.
         * </p>
         * 
         * @param detectedWorkload
         *        Workloads detected in the application component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectedWorkload(Map<Tier, ? extends Map<String, String>> detectedWorkload);
    }

    static final class BuilderImpl implements Builder {
        private String componentName;

        private String componentRemarks;

        private String resourceType;

        private String osType;

        private String tier;

        private Boolean monitor;

        private Map<String, Map<String, String>> detectedWorkload = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationComponent model) {
            componentName(model.componentName);
            componentRemarks(model.componentRemarks);
            resourceType(model.resourceType);
            osType(model.osType);
            tier(model.tier);
            monitor(model.monitor);
            detectedWorkloadWithStrings(model.detectedWorkload);
        }

        public final String getComponentName() {
            return componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getComponentRemarks() {
            return componentRemarks;
        }

        public final void setComponentRemarks(String componentRemarks) {
            this.componentRemarks = componentRemarks;
        }

        @Override
        public final Builder componentRemarks(String componentRemarks) {
            this.componentRemarks = componentRemarks;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getOsType() {
            return osType;
        }

        public final void setOsType(String osType) {
            this.osType = osType;
        }

        @Override
        public final Builder osType(String osType) {
            this.osType = osType;
            return this;
        }

        @Override
        public final Builder osType(OsType osType) {
            this.osType(osType == null ? null : osType.toString());
            return this;
        }

        public final String getTier() {
            return tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(Tier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final Boolean getMonitor() {
            return monitor;
        }

        public final void setMonitor(Boolean monitor) {
            this.monitor = monitor;
        }

        @Override
        public final Builder monitor(Boolean monitor) {
            this.monitor = monitor;
            return this;
        }

        public final Map<String, ? extends Map<String, String>> getDetectedWorkload() {
            if (detectedWorkload instanceof SdkAutoConstructMap) {
                return null;
            }
            return detectedWorkload;
        }

        public final void setDetectedWorkload(Map<String, ? extends Map<String, String>> detectedWorkload) {
            this.detectedWorkload = DetectedWorkloadCopier.copy(detectedWorkload);
        }

        @Override
        public final Builder detectedWorkloadWithStrings(Map<String, ? extends Map<String, String>> detectedWorkload) {
            this.detectedWorkload = DetectedWorkloadCopier.copy(detectedWorkload);
            return this;
        }

        @Override
        public final Builder detectedWorkload(Map<Tier, ? extends Map<String, String>> detectedWorkload) {
            this.detectedWorkload = DetectedWorkloadCopier.copyEnumToString(detectedWorkload);
            return this;
        }

        @Override
        public ApplicationComponent build() {
            return new ApplicationComponent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
