/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationdiscovery.ApplicationDiscoveryAsyncClient;
import software.amazon.awssdk.services.applicationdiscovery.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeExportTasksRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.DescribeExportTasksResponse;
import software.amazon.awssdk.services.applicationdiscovery.model.ExportInfo;

public class DescribeExportTasksPublisher
implements SdkPublisher<DescribeExportTasksResponse> {
    private final ApplicationDiscoveryAsyncClient client;
    private final DescribeExportTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeExportTasksPublisher(ApplicationDiscoveryAsyncClient client, DescribeExportTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeExportTasksPublisher(ApplicationDiscoveryAsyncClient client, DescribeExportTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeExportTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeExportTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ExportInfo> exportsInfo() {
        Function<DescribeExportTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.exportsInfo() != null) {
                return response.exportsInfo().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeExportTasksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeExportTasksResponseFetcher
    implements AsyncPageFetcher<DescribeExportTasksResponse> {
        private DescribeExportTasksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeExportTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeExportTasksResponse> nextPage(DescribeExportTasksResponse previousPage) {
            if (previousPage == null) {
                return DescribeExportTasksPublisher.this.client.describeExportTasks(DescribeExportTasksPublisher.this.firstRequest);
            }
            return DescribeExportTasksPublisher.this.client.describeExportTasks((DescribeExportTasksRequest)((Object)DescribeExportTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

