/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationdiscovery.ApplicationDiscoveryClient;
import software.amazon.awssdk.services.applicationdiscovery.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationdiscovery.model.ListConfigurationsRequest;
import software.amazon.awssdk.services.applicationdiscovery.model.ListConfigurationsResponse;

public class ListConfigurationsIterable
implements SdkIterable<ListConfigurationsResponse> {
    private final ApplicationDiscoveryClient client;
    private final ListConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConfigurationsIterable(ApplicationDiscoveryClient client, ListConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConfigurationsResponseFetcher();
    }

    public Iterator<ListConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Map<String, String>> configurations() {
        Function<ListConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configurations() != null) {
                return response.configurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConfigurationsResponseFetcher
    implements SyncPageFetcher<ListConfigurationsResponse> {
        private ListConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConfigurationsResponse nextPage(ListConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListConfigurationsIterable.this.client.listConfigurations(ListConfigurationsIterable.this.firstRequest);
            }
            return ListConfigurationsIterable.this.client.listConfigurations((ListConfigurationsRequest)((Object)ListConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

