/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationdiscovery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about neighboring servers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NeighborConnectionDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<NeighborConnectionDetail.Builder, NeighborConnectionDetail> {
    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceServerId").getter(getter(NeighborConnectionDetail::sourceServerId))
            .setter(setter(Builder::sourceServerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerId").build()).build();

    private static final SdkField<String> DESTINATION_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationServerId").getter(getter(NeighborConnectionDetail::destinationServerId))
            .setter(setter(Builder::destinationServerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationServerId").build())
            .build();

    private static final SdkField<Integer> DESTINATION_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("destinationPort").getter(getter(NeighborConnectionDetail::destinationPort))
            .setter(setter(Builder::destinationPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationPort").build()).build();

    private static final SdkField<String> TRANSPORT_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transportProtocol").getter(getter(NeighborConnectionDetail::transportProtocol))
            .setter(setter(Builder::transportProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transportProtocol").build()).build();

    private static final SdkField<Long> CONNECTIONS_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("connectionsCount").getter(getter(NeighborConnectionDetail::connectionsCount))
            .setter(setter(Builder::connectionsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionsCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_SERVER_ID_FIELD,
            DESTINATION_SERVER_ID_FIELD, DESTINATION_PORT_FIELD, TRANSPORT_PROTOCOL_FIELD, CONNECTIONS_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceServerId;

    private final String destinationServerId;

    private final Integer destinationPort;

    private final String transportProtocol;

    private final Long connectionsCount;

    private NeighborConnectionDetail(BuilderImpl builder) {
        this.sourceServerId = builder.sourceServerId;
        this.destinationServerId = builder.destinationServerId;
        this.destinationPort = builder.destinationPort;
        this.transportProtocol = builder.transportProtocol;
        this.connectionsCount = builder.connectionsCount;
    }

    /**
     * <p>
     * The ID of the server that opened the network connection.
     * </p>
     * 
     * @return The ID of the server that opened the network connection.
     */
    public final String sourceServerId() {
        return sourceServerId;
    }

    /**
     * <p>
     * The ID of the server that accepted the network connection.
     * </p>
     * 
     * @return The ID of the server that accepted the network connection.
     */
    public final String destinationServerId() {
        return destinationServerId;
    }

    /**
     * <p>
     * The destination network port for the connection.
     * </p>
     * 
     * @return The destination network port for the connection.
     */
    public final Integer destinationPort() {
        return destinationPort;
    }

    /**
     * <p>
     * The network protocol used for the connection.
     * </p>
     * 
     * @return The network protocol used for the connection.
     */
    public final String transportProtocol() {
        return transportProtocol;
    }

    /**
     * <p>
     * The number of open network connections with the neighboring server.
     * </p>
     * 
     * @return The number of open network connections with the neighboring server.
     */
    public final Long connectionsCount() {
        return connectionsCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceServerId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationServerId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPort());
        hashCode = 31 * hashCode + Objects.hashCode(transportProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(connectionsCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NeighborConnectionDetail)) {
            return false;
        }
        NeighborConnectionDetail other = (NeighborConnectionDetail) obj;
        return Objects.equals(sourceServerId(), other.sourceServerId())
                && Objects.equals(destinationServerId(), other.destinationServerId())
                && Objects.equals(destinationPort(), other.destinationPort())
                && Objects.equals(transportProtocol(), other.transportProtocol())
                && Objects.equals(connectionsCount(), other.connectionsCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NeighborConnectionDetail").add("SourceServerId", sourceServerId())
                .add("DestinationServerId", destinationServerId()).add("DestinationPort", destinationPort())
                .add("TransportProtocol", transportProtocol()).add("ConnectionsCount", connectionsCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceServerId":
            return Optional.ofNullable(clazz.cast(sourceServerId()));
        case "destinationServerId":
            return Optional.ofNullable(clazz.cast(destinationServerId()));
        case "destinationPort":
            return Optional.ofNullable(clazz.cast(destinationPort()));
        case "transportProtocol":
            return Optional.ofNullable(clazz.cast(transportProtocol()));
        case "connectionsCount":
            return Optional.ofNullable(clazz.cast(connectionsCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NeighborConnectionDetail, T> g) {
        return obj -> g.apply((NeighborConnectionDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NeighborConnectionDetail> {
        /**
         * <p>
         * The ID of the server that opened the network connection.
         * </p>
         * 
         * @param sourceServerId
         *        The ID of the server that opened the network connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerId(String sourceServerId);

        /**
         * <p>
         * The ID of the server that accepted the network connection.
         * </p>
         * 
         * @param destinationServerId
         *        The ID of the server that accepted the network connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationServerId(String destinationServerId);

        /**
         * <p>
         * The destination network port for the connection.
         * </p>
         * 
         * @param destinationPort
         *        The destination network port for the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPort(Integer destinationPort);

        /**
         * <p>
         * The network protocol used for the connection.
         * </p>
         * 
         * @param transportProtocol
         *        The network protocol used for the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transportProtocol(String transportProtocol);

        /**
         * <p>
         * The number of open network connections with the neighboring server.
         * </p>
         * 
         * @param connectionsCount
         *        The number of open network connections with the neighboring server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionsCount(Long connectionsCount);
    }

    static final class BuilderImpl implements Builder {
        private String sourceServerId;

        private String destinationServerId;

        private Integer destinationPort;

        private String transportProtocol;

        private Long connectionsCount;

        private BuilderImpl() {
        }

        private BuilderImpl(NeighborConnectionDetail model) {
            sourceServerId(model.sourceServerId);
            destinationServerId(model.destinationServerId);
            destinationPort(model.destinationPort);
            transportProtocol(model.transportProtocol);
            connectionsCount(model.connectionsCount);
        }

        public final String getSourceServerId() {
            return sourceServerId;
        }

        public final void setSourceServerId(String sourceServerId) {
            this.sourceServerId = sourceServerId;
        }

        @Override
        public final Builder sourceServerId(String sourceServerId) {
            this.sourceServerId = sourceServerId;
            return this;
        }

        public final String getDestinationServerId() {
            return destinationServerId;
        }

        public final void setDestinationServerId(String destinationServerId) {
            this.destinationServerId = destinationServerId;
        }

        @Override
        public final Builder destinationServerId(String destinationServerId) {
            this.destinationServerId = destinationServerId;
            return this;
        }

        public final Integer getDestinationPort() {
            return destinationPort;
        }

        public final void setDestinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
        }

        @Override
        public final Builder destinationPort(Integer destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        public final String getTransportProtocol() {
            return transportProtocol;
        }

        public final void setTransportProtocol(String transportProtocol) {
            this.transportProtocol = transportProtocol;
        }

        @Override
        public final Builder transportProtocol(String transportProtocol) {
            this.transportProtocol = transportProtocol;
            return this;
        }

        public final Long getConnectionsCount() {
            return connectionsCount;
        }

        public final void setConnectionsCount(Long connectionsCount) {
            this.connectionsCount = connectionsCount;
        }

        @Override
        public final Builder connectionsCount(Long connectionsCount) {
            this.connectionsCount = connectionsCount;
            return this;
        }

        @Override
        public NeighborConnectionDetail build() {
            return new NeighborConnectionDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
