/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum OrderString {
    ASC("ASC"),
    DESC("DESC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private OrderString(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OrderString fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(OrderString.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OrderString> knownValues() {
        return Stream.of(OrderString.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

