/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationautoscaling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.applicationautoscaling.ApplicationAutoScalingAsyncClient;
import software.amazon.awssdk.services.applicationautoscaling.internal.UserAgentUtils;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesRequest;
import software.amazon.awssdk.services.applicationautoscaling.model.DescribeScalingActivitiesResponse;
import software.amazon.awssdk.services.applicationautoscaling.model.ScalingActivity;

public class DescribeScalingActivitiesPublisher
implements SdkPublisher<DescribeScalingActivitiesResponse> {
    private final ApplicationAutoScalingAsyncClient client;
    private final DescribeScalingActivitiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeScalingActivitiesPublisher(ApplicationAutoScalingAsyncClient client, DescribeScalingActivitiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeScalingActivitiesPublisher(ApplicationAutoScalingAsyncClient client, DescribeScalingActivitiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeScalingActivitiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeScalingActivitiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ScalingActivity> scalingActivities() {
        Function<DescribeScalingActivitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.scalingActivities() != null) {
                return response.scalingActivities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeScalingActivitiesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeScalingActivitiesResponseFetcher
    implements AsyncPageFetcher<DescribeScalingActivitiesResponse> {
        private DescribeScalingActivitiesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeScalingActivitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeScalingActivitiesResponse> nextPage(DescribeScalingActivitiesResponse previousPage) {
            if (previousPage == null) {
                return DescribeScalingActivitiesPublisher.this.client.describeScalingActivities(DescribeScalingActivitiesPublisher.this.firstRequest);
            }
            return DescribeScalingActivitiesPublisher.this.client.describeScalingActivities((DescribeScalingActivitiesRequest)((Object)DescribeScalingActivitiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

