/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.applicationautoscaling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterScalableTargetResponse extends ApplicationAutoScalingResponse implements
        ToCopyableBuilder<RegisterScalableTargetResponse.Builder, RegisterScalableTargetResponse> {
    private static final SdkField<String> SCALABLE_TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScalableTargetARN").getter(getter(RegisterScalableTargetResponse::scalableTargetARN))
            .setter(setter(Builder::scalableTargetARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalableTargetARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALABLE_TARGET_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String scalableTargetARN;

    private RegisterScalableTargetResponse(BuilderImpl builder) {
        super(builder);
        this.scalableTargetARN = builder.scalableTargetARN;
    }

    /**
     * <p>
     * The ARN of the scalable target.
     * </p>
     * 
     * @return The ARN of the scalable target.
     */
    public final String scalableTargetARN() {
        return scalableTargetARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scalableTargetARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterScalableTargetResponse)) {
            return false;
        }
        RegisterScalableTargetResponse other = (RegisterScalableTargetResponse) obj;
        return Objects.equals(scalableTargetARN(), other.scalableTargetARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterScalableTargetResponse").add("ScalableTargetARN", scalableTargetARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScalableTargetARN":
            return Optional.ofNullable(clazz.cast(scalableTargetARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ScalableTargetARN", SCALABLE_TARGET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterScalableTargetResponse, T> g) {
        return obj -> g.apply((RegisterScalableTargetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApplicationAutoScalingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RegisterScalableTargetResponse> {
        /**
         * <p>
         * The ARN of the scalable target.
         * </p>
         * 
         * @param scalableTargetARN
         *        The ARN of the scalable target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalableTargetARN(String scalableTargetARN);
    }

    static final class BuilderImpl extends ApplicationAutoScalingResponse.BuilderImpl implements Builder {
        private String scalableTargetARN;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterScalableTargetResponse model) {
            super(model);
            scalableTargetARN(model.scalableTargetARN);
        }

        public final String getScalableTargetARN() {
            return scalableTargetARN;
        }

        public final void setScalableTargetARN(String scalableTargetARN) {
            this.scalableTargetARN = scalableTargetARN;
        }

        @Override
        public final Builder scalableTargetARN(String scalableTargetARN) {
            this.scalableTargetARN = scalableTargetARN;
            return this;
        }

        @Override
        public RegisterScalableTargetResponse build() {
            return new RegisterScalableTargetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
