/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appintegrations;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.appintegrations.model.CreateEventIntegrationRequest;
import software.amazon.awssdk.services.appintegrations.model.CreateEventIntegrationResponse;
import software.amazon.awssdk.services.appintegrations.model.DeleteEventIntegrationRequest;
import software.amazon.awssdk.services.appintegrations.model.DeleteEventIntegrationResponse;
import software.amazon.awssdk.services.appintegrations.model.GetEventIntegrationRequest;
import software.amazon.awssdk.services.appintegrations.model.GetEventIntegrationResponse;
import software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsResponse;
import software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest;
import software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsResponse;
import software.amazon.awssdk.services.appintegrations.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.appintegrations.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.appintegrations.model.TagResourceRequest;
import software.amazon.awssdk.services.appintegrations.model.TagResourceResponse;
import software.amazon.awssdk.services.appintegrations.model.UntagResourceRequest;
import software.amazon.awssdk.services.appintegrations.model.UntagResourceResponse;
import software.amazon.awssdk.services.appintegrations.model.UpdateEventIntegrationRequest;
import software.amazon.awssdk.services.appintegrations.model.UpdateEventIntegrationResponse;

/**
 * Service client for accessing Amazon AppIntegrations Service asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * The Amazon AppIntegrations APIs are in preview release and are subject to change.
 * </p>
 * <p>
 * The Amazon AppIntegrations service enables you to configure and reuse connections to external applications.
 * </p>
 * <p>
 * For information about how you can use external applications with Amazon Connect, see <a
 * href="https://docs.aws.amazon.com/connect/latest/adminguide/crm.html">Set up pre-built integrations</a> in the
 * <i>Amazon Connect Administrator Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AppIntegrationsAsyncClient extends SdkClient {
    String SERVICE_NAME = "app-integrations";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "app-integrations";

    /**
     * Create a {@link AppIntegrationsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AppIntegrationsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AppIntegrationsAsyncClient}.
     */
    static AppIntegrationsAsyncClientBuilder builder() {
        return new DefaultAppIntegrationsAsyncClientBuilder();
    }

    /**
     * <p>
     * The Amazon AppIntegrations APIs are in preview release and are subject to change.
     * </p>
     * <p>
     * Creates an EventIntegration, given a specified name, description, and a reference to an Amazon Eventbridge bus in
     * your account and a partner event source that will push events to that bus. No objects are created in the your
     * account, only metadata that is persisted on the EventIntegration control plane.
     * </p>
     *
     * @param createEventIntegrationRequest
     * @return A Java Future containing the result of the CreateEventIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ResourceQuotaExceededException The allowed quota for the resource has been exceeded.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.CreateEventIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/CreateEventIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEventIntegrationResponse> createEventIntegration(
            CreateEventIntegrationRequest createEventIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The Amazon AppIntegrations APIs are in preview release and are subject to change.
     * </p>
     * <p>
     * Creates an EventIntegration, given a specified name, description, and a reference to an Amazon Eventbridge bus in
     * your account and a partner event source that will push events to that bus. No objects are created in the your
     * account, only metadata that is persisted on the EventIntegration control plane.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventIntegrationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateEventIntegrationRequest#builder()}
     * </p>
     *
     * @param createEventIntegrationRequest
     *        A {@link Consumer} that will call methods on {@link CreateEventIntegrationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEventIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ResourceQuotaExceededException The allowed quota for the resource has been exceeded.</li>
     *         <li>DuplicateResourceException A resource with the specified name already exists.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.CreateEventIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/CreateEventIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateEventIntegrationResponse> createEventIntegration(
            Consumer<CreateEventIntegrationRequest.Builder> createEventIntegrationRequest) {
        return createEventIntegration(CreateEventIntegrationRequest.builder().applyMutation(createEventIntegrationRequest)
                .build());
    }

    /**
     * <p>
     * The Amazon AppIntegrations APIs are in preview release and are subject to change.
     * </p>
     * <p>
     * Deletes the specified existing event integration. If the event integration is associated with clients, the
     * request is rejected.
     * </p>
     *
     * @param deleteEventIntegrationRequest
     * @return A Java Future containing the result of the DeleteEventIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.DeleteEventIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/DeleteEventIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventIntegrationResponse> deleteEventIntegration(
            DeleteEventIntegrationRequest deleteEventIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The Amazon AppIntegrations APIs are in preview release and are subject to change.
     * </p>
     * <p>
     * Deletes the specified existing event integration. If the event integration is associated with clients, the
     * request is rejected.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventIntegrationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteEventIntegrationRequest#builder()}
     * </p>
     *
     * @param deleteEventIntegrationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEventIntegrationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEventIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.DeleteEventIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/DeleteEventIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventIntegrationResponse> deleteEventIntegration(
            Consumer<DeleteEventIntegrationRequest.Builder> deleteEventIntegrationRequest) {
        return deleteEventIntegration(DeleteEventIntegrationRequest.builder().applyMutation(deleteEventIntegrationRequest)
                .build());
    }

    /**
     * <p>
     * The Amazon AppIntegrations APIs are in preview release and are subject to change.
     * </p>
     * <p>
     * Return information about the event integration.
     * </p>
     *
     * @param getEventIntegrationRequest
     * @return A Java Future containing the result of the GetEventIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.GetEventIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/GetEventIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEventIntegrationResponse> getEventIntegration(
            GetEventIntegrationRequest getEventIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The Amazon AppIntegrations APIs are in preview release and are subject to change.
     * </p>
     * <p>
     * Return information about the event integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventIntegrationRequest.Builder} avoiding the
     * need to create one manually via {@link GetEventIntegrationRequest#builder()}
     * </p>
     *
     * @param getEventIntegrationRequest
     *        A {@link Consumer} that will call methods on {@link GetEventIntegrationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEventIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.GetEventIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/GetEventIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEventIntegrationResponse> getEventIntegration(
            Consumer<GetEventIntegrationRequest.Builder> getEventIntegrationRequest) {
        return getEventIntegration(GetEventIntegrationRequest.builder().applyMutation(getEventIntegrationRequest).build());
    }

    /**
     * <p>
     * The Amazon AppIntegrations APIs are in preview release and are subject to change.
     * </p>
     * <p>
     * Returns a paginated list of event integration associations in the account.
     * </p>
     *
     * @param listEventIntegrationAssociationsRequest
     * @return A Java Future containing the result of the ListEventIntegrationAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListEventIntegrationAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventIntegrationAssociationsResponse> listEventIntegrationAssociations(
            ListEventIntegrationAssociationsRequest listEventIntegrationAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The Amazon AppIntegrations APIs are in preview release and are subject to change.
     * </p>
     * <p>
     * Returns a paginated list of event integration associations in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventIntegrationAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListEventIntegrationAssociationsRequest#builder()}
     * </p>
     *
     * @param listEventIntegrationAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ListEventIntegrationAssociationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListEventIntegrationAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListEventIntegrationAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventIntegrationAssociationsResponse> listEventIntegrationAssociations(
            Consumer<ListEventIntegrationAssociationsRequest.Builder> listEventIntegrationAssociationsRequest) {
        return listEventIntegrationAssociations(ListEventIntegrationAssociationsRequest.builder()
                .applyMutation(listEventIntegrationAssociationsRequest).build());
    }

    /**
     * <p>
     * The Amazon AppIntegrations APIs are in preview release and are subject to change.
     * </p>
     * <p>
     * Returns a paginated list of event integrations in the account.
     * </p>
     *
     * @param listEventIntegrationsRequest
     * @return A Java Future containing the result of the ListEventIntegrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListEventIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventIntegrationsResponse> listEventIntegrations(
            ListEventIntegrationsRequest listEventIntegrationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The Amazon AppIntegrations APIs are in preview release and are subject to change.
     * </p>
     * <p>
     * Returns a paginated list of event integrations in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventIntegrationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEventIntegrationsRequest#builder()}
     * </p>
     *
     * @param listEventIntegrationsRequest
     *        A {@link Consumer} that will call methods on {@link ListEventIntegrationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEventIntegrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListEventIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventIntegrationsResponse> listEventIntegrations(
            Consumer<ListEventIntegrationsRequest.Builder> listEventIntegrationsRequest) {
        return listEventIntegrations(ListEventIntegrationsRequest.builder().applyMutation(listEventIntegrationsRequest).build());
    }

    /**
     * <p>
     * The Amazon AppIntegrations APIs are in preview release and are subject to change.
     * </p>
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The Amazon AppIntegrations APIs are in preview release and are subject to change.
     * </p>
     * <p>
     * Lists the tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * The Amazon AppIntegrations APIs are in preview release and are subject to change.
     * </p>
     * <p>
     * Adds the specified tags to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The Amazon AppIntegrations APIs are in preview release and are subject to change.
     * </p>
     * <p>
     * Adds the specified tags to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * The Amazon AppIntegrations APIs are in preview release and are subject to change.
     * </p>
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The Amazon AppIntegrations APIs are in preview release and are subject to change.
     * </p>
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * The Amazon AppIntegrations APIs are in preview release and are subject to change.
     * </p>
     * <p>
     * Updates the description of an event integration.
     * </p>
     *
     * @param updateEventIntegrationRequest
     * @return A Java Future containing the result of the UpdateEventIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.UpdateEventIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UpdateEventIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEventIntegrationResponse> updateEventIntegration(
            UpdateEventIntegrationRequest updateEventIntegrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The Amazon AppIntegrations APIs are in preview release and are subject to change.
     * </p>
     * <p>
     * Updates the description of an event integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEventIntegrationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateEventIntegrationRequest#builder()}
     * </p>
     *
     * @param updateEventIntegrationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEventIntegrationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateEventIntegration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException Request processing failed due to an error or failure with the service.</li>
     *         <li>ThrottlingException The throttling limit has been exceeded.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppIntegrationsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AppIntegrationsAsyncClient.UpdateEventIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UpdateEventIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEventIntegrationResponse> updateEventIntegration(
            Consumer<UpdateEventIntegrationRequest.Builder> updateEventIntegrationRequest) {
        return updateEventIntegration(UpdateEventIntegrationRequest.builder().applyMutation(updateEventIntegrationRequest)
                .build());
    }
}
