/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Clears any customization of a GatewayResponse of a specified response type on the given RestApi and resets it with
 * the default settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteGatewayResponseRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<DeleteGatewayResponseRequest.Builder, DeleteGatewayResponseRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("restApiId").getter(getter(DeleteGatewayResponseRequest::restApiId)).setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()).build();

    private static final SdkField<String> RESPONSE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("responseType").getter(getter(DeleteGatewayResponseRequest::responseTypeAsString))
            .setter(setter(Builder::responseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("response_type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD,
            RESPONSE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String restApiId;

    private final String responseType;

    private DeleteGatewayResponseRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.responseType = builder.responseType;
    }

    /**
     * <p>
     * The string identifier of the associated RestApi.
     * </p>
     * 
     * @return The string identifier of the associated RestApi.
     */
    public final String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * The response type of the associated GatewayResponse.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #responseType} will
     * return {@link GatewayResponseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #responseTypeAsString}.
     * </p>
     * 
     * @return The response type of the associated GatewayResponse.
     * @see GatewayResponseType
     */
    public final GatewayResponseType responseType() {
        return GatewayResponseType.fromValue(responseType);
    }

    /**
     * <p>
     * The response type of the associated GatewayResponse.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #responseType} will
     * return {@link GatewayResponseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #responseTypeAsString}.
     * </p>
     * 
     * @return The response type of the associated GatewayResponse.
     * @see GatewayResponseType
     */
    public final String responseTypeAsString() {
        return responseType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(responseTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteGatewayResponseRequest)) {
            return false;
        }
        DeleteGatewayResponseRequest other = (DeleteGatewayResponseRequest) obj;
        return Objects.equals(restApiId(), other.restApiId())
                && Objects.equals(responseTypeAsString(), other.responseTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteGatewayResponseRequest").add("RestApiId", restApiId())
                .add("ResponseType", responseTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "responseType":
            return Optional.ofNullable(clazz.cast(responseTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("restapi_id", REST_API_ID_FIELD);
        map.put("response_type", RESPONSE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteGatewayResponseRequest, T> g) {
        return obj -> g.apply((DeleteGatewayResponseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteGatewayResponseRequest> {
        /**
         * <p>
         * The string identifier of the associated RestApi.
         * </p>
         * 
         * @param restApiId
         *        The string identifier of the associated RestApi.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * The response type of the associated GatewayResponse.
         * </p>
         * 
         * @param responseType
         *        The response type of the associated GatewayResponse.
         * @see GatewayResponseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayResponseType
         */
        Builder responseType(String responseType);

        /**
         * <p>
         * The response type of the associated GatewayResponse.
         * </p>
         * 
         * @param responseType
         *        The response type of the associated GatewayResponse.
         * @see GatewayResponseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayResponseType
         */
        Builder responseType(GatewayResponseType responseType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String restApiId;

        private String responseType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteGatewayResponseRequest model) {
            super(model);
            restApiId(model.restApiId);
            responseType(model.responseType);
        }

        public final String getRestApiId() {
            return restApiId;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final String getResponseType() {
            return responseType;
        }

        public final void setResponseType(String responseType) {
            this.responseType = responseType;
        }

        @Override
        public final Builder responseType(String responseType) {
            this.responseType = responseType;
            return this;
        }

        @Override
        public final Builder responseType(GatewayResponseType responseType) {
            this.responseType(responseType == null ? null : responseType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteGatewayResponseRequest build() {
            return new DeleteGatewayResponseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
