/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to delete the BasePathMapping resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteBasePathMappingRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<DeleteBasePathMappingRequest.Builder, DeleteBasePathMappingRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainName").getter(getter(DeleteBasePathMappingRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domain_name").build()).build();

    private static final SdkField<String> BASE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("basePath").getter(getter(DeleteBasePathMappingRequest::basePath)).setter(setter(Builder::basePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("base_path").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            BASE_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("domain_name", DOMAIN_NAME_FIELD);
                    put("base_path", BASE_PATH_FIELD);
                }
            });

    private final String domainName;

    private final String basePath;

    private DeleteBasePathMappingRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.basePath = builder.basePath;
    }

    /**
     * <p>
     * The domain name of the BasePathMapping resource to delete.
     * </p>
     * 
     * @return The domain name of the BasePathMapping resource to delete.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The base path name of the BasePathMapping resource to delete.
     * </p>
     * <p>
     * To specify an empty base path, set this parameter to <code>'(none)'</code>.
     * </p>
     * 
     * @return The base path name of the BasePathMapping resource to delete.</p>
     *         <p>
     *         To specify an empty base path, set this parameter to <code>'(none)'</code>.
     */
    public final String basePath() {
        return basePath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(basePath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBasePathMappingRequest)) {
            return false;
        }
        DeleteBasePathMappingRequest other = (DeleteBasePathMappingRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(basePath(), other.basePath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteBasePathMappingRequest").add("DomainName", domainName()).add("BasePath", basePath())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "basePath":
            return Optional.ofNullable(clazz.cast(basePath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteBasePathMappingRequest, T> g) {
        return obj -> g.apply((DeleteBasePathMappingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteBasePathMappingRequest> {
        /**
         * <p>
         * The domain name of the BasePathMapping resource to delete.
         * </p>
         * 
         * @param domainName
         *        The domain name of the BasePathMapping resource to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The base path name of the BasePathMapping resource to delete.
         * </p>
         * <p>
         * To specify an empty base path, set this parameter to <code>'(none)'</code>.
         * </p>
         * 
         * @param basePath
         *        The base path name of the BasePathMapping resource to delete.</p>
         *        <p>
         *        To specify an empty base path, set this parameter to <code>'(none)'</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basePath(String basePath);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String domainName;

        private String basePath;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBasePathMappingRequest model) {
            super(model);
            domainName(model.domainName);
            basePath(model.basePath);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getBasePath() {
            return basePath;
        }

        public final void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        @Override
        public final Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteBasePathMappingRequest build() {
            return new DeleteBasePathMappingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
