/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayResponse;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToListCopier;
import software.amazon.awssdk.services.apigateway.model.MapOfStringToStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestInvokeMethodResponse
extends ApiGatewayResponse
implements ToCopyableBuilder<Builder, TestInvokeMethodResponse> {
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("status").getter(TestInvokeMethodResponse.getter(TestInvokeMethodResponse::status)).setter(TestInvokeMethodResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("body").getter(TestInvokeMethodResponse.getter(TestInvokeMethodResponse::body)).setter(TestInvokeMethodResponse.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()}).build();
    private static final SdkField<Map<String, String>> HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("headers").getter(TestInvokeMethodResponse.getter(TestInvokeMethodResponse::headers)).setter(TestInvokeMethodResponse.setter(Builder::headers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<String>>> MULTI_VALUE_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("multiValueHeaders").getter(TestInvokeMethodResponse.getter(TestInvokeMethodResponse::multiValueHeaders)).setter(TestInvokeMethodResponse.setter(Builder::multiValueHeaders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiValueHeaders").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> LOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("log").getter(TestInvokeMethodResponse.getter(TestInvokeMethodResponse::log)).setter(TestInvokeMethodResponse.setter(Builder::log)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("log").build()}).build();
    private static final SdkField<Long> LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("latency").getter(TestInvokeMethodResponse.getter(TestInvokeMethodResponse::latency)).setter(TestInvokeMethodResponse.setter(Builder::latency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latency").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, BODY_FIELD, HEADERS_FIELD, MULTI_VALUE_HEADERS_FIELD, LOG_FIELD, LATENCY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TestInvokeMethodResponse.memberNameToFieldInitializer();
    private final Integer status;
    private final String body;
    private final Map<String, String> headers;
    private final Map<String, List<String>> multiValueHeaders;
    private final String log;
    private final Long latency;

    private TestInvokeMethodResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.body = builder.body;
        this.headers = builder.headers;
        this.multiValueHeaders = builder.multiValueHeaders;
        this.log = builder.log;
        this.latency = builder.latency;
    }

    public final Integer status() {
        return this.status;
    }

    public final String body() {
        return this.body;
    }

    public final boolean hasHeaders() {
        return this.headers != null && !(this.headers instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> headers() {
        return this.headers;
    }

    public final boolean hasMultiValueHeaders() {
        return this.multiValueHeaders != null && !(this.multiValueHeaders instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> multiValueHeaders() {
        return this.multiValueHeaders;
    }

    public final String log() {
        return this.log;
    }

    public final Long latency() {
        return this.latency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeaders() ? this.headers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMultiValueHeaders() ? this.multiValueHeaders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.log());
        hashCode = 31 * hashCode + Objects.hashCode(this.latency());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestInvokeMethodResponse)) {
            return false;
        }
        TestInvokeMethodResponse other = (TestInvokeMethodResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.body(), other.body()) && this.hasHeaders() == other.hasHeaders() && Objects.equals(this.headers(), other.headers()) && this.hasMultiValueHeaders() == other.hasMultiValueHeaders() && Objects.equals(this.multiValueHeaders(), other.multiValueHeaders()) && Objects.equals(this.log(), other.log()) && Objects.equals(this.latency(), other.latency());
    }

    public final String toString() {
        return ToString.builder((String)"TestInvokeMethodResponse").add("Status", (Object)this.status()).add("Body", (Object)this.body()).add("Headers", this.hasHeaders() ? this.headers() : null).add("MultiValueHeaders", this.hasMultiValueHeaders() ? this.multiValueHeaders() : null).add("Log", (Object)this.log()).add("Latency", (Object)this.latency()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "headers": {
                return Optional.ofNullable(clazz.cast(this.headers()));
            }
            case "multiValueHeaders": {
                return Optional.ofNullable(clazz.cast(this.multiValueHeaders()));
            }
            case "log": {
                return Optional.ofNullable(clazz.cast(this.log()));
            }
            case "latency": {
                return Optional.ofNullable(clazz.cast(this.latency()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", STATUS_FIELD);
        map.put("body", BODY_FIELD);
        map.put("headers", HEADERS_FIELD);
        map.put("multiValueHeaders", MULTI_VALUE_HEADERS_FIELD);
        map.put("log", LOG_FIELD);
        map.put("latency", LATENCY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestInvokeMethodResponse, T> g) {
        return obj -> g.apply((TestInvokeMethodResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayResponse.BuilderImpl
    implements Builder {
        private Integer status;
        private String body;
        private Map<String, String> headers = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, List<String>> multiValueHeaders = DefaultSdkAutoConstructMap.getInstance();
        private String log;
        private Long latency;

        private BuilderImpl() {
        }

        private BuilderImpl(TestInvokeMethodResponse model) {
            super(model);
            this.status(model.status);
            this.body(model.body);
            this.headers(model.headers);
            this.multiValueHeaders(model.multiValueHeaders);
            this.log(model.log);
            this.latency(model.latency);
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getBody() {
            return this.body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final Map<String, String> getHeaders() {
            if (this.headers instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.headers;
        }

        public final void setHeaders(Map<String, String> headers) {
            this.headers = MapOfStringToStringCopier.copy(headers);
        }

        @Override
        public final Builder headers(Map<String, String> headers) {
            this.headers = MapOfStringToStringCopier.copy(headers);
            return this;
        }

        public final Map<String, ? extends Collection<String>> getMultiValueHeaders() {
            if (this.multiValueHeaders instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.multiValueHeaders;
        }

        public final void setMultiValueHeaders(Map<String, ? extends Collection<String>> multiValueHeaders) {
            this.multiValueHeaders = MapOfStringToListCopier.copy(multiValueHeaders);
        }

        @Override
        public final Builder multiValueHeaders(Map<String, ? extends Collection<String>> multiValueHeaders) {
            this.multiValueHeaders = MapOfStringToListCopier.copy(multiValueHeaders);
            return this;
        }

        public final String getLog() {
            return this.log;
        }

        public final void setLog(String log) {
            this.log = log;
        }

        @Override
        public final Builder log(String log) {
            this.log = log;
            return this;
        }

        public final Long getLatency() {
            return this.latency;
        }

        public final void setLatency(Long latency) {
            this.latency = latency;
        }

        @Override
        public final Builder latency(Long latency) {
            this.latency = latency;
            return this;
        }

        @Override
        public TestInvokeMethodResponse build() {
            return new TestInvokeMethodResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ApiGatewayResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestInvokeMethodResponse> {
        public Builder status(Integer var1);

        public Builder body(String var1);

        public Builder headers(Map<String, String> var1);

        public Builder multiValueHeaders(Map<String, ? extends Collection<String>> var1);

        public Builder log(String var1);

        public Builder latency(Long var1);
    }
}

