/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.services.apigateway.model.ListOfStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourceRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, GetResourceRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("restApiId").getter(GetResourceRequest.getter(GetResourceRequest::restApiId)).setter(GetResourceRequest.setter(Builder::restApiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceId").getter(GetResourceRequest.getter(GetResourceRequest::resourceId)).setter(GetResourceRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("resource_id").build()}).build();
    private static final SdkField<List<String>> EMBED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("embed").getter(GetResourceRequest.getter(GetResourceRequest::embed)).setter(GetResourceRequest.setter(Builder::embed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("embed").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD, RESOURCE_ID_FIELD, EMBED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetResourceRequest.memberNameToFieldInitializer();
    private final String restApiId;
    private final String resourceId;
    private final List<String> embed;

    private GetResourceRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.resourceId = builder.resourceId;
        this.embed = builder.embed;
    }

    public final String restApiId() {
        return this.restApiId;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final boolean hasEmbed() {
        return this.embed != null && !(this.embed instanceof SdkAutoConstructList);
    }

    public final List<String> embed() {
        return this.embed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEmbed() ? this.embed() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceRequest)) {
            return false;
        }
        GetResourceRequest other = (GetResourceRequest)((Object)obj);
        return Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.resourceId(), other.resourceId()) && this.hasEmbed() == other.hasEmbed() && Objects.equals(this.embed(), other.embed());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourceRequest").add("RestApiId", (Object)this.restApiId()).add("ResourceId", (Object)this.resourceId()).add("Embed", this.hasEmbed() ? this.embed() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "embed": {
                return Optional.ofNullable(clazz.cast(this.embed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("restapi_id", REST_API_ID_FIELD);
        map.put("resource_id", RESOURCE_ID_FIELD);
        map.put("embed", EMBED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourceRequest, T> g) {
        return obj -> g.apply((GetResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String restApiId;
        private String resourceId;
        private List<String> embed = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceRequest model) {
            super(model);
            this.restApiId(model.restApiId);
            this.resourceId(model.resourceId);
            this.embed(model.embed);
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final Collection<String> getEmbed() {
            if (this.embed instanceof SdkAutoConstructList) {
                return null;
            }
            return this.embed;
        }

        public final void setEmbed(Collection<String> embed) {
            this.embed = ListOfStringCopier.copy(embed);
        }

        @Override
        public final Builder embed(Collection<String> embed) {
            this.embed = ListOfStringCopier.copy(embed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder embed(String ... embed) {
            this.embed(Arrays.asList(embed));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourceRequest build() {
            return new GetResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourceRequest> {
        public Builder restApiId(String var1);

        public Builder resourceId(String var1);

        public Builder embed(Collection<String> var1);

        public Builder embed(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

