/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Requests API Gateway to create a new BasePathMapping resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBasePathMappingRequest extends ApiGatewayRequest implements
        ToCopyableBuilder<CreateBasePathMappingRequest.Builder, CreateBasePathMappingRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainName").getter(getter(CreateBasePathMappingRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domain_name").build()).build();

    private static final SdkField<String> DOMAIN_NAME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainNameId").getter(getter(CreateBasePathMappingRequest::domainNameId))
            .setter(setter(Builder::domainNameId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domainNameId").build()).build();

    private static final SdkField<String> BASE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("basePath").getter(getter(CreateBasePathMappingRequest::basePath)).setter(setter(Builder::basePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basePath").build()).build();

    private static final SdkField<String> REST_API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("restApiId").getter(getter(CreateBasePathMappingRequest::restApiId)).setter(setter(Builder::restApiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restApiId").build()).build();

    private static final SdkField<String> STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("stage")
            .getter(getter(CreateBasePathMappingRequest::stage)).setter(setter(Builder::stage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            DOMAIN_NAME_ID_FIELD, BASE_PATH_FIELD, REST_API_ID_FIELD, STAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("domain_name", DOMAIN_NAME_FIELD);
                    put("domainNameId", DOMAIN_NAME_ID_FIELD);
                    put("basePath", BASE_PATH_FIELD);
                    put("restApiId", REST_API_ID_FIELD);
                    put("stage", STAGE_FIELD);
                }
            });

    private final String domainName;

    private final String domainNameId;

    private final String basePath;

    private final String restApiId;

    private final String stage;

    private CreateBasePathMappingRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.domainNameId = builder.domainNameId;
        this.basePath = builder.basePath;
        this.restApiId = builder.restApiId;
        this.stage = builder.stage;
    }

    /**
     * <p>
     * The domain name of the BasePathMapping resource to create.
     * </p>
     * 
     * @return The domain name of the BasePathMapping resource to create.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The identifier for the domain name resource. Supported only for private custom domain names.
     * </p>
     * 
     * @return The identifier for the domain name resource. Supported only for private custom domain names.
     */
    public final String domainNameId() {
        return domainNameId;
    }

    /**
     * <p>
     * The base path name that callers of the API must provide as part of the URL after the domain name. This value must
     * be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to specify a
     * base path name after the domain name.
     * </p>
     * 
     * @return The base path name that callers of the API must provide as part of the URL after the domain name. This
     *         value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want
     *         callers to specify a base path name after the domain name.
     */
    public final String basePath() {
        return basePath;
    }

    /**
     * <p>
     * The string identifier of the associated RestApi.
     * </p>
     * 
     * @return The string identifier of the associated RestApi.
     */
    public final String restApiId() {
        return restApiId;
    }

    /**
     * <p>
     * The name of the API's stage that you want to use for this mapping. Specify '(none)' if you want callers to
     * explicitly specify the stage name after any base path name.
     * </p>
     * 
     * @return The name of the API's stage that you want to use for this mapping. Specify '(none)' if you want callers
     *         to explicitly specify the stage name after any base path name.
     */
    public final String stage() {
        return stage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(domainNameId());
        hashCode = 31 * hashCode + Objects.hashCode(basePath());
        hashCode = 31 * hashCode + Objects.hashCode(restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(stage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBasePathMappingRequest)) {
            return false;
        }
        CreateBasePathMappingRequest other = (CreateBasePathMappingRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(domainNameId(), other.domainNameId())
                && Objects.equals(basePath(), other.basePath()) && Objects.equals(restApiId(), other.restApiId())
                && Objects.equals(stage(), other.stage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBasePathMappingRequest").add("DomainName", domainName())
                .add("DomainNameId", domainNameId()).add("BasePath", basePath()).add("RestApiId", restApiId())
                .add("Stage", stage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "domainNameId":
            return Optional.ofNullable(clazz.cast(domainNameId()));
        case "basePath":
            return Optional.ofNullable(clazz.cast(basePath()));
        case "restApiId":
            return Optional.ofNullable(clazz.cast(restApiId()));
        case "stage":
            return Optional.ofNullable(clazz.cast(stage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateBasePathMappingRequest, T> g) {
        return obj -> g.apply((CreateBasePathMappingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ApiGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateBasePathMappingRequest> {
        /**
         * <p>
         * The domain name of the BasePathMapping resource to create.
         * </p>
         * 
         * @param domainName
         *        The domain name of the BasePathMapping resource to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The identifier for the domain name resource. Supported only for private custom domain names.
         * </p>
         * 
         * @param domainNameId
         *        The identifier for the domain name resource. Supported only for private custom domain names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainNameId(String domainNameId);

        /**
         * <p>
         * The base path name that callers of the API must provide as part of the URL after the domain name. This value
         * must be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to
         * specify a base path name after the domain name.
         * </p>
         * 
         * @param basePath
         *        The base path name that callers of the API must provide as part of the URL after the domain name. This
         *        value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want
         *        callers to specify a base path name after the domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basePath(String basePath);

        /**
         * <p>
         * The string identifier of the associated RestApi.
         * </p>
         * 
         * @param restApiId
         *        The string identifier of the associated RestApi.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restApiId(String restApiId);

        /**
         * <p>
         * The name of the API's stage that you want to use for this mapping. Specify '(none)' if you want callers to
         * explicitly specify the stage name after any base path name.
         * </p>
         * 
         * @param stage
         *        The name of the API's stage that you want to use for this mapping. Specify '(none)' if you want
         *        callers to explicitly specify the stage name after any base path name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stage(String stage);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ApiGatewayRequest.BuilderImpl implements Builder {
        private String domainName;

        private String domainNameId;

        private String basePath;

        private String restApiId;

        private String stage;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBasePathMappingRequest model) {
            super(model);
            domainName(model.domainName);
            domainNameId(model.domainNameId);
            basePath(model.basePath);
            restApiId(model.restApiId);
            stage(model.stage);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getDomainNameId() {
            return domainNameId;
        }

        public final void setDomainNameId(String domainNameId) {
            this.domainNameId = domainNameId;
        }

        @Override
        public final Builder domainNameId(String domainNameId) {
            this.domainNameId = domainNameId;
            return this;
        }

        public final String getBasePath() {
            return basePath;
        }

        public final void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        @Override
        public final Builder basePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public final String getRestApiId() {
            return restApiId;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final String getStage() {
            return stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBasePathMappingRequest build() {
            return new CreateBasePathMappingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
