/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apigateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Access log settings, including the access log format and access log destination ARN.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessLogSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessLogSettings.Builder, AccessLogSettings> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(AccessLogSettings::format)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<String> DESTINATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationArn").getter(getter(AccessLogSettings::destinationArn))
            .setter(setter(Builder::destinationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD,
            DESTINATION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("format", FORMAT_FIELD);
                    put("destinationArn", DESTINATION_ARN_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String format;

    private final String destinationArn;

    private AccessLogSettings(BuilderImpl builder) {
        this.format = builder.format;
        this.destinationArn = builder.destinationArn;
    }

    /**
     * <p>
     * A single line format of the access logs of data, as specified by selected $context variables. The format must
     * include at least <code>$context.requestId</code>.
     * </p>
     * 
     * @return A single line format of the access logs of data, as specified by selected $context variables. The format
     *         must include at least <code>$context.requestId</code>.
     */
    public final String format() {
        return format;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to
     * receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with
     * <code>amazon-apigateway-</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream
     *         to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must
     *         begin with <code>amazon-apigateway-</code>.
     */
    public final String destinationArn() {
        return destinationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(format());
        hashCode = 31 * hashCode + Objects.hashCode(destinationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessLogSettings)) {
            return false;
        }
        AccessLogSettings other = (AccessLogSettings) obj;
        return Objects.equals(format(), other.format()) && Objects.equals(destinationArn(), other.destinationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessLogSettings").add("Format", format()).add("DestinationArn", destinationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "format":
            return Optional.ofNullable(clazz.cast(format()));
        case "destinationArn":
            return Optional.ofNullable(clazz.cast(destinationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AccessLogSettings, T> g) {
        return obj -> g.apply((AccessLogSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessLogSettings> {
        /**
         * <p>
         * A single line format of the access logs of data, as specified by selected $context variables. The format must
         * include at least <code>$context.requestId</code>.
         * </p>
         * 
         * @param format
         *        A single line format of the access logs of data, as specified by selected $context variables. The
         *        format must include at least <code>$context.requestId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder format(String format);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery stream to
         * receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name must begin with
         * <code>amazon-apigateway-</code>.
         * </p>
         * 
         * @param destinationArn
         *        The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis Data Firehose delivery
         *        stream to receive access logs. If you specify a Kinesis Data Firehose delivery stream, the stream name
         *        must begin with <code>amazon-apigateway-</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationArn(String destinationArn);
    }

    static final class BuilderImpl implements Builder {
        private String format;

        private String destinationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessLogSettings model) {
            format(model.format);
            destinationArn(model.destinationArn);
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final String getDestinationArn() {
            return destinationArn;
        }

        public final void setDestinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
        }

        @Override
        public final Builder destinationArn(String destinationArn) {
            this.destinationArn = destinationArn;
            return this;
        }

        @Override
        public AccessLogSettings build() {
            return new AccessLogSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
