/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigateway.model.ApiGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteRequestValidatorRequest
extends ApiGatewayRequest
implements ToCopyableBuilder<Builder, DeleteRequestValidatorRequest> {
    private static final SdkField<String> REST_API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteRequestValidatorRequest.getter(DeleteRequestValidatorRequest::restApiId)).setter(DeleteRequestValidatorRequest.setter(Builder::restApiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("restapi_id").build()}).build();
    private static final SdkField<String> REQUEST_VALIDATOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeleteRequestValidatorRequest.getter(DeleteRequestValidatorRequest::requestValidatorId)).setter(DeleteRequestValidatorRequest.setter(Builder::requestValidatorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("requestvalidator_id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REST_API_ID_FIELD, REQUEST_VALIDATOR_ID_FIELD));
    private final String restApiId;
    private final String requestValidatorId;

    private DeleteRequestValidatorRequest(BuilderImpl builder) {
        super(builder);
        this.restApiId = builder.restApiId;
        this.requestValidatorId = builder.requestValidatorId;
    }

    public String restApiId() {
        return this.restApiId;
    }

    public String requestValidatorId() {
        return this.requestValidatorId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.restApiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestValidatorId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteRequestValidatorRequest)) {
            return false;
        }
        DeleteRequestValidatorRequest other = (DeleteRequestValidatorRequest)((Object)obj);
        return Objects.equals(this.restApiId(), other.restApiId()) && Objects.equals(this.requestValidatorId(), other.requestValidatorId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteRequestValidatorRequest").add("RestApiId", (Object)this.restApiId()).add("RequestValidatorId", (Object)this.requestValidatorId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "restApiId": {
                return Optional.ofNullable(clazz.cast(this.restApiId()));
            }
            case "requestValidatorId": {
                return Optional.ofNullable(clazz.cast(this.requestValidatorId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteRequestValidatorRequest, T> g) {
        return obj -> g.apply((DeleteRequestValidatorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayRequest.BuilderImpl
    implements Builder {
        private String restApiId;
        private String requestValidatorId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteRequestValidatorRequest model) {
            super(model);
            this.restApiId(model.restApiId);
            this.requestValidatorId(model.requestValidatorId);
        }

        public final String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public final Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public final void setRestApiId(String restApiId) {
            this.restApiId = restApiId;
        }

        public final String getRequestValidatorId() {
            return this.requestValidatorId;
        }

        @Override
        public final Builder requestValidatorId(String requestValidatorId) {
            this.requestValidatorId = requestValidatorId;
            return this;
        }

        public final void setRequestValidatorId(String requestValidatorId) {
            this.requestValidatorId = requestValidatorId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteRequestValidatorRequest build() {
            return new DeleteRequestValidatorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteRequestValidatorRequest> {
        public Builder restApiId(String var1);

        public Builder requestValidatorId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

