/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeliveryMethod {
    EMAIL("EMAIL"),
    SMS("SMS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeliveryMethod> VALUE_MAP;
    private final String value;

    private DeliveryMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeliveryMethod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeliveryMethod> knownValues() {
        EnumSet<DeliveryMethod> knownValues = EnumSet.allOf(DeliveryMethod.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeliveryMethod.class, DeliveryMethod::toString);
    }
}

