/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.amplifybackend.AmplifyBackendAsyncClient;
import software.amazon.awssdk.services.amplifybackend.internal.UserAgentUtils;
import software.amazon.awssdk.services.amplifybackend.model.BackendJobRespObj;
import software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest;
import software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsResponse;

public class ListBackendJobsPublisher
implements SdkPublisher<ListBackendJobsResponse> {
    private final AmplifyBackendAsyncClient client;
    private final ListBackendJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBackendJobsPublisher(AmplifyBackendAsyncClient client, ListBackendJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBackendJobsPublisher(AmplifyBackendAsyncClient client, ListBackendJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBackendJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBackendJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BackendJobRespObj> jobs() {
        Function<ListBackendJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobs() != null) {
                return response.jobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBackendJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBackendJobsResponseFetcher
    implements AsyncPageFetcher<ListBackendJobsResponse> {
        private ListBackendJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListBackendJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBackendJobsResponse> nextPage(ListBackendJobsResponse previousPage) {
            if (previousPage == null) {
                return ListBackendJobsPublisher.this.client.listBackendJobs(ListBackendJobsPublisher.this.firstRequest);
            }
            return ListBackendJobsPublisher.this.client.listBackendJobs((ListBackendJobsRequest)((Object)ListBackendJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

