/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.amplifybackend.AmplifyBackendClient;
import software.amazon.awssdk.services.amplifybackend.internal.UserAgentUtils;
import software.amazon.awssdk.services.amplifybackend.model.BackendJobRespObj;
import software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest;
import software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsResponse;

public class ListBackendJobsIterable
implements SdkIterable<ListBackendJobsResponse> {
    private final AmplifyBackendClient client;
    private final ListBackendJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBackendJobsIterable(AmplifyBackendClient client, ListBackendJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBackendJobsResponseFetcher();
    }

    public Iterator<ListBackendJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BackendJobRespObj> jobs() {
        Function<ListBackendJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobs() != null) {
                return response.jobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBackendJobsResponseFetcher
    implements SyncPageFetcher<ListBackendJobsResponse> {
        private ListBackendJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListBackendJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBackendJobsResponse nextPage(ListBackendJobsResponse previousPage) {
            if (previousPage == null) {
                return ListBackendJobsIterable.this.client.listBackendJobs(ListBackendJobsIterable.this.firstRequest);
            }
            return ListBackendJobsIterable.this.client.listBackendJobs((ListBackendJobsRequest)((Object)ListBackendJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

