/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the authorization configuration for the Amazon Cognito identity pool, provisioned as a part of your auth
 * resource in the Amplify project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBackendAuthIdentityPoolConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateBackendAuthIdentityPoolConfig.Builder, UpdateBackendAuthIdentityPoolConfig> {
    private static final SdkField<Boolean> UNAUTHENTICATED_LOGIN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UnauthenticatedLogin").getter(getter(UpdateBackendAuthIdentityPoolConfig::unauthenticatedLogin))
            .setter(setter(Builder::unauthenticatedLogin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unauthenticatedLogin").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNAUTHENTICATED_LOGIN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean unauthenticatedLogin;

    private UpdateBackendAuthIdentityPoolConfig(BuilderImpl builder) {
        this.unauthenticatedLogin = builder.unauthenticatedLogin;
    }

    /**
     * <p>
     * A boolean value that can be set to allow or disallow guest-level authorization into your Amplify app.
     * </p>
     * 
     * @return A boolean value that can be set to allow or disallow guest-level authorization into your Amplify app.
     */
    public final Boolean unauthenticatedLogin() {
        return unauthenticatedLogin;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(unauthenticatedLogin());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBackendAuthIdentityPoolConfig)) {
            return false;
        }
        UpdateBackendAuthIdentityPoolConfig other = (UpdateBackendAuthIdentityPoolConfig) obj;
        return Objects.equals(unauthenticatedLogin(), other.unauthenticatedLogin());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBackendAuthIdentityPoolConfig").add("UnauthenticatedLogin", unauthenticatedLogin())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UnauthenticatedLogin":
            return Optional.ofNullable(clazz.cast(unauthenticatedLogin()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBackendAuthIdentityPoolConfig, T> g) {
        return obj -> g.apply((UpdateBackendAuthIdentityPoolConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateBackendAuthIdentityPoolConfig> {
        /**
         * <p>
         * A boolean value that can be set to allow or disallow guest-level authorization into your Amplify app.
         * </p>
         * 
         * @param unauthenticatedLogin
         *        A boolean value that can be set to allow or disallow guest-level authorization into your Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unauthenticatedLogin(Boolean unauthenticatedLogin);
    }

    static final class BuilderImpl implements Builder {
        private Boolean unauthenticatedLogin;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBackendAuthIdentityPoolConfig model) {
            unauthenticatedLogin(model.unauthenticatedLogin);
        }

        public final Boolean getUnauthenticatedLogin() {
            return unauthenticatedLogin;
        }

        public final void setUnauthenticatedLogin(Boolean unauthenticatedLogin) {
            this.unauthenticatedLogin = unauthenticatedLogin;
        }

        @Override
        public final Builder unauthenticatedLogin(Boolean unauthenticatedLogin) {
            this.unauthenticatedLogin = unauthenticatedLogin;
            return this;
        }

        @Override
        public UpdateBackendAuthIdentityPoolConfig build() {
            return new UpdateBackendAuthIdentityPoolConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
