/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplifybackend.model.AmplifyBackendResponse;
import software.amazon.awssdk.services.amplifybackend.model.BackendAPIResourceConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBackendApiResponse
extends AmplifyBackendResponse
implements ToCopyableBuilder<Builder, GetBackendApiResponse> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppId").getter(GetBackendApiResponse.getter(GetBackendApiResponse::appId)).setter(GetBackendApiResponse.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()}).build();
    private static final SdkField<String> BACKEND_ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackendEnvironmentName").getter(GetBackendApiResponse.getter(GetBackendApiResponse::backendEnvironmentName)).setter(GetBackendApiResponse.setter(Builder::backendEnvironmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendEnvironmentName").build()}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Error").getter(GetBackendApiResponse.getter(GetBackendApiResponse::error)).setter(GetBackendApiResponse.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<BackendAPIResourceConfig> RESOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceConfig").getter(GetBackendApiResponse.getter(GetBackendApiResponse::resourceConfig)).setter(GetBackendApiResponse.setter(Builder::resourceConfig)).constructor(BackendAPIResourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfig").build()}).build();
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceName").getter(GetBackendApiResponse.getter(GetBackendApiResponse::resourceName)).setter(GetBackendApiResponse.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, BACKEND_ENVIRONMENT_NAME_FIELD, ERROR_FIELD, RESOURCE_CONFIG_FIELD, RESOURCE_NAME_FIELD));
    private final String appId;
    private final String backendEnvironmentName;
    private final String error;
    private final BackendAPIResourceConfig resourceConfig;
    private final String resourceName;

    private GetBackendApiResponse(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.backendEnvironmentName = builder.backendEnvironmentName;
        this.error = builder.error;
        this.resourceConfig = builder.resourceConfig;
        this.resourceName = builder.resourceName;
    }

    public final String appId() {
        return this.appId;
    }

    public final String backendEnvironmentName() {
        return this.backendEnvironmentName;
    }

    public final String error() {
        return this.error;
    }

    public final BackendAPIResourceConfig resourceConfig() {
        return this.resourceConfig;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.backendEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBackendApiResponse)) {
            return false;
        }
        GetBackendApiResponse other = (GetBackendApiResponse)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.backendEnvironmentName(), other.backendEnvironmentName()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.resourceConfig(), other.resourceConfig()) && Objects.equals(this.resourceName(), other.resourceName());
    }

    public final String toString() {
        return ToString.builder((String)"GetBackendApiResponse").add("AppId", (Object)this.appId()).add("BackendEnvironmentName", (Object)this.backendEnvironmentName()).add("Error", (Object)this.error()).add("ResourceConfig", (Object)this.resourceConfig()).add("ResourceName", (Object)this.resourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "BackendEnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.backendEnvironmentName()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "ResourceConfig": {
                return Optional.ofNullable(clazz.cast(this.resourceConfig()));
            }
            case "ResourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBackendApiResponse, T> g) {
        return obj -> g.apply((GetBackendApiResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyBackendResponse.BuilderImpl
    implements Builder {
        private String appId;
        private String backendEnvironmentName;
        private String error;
        private BackendAPIResourceConfig resourceConfig;
        private String resourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBackendApiResponse model) {
            super(model);
            this.appId(model.appId);
            this.backendEnvironmentName(model.backendEnvironmentName);
            this.error(model.error);
            this.resourceConfig(model.resourceConfig);
            this.resourceName(model.resourceName);
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getBackendEnvironmentName() {
            return this.backendEnvironmentName;
        }

        public final void setBackendEnvironmentName(String backendEnvironmentName) {
            this.backendEnvironmentName = backendEnvironmentName;
        }

        @Override
        public final Builder backendEnvironmentName(String backendEnvironmentName) {
            this.backendEnvironmentName = backendEnvironmentName;
            return this;
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final BackendAPIResourceConfig.Builder getResourceConfig() {
            return this.resourceConfig != null ? this.resourceConfig.toBuilder() : null;
        }

        public final void setResourceConfig(BackendAPIResourceConfig.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        @Override
        public final Builder resourceConfig(BackendAPIResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        @Override
        public GetBackendApiResponse build() {
            return new GetBackendApiResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AmplifyBackendResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBackendApiResponse> {
        public Builder appId(String var1);

        public Builder backendEnvironmentName(String var1);

        public Builder error(String var1);

        public Builder resourceConfig(BackendAPIResourceConfig var1);

        default public Builder resourceConfig(Consumer<BackendAPIResourceConfig.Builder> resourceConfig) {
            return this.resourceConfig((BackendAPIResourceConfig)((BackendAPIResourceConfig.Builder)BackendAPIResourceConfig.builder().applyMutation(resourceConfig)).build());
        }

        public Builder resourceName(String var1);
    }
}

