/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * SMS settings for authentication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SmsSettings implements SdkPojo, Serializable, ToCopyableBuilder<SmsSettings.Builder, SmsSettings> {
    private static final SdkField<String> SMS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SmsMessage").getter(getter(SmsSettings::smsMessage)).setter(setter(Builder::smsMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("smsMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SMS_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String smsMessage;

    private SmsSettings(BuilderImpl builder) {
        this.smsMessage = builder.smsMessage;
    }

    /**
     * <p>
     * The body of the SMS message.
     * </p>
     * 
     * @return The body of the SMS message.
     */
    public final String smsMessage() {
        return smsMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(smsMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SmsSettings)) {
            return false;
        }
        SmsSettings other = (SmsSettings) obj;
        return Objects.equals(smsMessage(), other.smsMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SmsSettings").add("SmsMessage", smsMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SmsMessage":
            return Optional.ofNullable(clazz.cast(smsMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SmsSettings, T> g) {
        return obj -> g.apply((SmsSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SmsSettings> {
        /**
         * <p>
         * The body of the SMS message.
         * </p>
         * 
         * @param smsMessage
         *        The body of the SMS message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder smsMessage(String smsMessage);
    }

    static final class BuilderImpl implements Builder {
        private String smsMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(SmsSettings model) {
            smsMessage(model.smsMessage);
        }

        public final String getSmsMessage() {
            return smsMessage;
        }

        @Override
        public final Builder smsMessage(String smsMessage) {
            this.smsMessage = smsMessage;
            return this;
        }

        public final void setSmsMessage(String smsMessage) {
            this.smsMessage = smsMessage;
        }

        @Override
        public SmsSettings build() {
            return new SmsSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
