/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resource configuration for the data model, configured as a part of the Amplify project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BackendAPIResourceConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<BackendAPIResourceConfig.Builder, BackendAPIResourceConfig> {
    private static final SdkField<List<BackendAPIAuthType>> ADDITIONAL_AUTH_TYPES_FIELD = SdkField
            .<List<BackendAPIAuthType>> builder(MarshallingType.LIST)
            .memberName("AdditionalAuthTypes")
            .getter(getter(BackendAPIResourceConfig::additionalAuthTypes))
            .setter(setter(Builder::additionalAuthTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalAuthTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BackendAPIAuthType> builder(MarshallingType.SDK_POJO)
                                            .constructor(BackendAPIAuthType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> API_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApiName").getter(getter(BackendAPIResourceConfig::apiName)).setter(setter(Builder::apiName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiName").build()).build();

    private static final SdkField<BackendAPIConflictResolution> CONFLICT_RESOLUTION_FIELD = SdkField
            .<BackendAPIConflictResolution> builder(MarshallingType.SDK_POJO).memberName("ConflictResolution")
            .getter(getter(BackendAPIResourceConfig::conflictResolution)).setter(setter(Builder::conflictResolution))
            .constructor(BackendAPIConflictResolution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictResolution").build())
            .build();

    private static final SdkField<BackendAPIAuthType> DEFAULT_AUTH_TYPE_FIELD = SdkField
            .<BackendAPIAuthType> builder(MarshallingType.SDK_POJO).memberName("DefaultAuthType")
            .getter(getter(BackendAPIResourceConfig::defaultAuthType)).setter(setter(Builder::defaultAuthType))
            .constructor(BackendAPIAuthType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultAuthType").build()).build();

    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Service")
            .getter(getter(BackendAPIResourceConfig::service)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()).build();

    private static final SdkField<String> TRANSFORM_SCHEMA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransformSchema").getter(getter(BackendAPIResourceConfig::transformSchema))
            .setter(setter(Builder::transformSchema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformSchema").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_AUTH_TYPES_FIELD,
            API_NAME_FIELD, CONFLICT_RESOLUTION_FIELD, DEFAULT_AUTH_TYPE_FIELD, SERVICE_FIELD, TRANSFORM_SCHEMA_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<BackendAPIAuthType> additionalAuthTypes;

    private final String apiName;

    private final BackendAPIConflictResolution conflictResolution;

    private final BackendAPIAuthType defaultAuthType;

    private final String service;

    private final String transformSchema;

    private BackendAPIResourceConfig(BuilderImpl builder) {
        this.additionalAuthTypes = builder.additionalAuthTypes;
        this.apiName = builder.apiName;
        this.conflictResolution = builder.conflictResolution;
        this.defaultAuthType = builder.defaultAuthType;
        this.service = builder.service;
        this.transformSchema = builder.transformSchema;
    }

    /**
     * Returns true if the AdditionalAuthTypes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAdditionalAuthTypes() {
        return additionalAuthTypes != null && !(additionalAuthTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Additional authentication methods used to interact with your data models.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdditionalAuthTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Additional authentication methods used to interact with your data models.
     */
    public final List<BackendAPIAuthType> additionalAuthTypes() {
        return additionalAuthTypes;
    }

    /**
     * <p>
     * The API name used to interact with the data model, configured as a part of the Amplify project.
     * </p>
     * 
     * @return The API name used to interact with the data model, configured as a part of the Amplify project.
     */
    public final String apiName() {
        return apiName;
    }

    /**
     * <p>
     * The conflict resolution strategy for your data stored in the data models.
     * </p>
     * 
     * @return The conflict resolution strategy for your data stored in the data models.
     */
    public final BackendAPIConflictResolution conflictResolution() {
        return conflictResolution;
    }

    /**
     * <p>
     * The default authentication type for interacting with the configured data models in your Amplify project.
     * </p>
     * 
     * @return The default authentication type for interacting with the configured data models in your Amplify project.
     */
    public final BackendAPIAuthType defaultAuthType() {
        return defaultAuthType;
    }

    /**
     * <p>
     * The service used to provision and interact with the data model.
     * </p>
     * 
     * @return The service used to provision and interact with the data model.
     */
    public final String service() {
        return service;
    }

    /**
     * <p>
     * The definition of the data model in the annotated transform of the GraphQL schema.
     * </p>
     * 
     * @return The definition of the data model in the annotated transform of the GraphQL schema.
     */
    public final String transformSchema() {
        return transformSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalAuthTypes() ? additionalAuthTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(apiName());
        hashCode = 31 * hashCode + Objects.hashCode(conflictResolution());
        hashCode = 31 * hashCode + Objects.hashCode(defaultAuthType());
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(transformSchema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackendAPIResourceConfig)) {
            return false;
        }
        BackendAPIResourceConfig other = (BackendAPIResourceConfig) obj;
        return hasAdditionalAuthTypes() == other.hasAdditionalAuthTypes()
                && Objects.equals(additionalAuthTypes(), other.additionalAuthTypes())
                && Objects.equals(apiName(), other.apiName()) && Objects.equals(conflictResolution(), other.conflictResolution())
                && Objects.equals(defaultAuthType(), other.defaultAuthType()) && Objects.equals(service(), other.service())
                && Objects.equals(transformSchema(), other.transformSchema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BackendAPIResourceConfig")
                .add("AdditionalAuthTypes", hasAdditionalAuthTypes() ? additionalAuthTypes() : null).add("ApiName", apiName())
                .add("ConflictResolution", conflictResolution()).add("DefaultAuthType", defaultAuthType())
                .add("Service", service()).add("TransformSchema", transformSchema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdditionalAuthTypes":
            return Optional.ofNullable(clazz.cast(additionalAuthTypes()));
        case "ApiName":
            return Optional.ofNullable(clazz.cast(apiName()));
        case "ConflictResolution":
            return Optional.ofNullable(clazz.cast(conflictResolution()));
        case "DefaultAuthType":
            return Optional.ofNullable(clazz.cast(defaultAuthType()));
        case "Service":
            return Optional.ofNullable(clazz.cast(service()));
        case "TransformSchema":
            return Optional.ofNullable(clazz.cast(transformSchema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackendAPIResourceConfig, T> g) {
        return obj -> g.apply((BackendAPIResourceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BackendAPIResourceConfig> {
        /**
         * <p>
         * Additional authentication methods used to interact with your data models.
         * </p>
         * 
         * @param additionalAuthTypes
         *        Additional authentication methods used to interact with your data models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAuthTypes(Collection<BackendAPIAuthType> additionalAuthTypes);

        /**
         * <p>
         * Additional authentication methods used to interact with your data models.
         * </p>
         * 
         * @param additionalAuthTypes
         *        Additional authentication methods used to interact with your data models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAuthTypes(BackendAPIAuthType... additionalAuthTypes);

        /**
         * <p>
         * Additional authentication methods used to interact with your data models.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BackendAPIAuthType>.Builder} avoiding the
         * need to create one manually via {@link List<BackendAPIAuthType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BackendAPIAuthType>.Builder#build()} is called immediately
         * and its result is passed to {@link #additionalAuthTypes(List<BackendAPIAuthType>)}.
         * 
         * @param additionalAuthTypes
         *        a consumer that will call methods on {@link List<BackendAPIAuthType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalAuthTypes(List<BackendAPIAuthType>)
         */
        Builder additionalAuthTypes(Consumer<BackendAPIAuthType.Builder>... additionalAuthTypes);

        /**
         * <p>
         * The API name used to interact with the data model, configured as a part of the Amplify project.
         * </p>
         * 
         * @param apiName
         *        The API name used to interact with the data model, configured as a part of the Amplify project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiName(String apiName);

        /**
         * <p>
         * The conflict resolution strategy for your data stored in the data models.
         * </p>
         * 
         * @param conflictResolution
         *        The conflict resolution strategy for your data stored in the data models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conflictResolution(BackendAPIConflictResolution conflictResolution);

        /**
         * <p>
         * The conflict resolution strategy for your data stored in the data models.
         * </p>
         * This is a convenience that creates an instance of the {@link BackendAPIConflictResolution.Builder} avoiding
         * the need to create one manually via {@link BackendAPIConflictResolution#builder()}.
         *
         * When the {@link Consumer} completes, {@link BackendAPIConflictResolution.Builder#build()} is called
         * immediately and its result is passed to {@link #conflictResolution(BackendAPIConflictResolution)}.
         * 
         * @param conflictResolution
         *        a consumer that will call methods on {@link BackendAPIConflictResolution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conflictResolution(BackendAPIConflictResolution)
         */
        default Builder conflictResolution(Consumer<BackendAPIConflictResolution.Builder> conflictResolution) {
            return conflictResolution(BackendAPIConflictResolution.builder().applyMutation(conflictResolution).build());
        }

        /**
         * <p>
         * The default authentication type for interacting with the configured data models in your Amplify project.
         * </p>
         * 
         * @param defaultAuthType
         *        The default authentication type for interacting with the configured data models in your Amplify
         *        project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultAuthType(BackendAPIAuthType defaultAuthType);

        /**
         * <p>
         * The default authentication type for interacting with the configured data models in your Amplify project.
         * </p>
         * This is a convenience that creates an instance of the {@link BackendAPIAuthType.Builder} avoiding the need to
         * create one manually via {@link BackendAPIAuthType#builder()}.
         *
         * When the {@link Consumer} completes, {@link BackendAPIAuthType.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultAuthType(BackendAPIAuthType)}.
         * 
         * @param defaultAuthType
         *        a consumer that will call methods on {@link BackendAPIAuthType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultAuthType(BackendAPIAuthType)
         */
        default Builder defaultAuthType(Consumer<BackendAPIAuthType.Builder> defaultAuthType) {
            return defaultAuthType(BackendAPIAuthType.builder().applyMutation(defaultAuthType).build());
        }

        /**
         * <p>
         * The service used to provision and interact with the data model.
         * </p>
         * 
         * @param service
         *        The service used to provision and interact with the data model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(String service);

        /**
         * <p>
         * The definition of the data model in the annotated transform of the GraphQL schema.
         * </p>
         * 
         * @param transformSchema
         *        The definition of the data model in the annotated transform of the GraphQL schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformSchema(String transformSchema);
    }

    static final class BuilderImpl implements Builder {
        private List<BackendAPIAuthType> additionalAuthTypes = DefaultSdkAutoConstructList.getInstance();

        private String apiName;

        private BackendAPIConflictResolution conflictResolution;

        private BackendAPIAuthType defaultAuthType;

        private String service;

        private String transformSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(BackendAPIResourceConfig model) {
            additionalAuthTypes(model.additionalAuthTypes);
            apiName(model.apiName);
            conflictResolution(model.conflictResolution);
            defaultAuthType(model.defaultAuthType);
            service(model.service);
            transformSchema(model.transformSchema);
        }

        public final List<BackendAPIAuthType.Builder> getAdditionalAuthTypes() {
            List<BackendAPIAuthType.Builder> result = ListOfBackendAPIAuthTypeCopier.copyToBuilder(this.additionalAuthTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder additionalAuthTypes(Collection<BackendAPIAuthType> additionalAuthTypes) {
            this.additionalAuthTypes = ListOfBackendAPIAuthTypeCopier.copy(additionalAuthTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAuthTypes(BackendAPIAuthType... additionalAuthTypes) {
            additionalAuthTypes(Arrays.asList(additionalAuthTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAuthTypes(Consumer<BackendAPIAuthType.Builder>... additionalAuthTypes) {
            additionalAuthTypes(Stream.of(additionalAuthTypes).map(c -> BackendAPIAuthType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAdditionalAuthTypes(Collection<BackendAPIAuthType.BuilderImpl> additionalAuthTypes) {
            this.additionalAuthTypes = ListOfBackendAPIAuthTypeCopier.copyFromBuilder(additionalAuthTypes);
        }

        public final String getApiName() {
            return apiName;
        }

        @Override
        public final Builder apiName(String apiName) {
            this.apiName = apiName;
            return this;
        }

        public final void setApiName(String apiName) {
            this.apiName = apiName;
        }

        public final BackendAPIConflictResolution.Builder getConflictResolution() {
            return conflictResolution != null ? conflictResolution.toBuilder() : null;
        }

        @Override
        public final Builder conflictResolution(BackendAPIConflictResolution conflictResolution) {
            this.conflictResolution = conflictResolution;
            return this;
        }

        public final void setConflictResolution(BackendAPIConflictResolution.BuilderImpl conflictResolution) {
            this.conflictResolution = conflictResolution != null ? conflictResolution.build() : null;
        }

        public final BackendAPIAuthType.Builder getDefaultAuthType() {
            return defaultAuthType != null ? defaultAuthType.toBuilder() : null;
        }

        @Override
        public final Builder defaultAuthType(BackendAPIAuthType defaultAuthType) {
            this.defaultAuthType = defaultAuthType;
            return this;
        }

        public final void setDefaultAuthType(BackendAPIAuthType.BuilderImpl defaultAuthType) {
            this.defaultAuthType = defaultAuthType != null ? defaultAuthType.build() : null;
        }

        public final String getService() {
            return service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final void setService(String service) {
            this.service = service;
        }

        public final String getTransformSchema() {
            return transformSchema;
        }

        @Override
        public final Builder transformSchema(String transformSchema) {
            this.transformSchema = transformSchema;
            return this;
        }

        public final void setTransformSchema(String transformSchema) {
            this.transformSchema = transformSchema;
        }

        @Override
        public BackendAPIResourceConfig build() {
            return new BackendAPIResourceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
