/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the auth types for your configured data models.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BackendAPIAuthType implements SdkPojo, Serializable,
        ToCopyableBuilder<BackendAPIAuthType.Builder, BackendAPIAuthType> {
    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(BackendAPIAuthType::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()).build();

    private static final SdkField<BackendAPIAppSyncAuthSettings> SETTINGS_FIELD = SdkField
            .<BackendAPIAppSyncAuthSettings> builder(MarshallingType.SDK_POJO).memberName("Settings")
            .getter(getter(BackendAPIAuthType::settings)).setter(setter(Builder::settings))
            .constructor(BackendAPIAppSyncAuthSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, SETTINGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mode;

    private final BackendAPIAppSyncAuthSettings settings;

    private BackendAPIAuthType(BuilderImpl builder) {
        this.mode = builder.mode;
        this.settings = builder.settings;
    }

    /**
     * <p>
     * Describes the authentication mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link Mode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Describes the authentication mode.
     * @see Mode
     */
    public final Mode mode() {
        return Mode.fromValue(mode);
    }

    /**
     * <p>
     * Describes the authentication mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link Mode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Describes the authentication mode.
     * @see Mode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * Describes settings for the authentication mode.
     * </p>
     * 
     * @return Describes settings for the authentication mode.
     */
    public final BackendAPIAppSyncAuthSettings settings() {
        return settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackendAPIAuthType)) {
            return false;
        }
        BackendAPIAuthType other = (BackendAPIAuthType) obj;
        return Objects.equals(modeAsString(), other.modeAsString()) && Objects.equals(settings(), other.settings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BackendAPIAuthType").add("Mode", modeAsString()).add("Settings", settings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BackendAPIAuthType, T> g) {
        return obj -> g.apply((BackendAPIAuthType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BackendAPIAuthType> {
        /**
         * <p>
         * Describes the authentication mode.
         * </p>
         * 
         * @param mode
         *        Describes the authentication mode.
         * @see Mode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mode
         */
        Builder mode(String mode);

        /**
         * <p>
         * Describes the authentication mode.
         * </p>
         * 
         * @param mode
         *        Describes the authentication mode.
         * @see Mode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mode
         */
        Builder mode(Mode mode);

        /**
         * <p>
         * Describes settings for the authentication mode.
         * </p>
         * 
         * @param settings
         *        Describes settings for the authentication mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(BackendAPIAppSyncAuthSettings settings);

        /**
         * <p>
         * Describes settings for the authentication mode.
         * </p>
         * This is a convenience that creates an instance of the {@link BackendAPIAppSyncAuthSettings.Builder} avoiding
         * the need to create one manually via {@link BackendAPIAppSyncAuthSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link BackendAPIAppSyncAuthSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #settings(BackendAPIAppSyncAuthSettings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link BackendAPIAppSyncAuthSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(BackendAPIAppSyncAuthSettings)
         */
        default Builder settings(Consumer<BackendAPIAppSyncAuthSettings.Builder> settings) {
            return settings(BackendAPIAppSyncAuthSettings.builder().applyMutation(settings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String mode;

        private BackendAPIAppSyncAuthSettings settings;

        private BuilderImpl() {
        }

        private BuilderImpl(BackendAPIAuthType model) {
            mode(model.mode);
            settings(model.settings);
        }

        public final String getMode() {
            return mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(Mode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        public final BackendAPIAppSyncAuthSettings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        @Override
        public final Builder settings(BackendAPIAppSyncAuthSettings settings) {
            this.settings = settings;
            return this;
        }

        public final void setSettings(BackendAPIAppSyncAuthSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        public BackendAPIAuthType build() {
            return new BackendAPIAuthType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
