/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplifybackend;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.amplifybackend.model.CloneBackendRequest;
import software.amazon.awssdk.services.amplifybackend.model.CloneBackendResponse;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendApiRequest;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendApiResponse;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthRequest;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthResponse;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendConfigRequest;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendConfigResponse;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendRequest;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendResponse;
import software.amazon.awssdk.services.amplifybackend.model.CreateTokenRequest;
import software.amazon.awssdk.services.amplifybackend.model.CreateTokenResponse;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendApiRequest;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendApiResponse;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendAuthRequest;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendAuthResponse;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendRequest;
import software.amazon.awssdk.services.amplifybackend.model.DeleteBackendResponse;
import software.amazon.awssdk.services.amplifybackend.model.DeleteTokenRequest;
import software.amazon.awssdk.services.amplifybackend.model.DeleteTokenResponse;
import software.amazon.awssdk.services.amplifybackend.model.GenerateBackendApiModelsRequest;
import software.amazon.awssdk.services.amplifybackend.model.GenerateBackendApiModelsResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendApiModelsRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendApiModelsResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendApiRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendApiResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendAuthRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendAuthResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendJobRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendJobResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetBackendResponse;
import software.amazon.awssdk.services.amplifybackend.model.GetTokenRequest;
import software.amazon.awssdk.services.amplifybackend.model.GetTokenResponse;
import software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest;
import software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsResponse;
import software.amazon.awssdk.services.amplifybackend.model.RemoveAllBackendsRequest;
import software.amazon.awssdk.services.amplifybackend.model.RemoveAllBackendsResponse;
import software.amazon.awssdk.services.amplifybackend.model.RemoveBackendConfigRequest;
import software.amazon.awssdk.services.amplifybackend.model.RemoveBackendConfigResponse;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendApiRequest;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendApiResponse;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthRequest;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendAuthResponse;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendConfigRequest;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendConfigResponse;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendJobRequest;
import software.amazon.awssdk.services.amplifybackend.model.UpdateBackendJobResponse;
import software.amazon.awssdk.services.amplifybackend.paginators.ListBackendJobsPublisher;

/**
 * Service client for accessing AmplifyBackend asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * AWS Amplify Admin API
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AmplifyBackendAsyncClient extends SdkClient {
    String SERVICE_NAME = "amplifybackend";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "amplifybackend";

    /**
     * Create a {@link AmplifyBackendAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AmplifyBackendAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AmplifyBackendAsyncClient}.
     */
    static AmplifyBackendAsyncClientBuilder builder() {
        return new DefaultAmplifyBackendAsyncClientBuilder();
    }

    /**
     * <p>
     * This operation clones an existing backend.
     * </p>
     *
     * @param cloneBackendRequest
     *        The request body for CloneBackend.
     * @return A Java Future containing the result of the CloneBackend operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.CloneBackend
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CloneBackend" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CloneBackendResponse> cloneBackend(CloneBackendRequest cloneBackendRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation clones an existing backend.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CloneBackendRequest.Builder} avoiding the need to
     * create one manually via {@link CloneBackendRequest#builder()}
     * </p>
     *
     * @param cloneBackendRequest
     *        A {@link Consumer} that will call methods on {@link CloneBackendRequest.Builder} to create a request. The
     *        request body for CloneBackend.
     * @return A Java Future containing the result of the CloneBackend operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.CloneBackend
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CloneBackend" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CloneBackendResponse> cloneBackend(Consumer<CloneBackendRequest.Builder> cloneBackendRequest) {
        return cloneBackend(CloneBackendRequest.builder().applyMutation(cloneBackendRequest).build());
    }

    /**
     * <p>
     * This operation creates a backend for an Amplify app. Backends are automatically created at the time of app
     * creation.
     * </p>
     *
     * @param createBackendRequest
     *        The request body for CreateBackend.
     * @return A Java Future containing the result of the CreateBackend operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.CreateBackend
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackend" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateBackendResponse> createBackend(CreateBackendRequest createBackendRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation creates a backend for an Amplify app. Backends are automatically created at the time of app
     * creation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBackendRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBackendRequest#builder()}
     * </p>
     *
     * @param createBackendRequest
     *        A {@link Consumer} that will call methods on {@link CreateBackendRequest.Builder} to create a request. The
     *        request body for CreateBackend.
     * @return A Java Future containing the result of the CreateBackend operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.CreateBackend
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackend" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateBackendResponse> createBackend(Consumer<CreateBackendRequest.Builder> createBackendRequest) {
        return createBackend(CreateBackendRequest.builder().applyMutation(createBackendRequest).build());
    }

    /**
     * <p>
     * Creates a new backend API resource.
     * </p>
     *
     * @param createBackendApiRequest
     *        The request body for CreateBackendAPI.
     * @return A Java Future containing the result of the CreateBackendAPI operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.CreateBackendAPI
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackendAPI"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBackendApiResponse> createBackendAPI(CreateBackendApiRequest createBackendApiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new backend API resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBackendApiRequest.Builder} avoiding the need
     * to create one manually via {@link CreateBackendApiRequest#builder()}
     * </p>
     *
     * @param createBackendApiRequest
     *        A {@link Consumer} that will call methods on {@link CreateBackendAPIRequest.Builder} to create a request.
     *        The request body for CreateBackendAPI.
     * @return A Java Future containing the result of the CreateBackendAPI operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.CreateBackendAPI
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackendAPI"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBackendApiResponse> createBackendAPI(
            Consumer<CreateBackendApiRequest.Builder> createBackendApiRequest) {
        return createBackendAPI(CreateBackendApiRequest.builder().applyMutation(createBackendApiRequest).build());
    }

    /**
     * <p>
     * Creates a new backend authentication resource.
     * </p>
     *
     * @param createBackendAuthRequest
     *        The request body for CreateBackendAuth.
     * @return A Java Future containing the result of the CreateBackendAuth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.CreateBackendAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackendAuth"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBackendAuthResponse> createBackendAuth(CreateBackendAuthRequest createBackendAuthRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new backend authentication resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBackendAuthRequest.Builder} avoiding the need
     * to create one manually via {@link CreateBackendAuthRequest#builder()}
     * </p>
     *
     * @param createBackendAuthRequest
     *        A {@link Consumer} that will call methods on {@link CreateBackendAuthRequest.Builder} to create a request.
     *        The request body for CreateBackendAuth.
     * @return A Java Future containing the result of the CreateBackendAuth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.CreateBackendAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackendAuth"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBackendAuthResponse> createBackendAuth(
            Consumer<CreateBackendAuthRequest.Builder> createBackendAuthRequest) {
        return createBackendAuth(CreateBackendAuthRequest.builder().applyMutation(createBackendAuthRequest).build());
    }

    /**
     * <p>
     * Creates a config object for a backend.
     * </p>
     *
     * @param createBackendConfigRequest
     *        The request body for CreateBackendConfig.
     * @return A Java Future containing the result of the CreateBackendConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.CreateBackendConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackendConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBackendConfigResponse> createBackendConfig(
            CreateBackendConfigRequest createBackendConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a config object for a backend.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBackendConfigRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBackendConfigRequest#builder()}
     * </p>
     *
     * @param createBackendConfigRequest
     *        A {@link Consumer} that will call methods on {@link CreateBackendConfigRequest.Builder} to create a
     *        request. The request body for CreateBackendConfig.
     * @return A Java Future containing the result of the CreateBackendConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.CreateBackendConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateBackendConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBackendConfigResponse> createBackendConfig(
            Consumer<CreateBackendConfigRequest.Builder> createBackendConfigRequest) {
        return createBackendConfig(CreateBackendConfigRequest.builder().applyMutation(createBackendConfigRequest).build());
    }

    /**
     * <p>
     * Generates a one-time challenge code to authenticate a user into your Amplify Admin UI.
     * </p>
     *
     * @param createTokenRequest
     * @return A Java Future containing the result of the CreateToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.CreateToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateToken" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTokenResponse> createToken(CreateTokenRequest createTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a one-time challenge code to authenticate a user into your Amplify Admin UI.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTokenRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTokenRequest#builder()}
     * </p>
     *
     * @param createTokenRequest
     *        A {@link Consumer} that will call methods on {@link CreateTokenRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.CreateToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/CreateToken" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTokenResponse> createToken(Consumer<CreateTokenRequest.Builder> createTokenRequest) {
        return createToken(CreateTokenRequest.builder().applyMutation(createTokenRequest).build());
    }

    /**
     * <p>
     * Removes an existing environment from your Amplify project.
     * </p>
     *
     * @param deleteBackendRequest
     * @return A Java Future containing the result of the DeleteBackend operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.DeleteBackend
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteBackend" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteBackendResponse> deleteBackend(DeleteBackendRequest deleteBackendRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an existing environment from your Amplify project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackendRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBackendRequest#builder()}
     * </p>
     *
     * @param deleteBackendRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBackendRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteBackend operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.DeleteBackend
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteBackend" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteBackendResponse> deleteBackend(Consumer<DeleteBackendRequest.Builder> deleteBackendRequest) {
        return deleteBackend(DeleteBackendRequest.builder().applyMutation(deleteBackendRequest).build());
    }

    /**
     * <p>
     * Deletes an existing backend API resource.
     * </p>
     *
     * @param deleteBackendApiRequest
     *        The request body for DeleteBackendAPI.
     * @return A Java Future containing the result of the DeleteBackendAPI operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.DeleteBackendAPI
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteBackendAPI"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBackendApiResponse> deleteBackendAPI(DeleteBackendApiRequest deleteBackendApiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing backend API resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackendApiRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteBackendApiRequest#builder()}
     * </p>
     *
     * @param deleteBackendApiRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBackendAPIRequest.Builder} to create a request.
     *        The request body for DeleteBackendAPI.
     * @return A Java Future containing the result of the DeleteBackendAPI operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.DeleteBackendAPI
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteBackendAPI"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBackendApiResponse> deleteBackendAPI(
            Consumer<DeleteBackendApiRequest.Builder> deleteBackendApiRequest) {
        return deleteBackendAPI(DeleteBackendApiRequest.builder().applyMutation(deleteBackendApiRequest).build());
    }

    /**
     * <p>
     * Deletes an existing backend authentication resource.
     * </p>
     *
     * @param deleteBackendAuthRequest
     *        The request body for DeleteBackendAuth.
     * @return A Java Future containing the result of the DeleteBackendAuth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.DeleteBackendAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteBackendAuth"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBackendAuthResponse> deleteBackendAuth(DeleteBackendAuthRequest deleteBackendAuthRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing backend authentication resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBackendAuthRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteBackendAuthRequest#builder()}
     * </p>
     *
     * @param deleteBackendAuthRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBackendAuthRequest.Builder} to create a request.
     *        The request body for DeleteBackendAuth.
     * @return A Java Future containing the result of the DeleteBackendAuth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.DeleteBackendAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteBackendAuth"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBackendAuthResponse> deleteBackendAuth(
            Consumer<DeleteBackendAuthRequest.Builder> deleteBackendAuthRequest) {
        return deleteBackendAuth(DeleteBackendAuthRequest.builder().applyMutation(deleteBackendAuthRequest).build());
    }

    /**
     * <p>
     * Deletes the challenge token based on the given appId and sessionId.
     * </p>
     *
     * @param deleteTokenRequest
     * @return A Java Future containing the result of the DeleteToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.DeleteToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteToken" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTokenResponse> deleteToken(DeleteTokenRequest deleteTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the challenge token based on the given appId and sessionId.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTokenRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTokenRequest#builder()}
     * </p>
     *
     * @param deleteTokenRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTokenRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.DeleteToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/DeleteToken" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTokenResponse> deleteToken(Consumer<DeleteTokenRequest.Builder> deleteTokenRequest) {
        return deleteToken(DeleteTokenRequest.builder().applyMutation(deleteTokenRequest).build());
    }

    /**
     * <p>
     * Generates a model schema for an existing backend API resource.
     * </p>
     *
     * @param generateBackendApiModelsRequest
     *        The request body for GenerateBackendAPIModels.
     * @return A Java Future containing the result of the GenerateBackendAPIModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.GenerateBackendAPIModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GenerateBackendAPIModels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GenerateBackendApiModelsResponse> generateBackendAPIModels(
            GenerateBackendApiModelsRequest generateBackendApiModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a model schema for an existing backend API resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GenerateBackendApiModelsRequest.Builder} avoiding
     * the need to create one manually via {@link GenerateBackendApiModelsRequest#builder()}
     * </p>
     *
     * @param generateBackendApiModelsRequest
     *        A {@link Consumer} that will call methods on {@link GenerateBackendAPIModelsRequest.Builder} to create a
     *        request. The request body for GenerateBackendAPIModels.
     * @return A Java Future containing the result of the GenerateBackendAPIModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.GenerateBackendAPIModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GenerateBackendAPIModels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GenerateBackendApiModelsResponse> generateBackendAPIModels(
            Consumer<GenerateBackendApiModelsRequest.Builder> generateBackendApiModelsRequest) {
        return generateBackendAPIModels(GenerateBackendApiModelsRequest.builder().applyMutation(generateBackendApiModelsRequest)
                .build());
    }

    /**
     * <p>
     * Provides project-level details for your Amplify UI project.
     * </p>
     *
     * @param getBackendRequest
     *        The request body for GetBackend.
     * @return A Java Future containing the result of the GetBackend operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.GetBackend
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackend" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBackendResponse> getBackend(GetBackendRequest getBackendRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides project-level details for your Amplify UI project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackendRequest.Builder} avoiding the need to
     * create one manually via {@link GetBackendRequest#builder()}
     * </p>
     *
     * @param getBackendRequest
     *        A {@link Consumer} that will call methods on {@link GetBackendRequest.Builder} to create a request. The
     *        request body for GetBackend.
     * @return A Java Future containing the result of the GetBackend operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.GetBackend
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackend" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetBackendResponse> getBackend(Consumer<GetBackendRequest.Builder> getBackendRequest) {
        return getBackend(GetBackendRequest.builder().applyMutation(getBackendRequest).build());
    }

    /**
     * <p>
     * Gets the details for a backend API.
     * </p>
     *
     * @param getBackendApiRequest
     *        The request body for GetBackendAPI.
     * @return A Java Future containing the result of the GetBackendAPI operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.GetBackendAPI
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendAPI" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetBackendApiResponse> getBackendAPI(GetBackendApiRequest getBackendApiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details for a backend API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackendApiRequest.Builder} avoiding the need to
     * create one manually via {@link GetBackendApiRequest#builder()}
     * </p>
     *
     * @param getBackendApiRequest
     *        A {@link Consumer} that will call methods on {@link GetBackendAPIRequest.Builder} to create a request. The
     *        request body for GetBackendAPI.
     * @return A Java Future containing the result of the GetBackendAPI operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.GetBackendAPI
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendAPI" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetBackendApiResponse> getBackendAPI(Consumer<GetBackendApiRequest.Builder> getBackendApiRequest) {
        return getBackendAPI(GetBackendApiRequest.builder().applyMutation(getBackendApiRequest).build());
    }

    /**
     * <p>
     * Generates a model schema for existing backend API resource.
     * </p>
     *
     * @param getBackendApiModelsRequest
     *        The request body for GetBackendAPIModels.
     * @return A Java Future containing the result of the GetBackendAPIModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.GetBackendAPIModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendAPIModels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBackendApiModelsResponse> getBackendAPIModels(
            GetBackendApiModelsRequest getBackendApiModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates a model schema for existing backend API resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackendApiModelsRequest.Builder} avoiding the
     * need to create one manually via {@link GetBackendApiModelsRequest#builder()}
     * </p>
     *
     * @param getBackendApiModelsRequest
     *        A {@link Consumer} that will call methods on {@link GetBackendAPIModelsRequest.Builder} to create a
     *        request. The request body for GetBackendAPIModels.
     * @return A Java Future containing the result of the GetBackendAPIModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.GetBackendAPIModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendAPIModels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBackendApiModelsResponse> getBackendAPIModels(
            Consumer<GetBackendApiModelsRequest.Builder> getBackendApiModelsRequest) {
        return getBackendAPIModels(GetBackendApiModelsRequest.builder().applyMutation(getBackendApiModelsRequest).build());
    }

    /**
     * <p>
     * Gets backend auth details.
     * </p>
     *
     * @param getBackendAuthRequest
     *        The request body for GetBackendAuth.
     * @return A Java Future containing the result of the GetBackendAuth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.GetBackendAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendAuth" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetBackendAuthResponse> getBackendAuth(GetBackendAuthRequest getBackendAuthRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets backend auth details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackendAuthRequest.Builder} avoiding the need to
     * create one manually via {@link GetBackendAuthRequest#builder()}
     * </p>
     *
     * @param getBackendAuthRequest
     *        A {@link Consumer} that will call methods on {@link GetBackendAuthRequest.Builder} to create a request.
     *        The request body for GetBackendAuth.
     * @return A Java Future containing the result of the GetBackendAuth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.GetBackendAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendAuth" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetBackendAuthResponse> getBackendAuth(Consumer<GetBackendAuthRequest.Builder> getBackendAuthRequest) {
        return getBackendAuth(GetBackendAuthRequest.builder().applyMutation(getBackendAuthRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific job.
     * </p>
     *
     * @param getBackendJobRequest
     * @return A Java Future containing the result of the GetBackendJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.GetBackendJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetBackendJobResponse> getBackendJob(GetBackendJobRequest getBackendJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBackendJobRequest.Builder} avoiding the need to
     * create one manually via {@link GetBackendJobRequest#builder()}
     * </p>
     *
     * @param getBackendJobRequest
     *        A {@link Consumer} that will call methods on {@link GetBackendJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetBackendJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.GetBackendJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetBackendJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetBackendJobResponse> getBackendJob(Consumer<GetBackendJobRequest.Builder> getBackendJobRequest) {
        return getBackendJob(GetBackendJobRequest.builder().applyMutation(getBackendJobRequest).build());
    }

    /**
     * <p>
     * Gets the challenge token based on the given appId and sessionId.
     * </p>
     *
     * @param getTokenRequest
     * @return A Java Future containing the result of the GetToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.GetToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetToken" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTokenResponse> getToken(GetTokenRequest getTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the challenge token based on the given appId and sessionId.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTokenRequest.Builder} avoiding the need to
     * create one manually via {@link GetTokenRequest#builder()}
     * </p>
     *
     * @param getTokenRequest
     *        A {@link Consumer} that will call methods on {@link GetTokenRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.GetToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/GetToken" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTokenResponse> getToken(Consumer<GetTokenRequest.Builder> getTokenRequest) {
        return getToken(GetTokenRequest.builder().applyMutation(getTokenRequest).build());
    }

    /**
     * <p>
     * Lists the jobs for the backend of an Amplify app.
     * </p>
     *
     * @param listBackendJobsRequest
     *        The request body for ListBackendJobs.
     * @return A Java Future containing the result of the ListBackendJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.ListBackendJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/ListBackendJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBackendJobsResponse> listBackendJobs(ListBackendJobsRequest listBackendJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the jobs for the backend of an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackendJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBackendJobsRequest#builder()}
     * </p>
     *
     * @param listBackendJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListBackendJobsRequest.Builder} to create a request.
     *        The request body for ListBackendJobs.
     * @return A Java Future containing the result of the ListBackendJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.ListBackendJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/ListBackendJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBackendJobsResponse> listBackendJobs(
            Consumer<ListBackendJobsRequest.Builder> listBackendJobsRequest) {
        return listBackendJobs(ListBackendJobsRequest.builder().applyMutation(listBackendJobsRequest).build());
    }

    /**
     * <p>
     * Lists the jobs for the backend of an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackendJobs(software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifybackend.paginators.ListBackendJobsPublisher publisher = client.listBackendJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifybackend.paginators.ListBackendJobsPublisher publisher = client.listBackendJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackendJobs(software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBackendJobsRequest
     *        The request body for ListBackendJobs.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.ListBackendJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/ListBackendJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBackendJobsPublisher listBackendJobsPaginator(ListBackendJobsRequest listBackendJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the jobs for the backend of an Amplify app.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBackendJobs(software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifybackend.paginators.ListBackendJobsPublisher publisher = client.listBackendJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.amplifybackend.paginators.ListBackendJobsPublisher publisher = client.listBackendJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBackendJobs(software.amazon.awssdk.services.amplifybackend.model.ListBackendJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBackendJobsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBackendJobsRequest#builder()}
     * </p>
     *
     * @param listBackendJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListBackendJobsRequest.Builder} to create a request.
     *        The request body for ListBackendJobs.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.ListBackendJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/ListBackendJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBackendJobsPublisher listBackendJobsPaginator(Consumer<ListBackendJobsRequest.Builder> listBackendJobsRequest) {
        return listBackendJobsPaginator(ListBackendJobsRequest.builder().applyMutation(listBackendJobsRequest).build());
    }

    /**
     * <p>
     * Removes all backend environments from your Amplify project.
     * </p>
     *
     * @param removeAllBackendsRequest
     *        The request body for RemoveAllBackends.
     * @return A Java Future containing the result of the RemoveAllBackends operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.RemoveAllBackends
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/RemoveAllBackends"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveAllBackendsResponse> removeAllBackends(RemoveAllBackendsRequest removeAllBackendsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes all backend environments from your Amplify project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveAllBackendsRequest.Builder} avoiding the need
     * to create one manually via {@link RemoveAllBackendsRequest#builder()}
     * </p>
     *
     * @param removeAllBackendsRequest
     *        A {@link Consumer} that will call methods on {@link RemoveAllBackendsRequest.Builder} to create a request.
     *        The request body for RemoveAllBackends.
     * @return A Java Future containing the result of the RemoveAllBackends operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.RemoveAllBackends
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/RemoveAllBackends"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveAllBackendsResponse> removeAllBackends(
            Consumer<RemoveAllBackendsRequest.Builder> removeAllBackendsRequest) {
        return removeAllBackends(RemoveAllBackendsRequest.builder().applyMutation(removeAllBackendsRequest).build());
    }

    /**
     * <p>
     * Removes the AWS resources that are required to access the Amplify Admin UI.
     * </p>
     *
     * @param removeBackendConfigRequest
     * @return A Java Future containing the result of the RemoveBackendConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.RemoveBackendConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/RemoveBackendConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveBackendConfigResponse> removeBackendConfig(
            RemoveBackendConfigRequest removeBackendConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the AWS resources that are required to access the Amplify Admin UI.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveBackendConfigRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveBackendConfigRequest#builder()}
     * </p>
     *
     * @param removeBackendConfigRequest
     *        A {@link Consumer} that will call methods on {@link RemoveBackendConfigRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RemoveBackendConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.RemoveBackendConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/RemoveBackendConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RemoveBackendConfigResponse> removeBackendConfig(
            Consumer<RemoveBackendConfigRequest.Builder> removeBackendConfigRequest) {
        return removeBackendConfig(RemoveBackendConfigRequest.builder().applyMutation(removeBackendConfigRequest).build());
    }

    /**
     * <p>
     * Updates an existing backend API resource.
     * </p>
     *
     * @param updateBackendApiRequest
     *        The request body for UpdateBackendAPI.
     * @return A Java Future containing the result of the UpdateBackendAPI operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.UpdateBackendAPI
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendAPI"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBackendApiResponse> updateBackendAPI(UpdateBackendApiRequest updateBackendApiRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing backend API resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBackendApiRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateBackendApiRequest#builder()}
     * </p>
     *
     * @param updateBackendApiRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBackendAPIRequest.Builder} to create a request.
     *        The request body for UpdateBackendAPI.
     * @return A Java Future containing the result of the UpdateBackendAPI operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.UpdateBackendAPI
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendAPI"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBackendApiResponse> updateBackendAPI(
            Consumer<UpdateBackendApiRequest.Builder> updateBackendApiRequest) {
        return updateBackendAPI(UpdateBackendApiRequest.builder().applyMutation(updateBackendApiRequest).build());
    }

    /**
     * <p>
     * Updates an existing backend authentication resource.
     * </p>
     *
     * @param updateBackendAuthRequest
     *        The request body for UpdateBackendAuth.
     * @return A Java Future containing the result of the UpdateBackendAuth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.UpdateBackendAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendAuth"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBackendAuthResponse> updateBackendAuth(UpdateBackendAuthRequest updateBackendAuthRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing backend authentication resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBackendAuthRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateBackendAuthRequest#builder()}
     * </p>
     *
     * @param updateBackendAuthRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBackendAuthRequest.Builder} to create a request.
     *        The request body for UpdateBackendAuth.
     * @return A Java Future containing the result of the UpdateBackendAuth operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.UpdateBackendAuth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendAuth"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBackendAuthResponse> updateBackendAuth(
            Consumer<UpdateBackendAuthRequest.Builder> updateBackendAuthRequest) {
        return updateBackendAuth(UpdateBackendAuthRequest.builder().applyMutation(updateBackendAuthRequest).build());
    }

    /**
     * <p>
     * Updates the AWS resources that are required to access the Amplify Admin UI.
     * </p>
     *
     * @param updateBackendConfigRequest
     *        The request body for UpdateBackendConfig.
     * @return A Java Future containing the result of the UpdateBackendConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.UpdateBackendConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBackendConfigResponse> updateBackendConfig(
            UpdateBackendConfigRequest updateBackendConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the AWS resources that are required to access the Amplify Admin UI.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBackendConfigRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateBackendConfigRequest#builder()}
     * </p>
     *
     * @param updateBackendConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBackendConfigRequest.Builder} to create a
     *        request. The request body for UpdateBackendConfig.
     * @return A Java Future containing the result of the UpdateBackendConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.UpdateBackendConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBackendConfigResponse> updateBackendConfig(
            Consumer<UpdateBackendConfigRequest.Builder> updateBackendConfigRequest) {
        return updateBackendConfig(UpdateBackendConfigRequest.builder().applyMutation(updateBackendConfigRequest).build());
    }

    /**
     * <p>
     * Updates a specific job.
     * </p>
     *
     * @param updateBackendJobRequest
     *        The request body for GetBackendJob.
     * @return A Java Future containing the result of the UpdateBackendJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.UpdateBackendJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBackendJobResponse> updateBackendJob(UpdateBackendJobRequest updateBackendJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a specific job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBackendJobRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateBackendJobRequest#builder()}
     * </p>
     *
     * @param updateBackendJobRequest
     *        A {@link Consumer} that will call methods on {@link UpdateBackendJobRequest.Builder} to create a request.
     *        The request body for GetBackendJob.
     * @return A Java Future containing the result of the UpdateBackendJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>GatewayTimeoutException 504 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AmplifyBackendException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample AmplifyBackendAsyncClient.UpdateBackendJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/amplifybackend-2020-08-11/UpdateBackendJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBackendJobResponse> updateBackendJob(
            Consumer<UpdateBackendJobRequest.Builder> updateBackendJobRequest) {
        return updateBackendJob(UpdateBackendJobRequest.builder().applyMutation(updateBackendJobRequest).build());
    }
}
