/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Stage {
    PRODUCTION("PRODUCTION"),
    BETA("BETA"),
    DEVELOPMENT("DEVELOPMENT"),
    EXPERIMENTAL("EXPERIMENTAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Stage(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Stage fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Stage.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Stage> knownValues() {
        return Stream.of(Stage.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

