/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum JobStatus {
    PENDING("PENDING"),
    PROVISIONING("PROVISIONING"),
    RUNNING("RUNNING"),
    FAILED("FAILED"),
    SUCCEED("SUCCEED"),
    CANCELLING("CANCELLING"),
    CANCELLED("CANCELLED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private JobStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JobStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(JobStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JobStatus> knownValues() {
        return Stream.of(JobStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

