/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplify.model.AmplifyResponse;
import software.amazon.awssdk.services.amplify.model.BackendEnvironment;
import software.amazon.awssdk.services.amplify.model.BackendEnvironmentsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBackendEnvironmentsResponse
extends AmplifyResponse
implements ToCopyableBuilder<Builder, ListBackendEnvironmentsResponse> {
    private static final SdkField<List<BackendEnvironment>> BACKEND_ENVIRONMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("backendEnvironments").getter(ListBackendEnvironmentsResponse.getter(ListBackendEnvironmentsResponse::backendEnvironments)).setter(ListBackendEnvironmentsResponse.setter(Builder::backendEnvironments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendEnvironments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BackendEnvironment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBackendEnvironmentsResponse.getter(ListBackendEnvironmentsResponse::nextToken)).setter(ListBackendEnvironmentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKEND_ENVIRONMENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListBackendEnvironmentsResponse.memberNameToFieldInitializer();
    private final List<BackendEnvironment> backendEnvironments;
    private final String nextToken;

    private ListBackendEnvironmentsResponse(BuilderImpl builder) {
        super(builder);
        this.backendEnvironments = builder.backendEnvironments;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasBackendEnvironments() {
        return this.backendEnvironments != null && !(this.backendEnvironments instanceof SdkAutoConstructList);
    }

    public final List<BackendEnvironment> backendEnvironments() {
        return this.backendEnvironments;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBackendEnvironments() ? this.backendEnvironments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBackendEnvironmentsResponse)) {
            return false;
        }
        ListBackendEnvironmentsResponse other = (ListBackendEnvironmentsResponse)((Object)obj);
        return this.hasBackendEnvironments() == other.hasBackendEnvironments() && Objects.equals(this.backendEnvironments(), other.backendEnvironments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBackendEnvironmentsResponse").add("BackendEnvironments", this.hasBackendEnvironments() ? this.backendEnvironments() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "backendEnvironments": {
                return Optional.ofNullable(clazz.cast(this.backendEnvironments()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("backendEnvironments", BACKEND_ENVIRONMENTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBackendEnvironmentsResponse, T> g) {
        return obj -> g.apply((ListBackendEnvironmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyResponse.BuilderImpl
    implements Builder {
        private List<BackendEnvironment> backendEnvironments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBackendEnvironmentsResponse model) {
            super(model);
            this.backendEnvironments(model.backendEnvironments);
            this.nextToken(model.nextToken);
        }

        public final List<BackendEnvironment.Builder> getBackendEnvironments() {
            List<BackendEnvironment.Builder> result = BackendEnvironmentsCopier.copyToBuilder(this.backendEnvironments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBackendEnvironments(Collection<BackendEnvironment.BuilderImpl> backendEnvironments) {
            this.backendEnvironments = BackendEnvironmentsCopier.copyFromBuilder(backendEnvironments);
        }

        @Override
        public final Builder backendEnvironments(Collection<BackendEnvironment> backendEnvironments) {
            this.backendEnvironments = BackendEnvironmentsCopier.copy(backendEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backendEnvironments(BackendEnvironment ... backendEnvironments) {
            this.backendEnvironments(Arrays.asList(backendEnvironments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backendEnvironments(Consumer<BackendEnvironment.Builder> ... backendEnvironments) {
            this.backendEnvironments(Stream.of(backendEnvironments).map(c -> (BackendEnvironment)((BackendEnvironment.Builder)BackendEnvironment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBackendEnvironmentsResponse build() {
            return new ListBackendEnvironmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AmplifyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBackendEnvironmentsResponse> {
        public Builder backendEnvironments(Collection<BackendEnvironment> var1);

        public Builder backendEnvironments(BackendEnvironment ... var1);

        public Builder backendEnvironments(Consumer<BackendEnvironment.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

