/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the backend environment associated with a <code>Branch</code> of a Gen 1 Amplify app. Amplify Gen 1
 * applications are created using Amplify Studio or the Amplify command line interface (CLI).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BackendEnvironment implements SdkPojo, Serializable,
        ToCopyableBuilder<BackendEnvironment.Builder, BackendEnvironment> {
    private static final SdkField<String> BACKEND_ENVIRONMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("backendEnvironmentArn").getter(getter(BackendEnvironment::backendEnvironmentArn))
            .setter(setter(Builder::backendEnvironmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendEnvironmentArn").build())
            .build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentName").getter(getter(BackendEnvironment::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()).build();

    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stackName").getter(getter(BackendEnvironment::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stackName").build()).build();

    private static final SdkField<String> DEPLOYMENT_ARTIFACTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentArtifacts").getter(getter(BackendEnvironment::deploymentArtifacts))
            .setter(setter(Builder::deploymentArtifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentArtifacts").build())
            .build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(BackendEnvironment::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime").getter(getter(BackendEnvironment::updateTime)).setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKEND_ENVIRONMENT_ARN_FIELD,
            ENVIRONMENT_NAME_FIELD, STACK_NAME_FIELD, DEPLOYMENT_ARTIFACTS_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String backendEnvironmentArn;

    private final String environmentName;

    private final String stackName;

    private final String deploymentArtifacts;

    private final Instant createTime;

    private final Instant updateTime;

    private BackendEnvironment(BuilderImpl builder) {
        this.backendEnvironmentArn = builder.backendEnvironmentArn;
        this.environmentName = builder.environmentName;
        this.stackName = builder.stackName;
        this.deploymentArtifacts = builder.deploymentArtifacts;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app.
     */
    public final String backendEnvironmentArn() {
        return backendEnvironmentArn;
    }

    /**
     * <p>
     * The name for a backend environment that is part of an Amplify app.
     * </p>
     * 
     * @return The name for a backend environment that is part of an Amplify app.
     */
    public final String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * The AWS CloudFormation stack name of a backend environment.
     * </p>
     * 
     * @return The AWS CloudFormation stack name of a backend environment.
     */
    public final String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The name of deployment artifacts.
     * </p>
     * 
     * @return The name of deployment artifacts.
     */
    public final String deploymentArtifacts() {
        return deploymentArtifacts;
    }

    /**
     * <p>
     * The creation date and time for a backend environment that is part of an Amplify app.
     * </p>
     * 
     * @return The creation date and time for a backend environment that is part of an Amplify app.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The last updated date and time for a backend environment that is part of an Amplify app.
     * </p>
     * 
     * @return The last updated date and time for a backend environment that is part of an Amplify app.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backendEnvironmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentArtifacts());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackendEnvironment)) {
            return false;
        }
        BackendEnvironment other = (BackendEnvironment) obj;
        return Objects.equals(backendEnvironmentArn(), other.backendEnvironmentArn())
                && Objects.equals(environmentName(), other.environmentName()) && Objects.equals(stackName(), other.stackName())
                && Objects.equals(deploymentArtifacts(), other.deploymentArtifacts())
                && Objects.equals(createTime(), other.createTime()) && Objects.equals(updateTime(), other.updateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BackendEnvironment").add("BackendEnvironmentArn", backendEnvironmentArn())
                .add("EnvironmentName", environmentName()).add("StackName", stackName())
                .add("DeploymentArtifacts", deploymentArtifacts()).add("CreateTime", createTime())
                .add("UpdateTime", updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "backendEnvironmentArn":
            return Optional.ofNullable(clazz.cast(backendEnvironmentArn()));
        case "environmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "stackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "deploymentArtifacts":
            return Optional.ofNullable(clazz.cast(deploymentArtifacts()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("backendEnvironmentArn", BACKEND_ENVIRONMENT_ARN_FIELD);
        map.put("environmentName", ENVIRONMENT_NAME_FIELD);
        map.put("stackName", STACK_NAME_FIELD);
        map.put("deploymentArtifacts", DEPLOYMENT_ARTIFACTS_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BackendEnvironment, T> g) {
        return obj -> g.apply((BackendEnvironment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BackendEnvironment> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app.
         * </p>
         * 
         * @param backendEnvironmentArn
         *        The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backendEnvironmentArn(String backendEnvironmentArn);

        /**
         * <p>
         * The name for a backend environment that is part of an Amplify app.
         * </p>
         * 
         * @param environmentName
         *        The name for a backend environment that is part of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The AWS CloudFormation stack name of a backend environment.
         * </p>
         * 
         * @param stackName
         *        The AWS CloudFormation stack name of a backend environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The name of deployment artifacts.
         * </p>
         * 
         * @param deploymentArtifacts
         *        The name of deployment artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentArtifacts(String deploymentArtifacts);

        /**
         * <p>
         * The creation date and time for a backend environment that is part of an Amplify app.
         * </p>
         * 
         * @param createTime
         *        The creation date and time for a backend environment that is part of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The last updated date and time for a backend environment that is part of an Amplify app.
         * </p>
         * 
         * @param updateTime
         *        The last updated date and time for a backend environment that is part of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);
    }

    static final class BuilderImpl implements Builder {
        private String backendEnvironmentArn;

        private String environmentName;

        private String stackName;

        private String deploymentArtifacts;

        private Instant createTime;

        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BackendEnvironment model) {
            backendEnvironmentArn(model.backendEnvironmentArn);
            environmentName(model.environmentName);
            stackName(model.stackName);
            deploymentArtifacts(model.deploymentArtifacts);
            createTime(model.createTime);
            updateTime(model.updateTime);
        }

        public final String getBackendEnvironmentArn() {
            return backendEnvironmentArn;
        }

        public final void setBackendEnvironmentArn(String backendEnvironmentArn) {
            this.backendEnvironmentArn = backendEnvironmentArn;
        }

        @Override
        public final Builder backendEnvironmentArn(String backendEnvironmentArn) {
            this.backendEnvironmentArn = backendEnvironmentArn;
            return this;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getStackName() {
            return stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getDeploymentArtifacts() {
            return deploymentArtifacts;
        }

        public final void setDeploymentArtifacts(String deploymentArtifacts) {
            this.deploymentArtifacts = deploymentArtifacts;
        }

        @Override
        public final Builder deploymentArtifacts(String deploymentArtifacts) {
            this.deploymentArtifacts = deploymentArtifacts;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public BackendEnvironment build() {
            return new BackendEnvironment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
