/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the automated branch creation configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoBranchCreationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoBranchCreationConfig.Builder, AutoBranchCreationConfig> {
    private static final SdkField<String> STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("stage")
            .getter(getter(AutoBranchCreationConfig::stageAsString)).setter(setter(Builder::stage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()).build();

    private static final SdkField<String> FRAMEWORK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("framework").getter(getter(AutoBranchCreationConfig::framework)).setter(setter(Builder::framework))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framework").build()).build();

    private static final SdkField<Boolean> ENABLE_AUTO_BUILD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableAutoBuild").getter(getter(AutoBranchCreationConfig::enableAutoBuild))
            .setter(setter(Builder::enableAutoBuild))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableAutoBuild").build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("environmentVariables")
            .getter(getter(AutoBranchCreationConfig::environmentVariables))
            .setter(setter(Builder::environmentVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> BASIC_AUTH_CREDENTIALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("basicAuthCredentials").getter(getter(AutoBranchCreationConfig::basicAuthCredentials))
            .setter(setter(Builder::basicAuthCredentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basicAuthCredentials").build())
            .build();

    private static final SdkField<Boolean> ENABLE_BASIC_AUTH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableBasicAuth").getter(getter(AutoBranchCreationConfig::enableBasicAuth))
            .setter(setter(Builder::enableBasicAuth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBasicAuth").build()).build();

    private static final SdkField<Boolean> ENABLE_PERFORMANCE_MODE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enablePerformanceMode").getter(getter(AutoBranchCreationConfig::enablePerformanceMode))
            .setter(setter(Builder::enablePerformanceMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enablePerformanceMode").build())
            .build();

    private static final SdkField<String> BUILD_SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("buildSpec").getter(getter(AutoBranchCreationConfig::buildSpec)).setter(setter(Builder::buildSpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildSpec").build()).build();

    private static final SdkField<Boolean> ENABLE_PULL_REQUEST_PREVIEW_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("enablePullRequestPreview")
            .getter(getter(AutoBranchCreationConfig::enablePullRequestPreview)).setter(setter(Builder::enablePullRequestPreview))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enablePullRequestPreview").build())
            .build();

    private static final SdkField<String> PULL_REQUEST_ENVIRONMENT_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("pullRequestEnvironmentName")
            .getter(getter(AutoBranchCreationConfig::pullRequestEnvironmentName))
            .setter(setter(Builder::pullRequestEnvironmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestEnvironmentName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_FIELD, FRAMEWORK_FIELD,
            ENABLE_AUTO_BUILD_FIELD, ENVIRONMENT_VARIABLES_FIELD, BASIC_AUTH_CREDENTIALS_FIELD, ENABLE_BASIC_AUTH_FIELD,
            ENABLE_PERFORMANCE_MODE_FIELD, BUILD_SPEC_FIELD, ENABLE_PULL_REQUEST_PREVIEW_FIELD,
            PULL_REQUEST_ENVIRONMENT_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stage;

    private final String framework;

    private final Boolean enableAutoBuild;

    private final Map<String, String> environmentVariables;

    private final String basicAuthCredentials;

    private final Boolean enableBasicAuth;

    private final Boolean enablePerformanceMode;

    private final String buildSpec;

    private final Boolean enablePullRequestPreview;

    private final String pullRequestEnvironmentName;

    private AutoBranchCreationConfig(BuilderImpl builder) {
        this.stage = builder.stage;
        this.framework = builder.framework;
        this.enableAutoBuild = builder.enableAutoBuild;
        this.environmentVariables = builder.environmentVariables;
        this.basicAuthCredentials = builder.basicAuthCredentials;
        this.enableBasicAuth = builder.enableBasicAuth;
        this.enablePerformanceMode = builder.enablePerformanceMode;
        this.buildSpec = builder.buildSpec;
        this.enablePullRequestPreview = builder.enablePullRequestPreview;
        this.pullRequestEnvironmentName = builder.pullRequestEnvironmentName;
    }

    /**
     * <p>
     * Describes the current stage for the autocreated branch.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link Stage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return Describes the current stage for the autocreated branch.
     * @see Stage
     */
    public final Stage stage() {
        return Stage.fromValue(stage);
    }

    /**
     * <p>
     * Describes the current stage for the autocreated branch.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link Stage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return Describes the current stage for the autocreated branch.
     * @see Stage
     */
    public final String stageAsString() {
        return stage;
    }

    /**
     * <p>
     * The framework for the autocreated branch.
     * </p>
     * 
     * @return The framework for the autocreated branch.
     */
    public final String framework() {
        return framework;
    }

    /**
     * <p>
     * Enables auto building for the autocreated branch.
     * </p>
     * 
     * @return Enables auto building for the autocreated branch.
     */
    public final Boolean enableAutoBuild() {
        return enableAutoBuild;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentVariables property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironmentVariables() {
        return environmentVariables != null && !(environmentVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The environment variables for the autocreated branch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentVariables} method.
     * </p>
     * 
     * @return The environment variables for the autocreated branch.
     */
    public final Map<String, String> environmentVariables() {
        return environmentVariables;
    }

    /**
     * <p>
     * The basic authorization credentials for the autocreated branch. You must base64-encode the authorization
     * credentials and provide them in the format <code>user:password</code>.
     * </p>
     * 
     * @return The basic authorization credentials for the autocreated branch. You must base64-encode the authorization
     *         credentials and provide them in the format <code>user:password</code>.
     */
    public final String basicAuthCredentials() {
        return basicAuthCredentials;
    }

    /**
     * <p>
     * Enables basic authorization for the autocreated branch.
     * </p>
     * 
     * @return Enables basic authorization for the autocreated branch.
     */
    public final Boolean enableBasicAuth() {
        return enableBasicAuth;
    }

    /**
     * <p>
     * Enables performance mode for the branch.
     * </p>
     * <p>
     * Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer
     * interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to
     * roll out.
     * </p>
     * 
     * @return Enables performance mode for the branch.</p>
     *         <p>
     *         Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a
     *         longer interval. When performance mode is enabled, hosting configuration or code changes can take up to
     *         10 minutes to roll out.
     */
    public final Boolean enablePerformanceMode() {
        return enablePerformanceMode;
    }

    /**
     * <p>
     * The build specification (build spec) for the autocreated branch.
     * </p>
     * 
     * @return The build specification (build spec) for the autocreated branch.
     */
    public final String buildSpec() {
        return buildSpec;
    }

    /**
     * <p>
     * Enables pull request previews for the autocreated branch.
     * </p>
     * 
     * @return Enables pull request previews for the autocreated branch.
     */
    public final Boolean enablePullRequestPreview() {
        return enablePullRequestPreview;
    }

    /**
     * <p>
     * The Amplify environment name for the pull request.
     * </p>
     * 
     * @return The Amplify environment name for the pull request.
     */
    public final String pullRequestEnvironmentName() {
        return pullRequestEnvironmentName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(framework());
        hashCode = 31 * hashCode + Objects.hashCode(enableAutoBuild());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentVariables() ? environmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(basicAuthCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(enableBasicAuth());
        hashCode = 31 * hashCode + Objects.hashCode(enablePerformanceMode());
        hashCode = 31 * hashCode + Objects.hashCode(buildSpec());
        hashCode = 31 * hashCode + Objects.hashCode(enablePullRequestPreview());
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestEnvironmentName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoBranchCreationConfig)) {
            return false;
        }
        AutoBranchCreationConfig other = (AutoBranchCreationConfig) obj;
        return Objects.equals(stageAsString(), other.stageAsString()) && Objects.equals(framework(), other.framework())
                && Objects.equals(enableAutoBuild(), other.enableAutoBuild())
                && hasEnvironmentVariables() == other.hasEnvironmentVariables()
                && Objects.equals(environmentVariables(), other.environmentVariables())
                && Objects.equals(basicAuthCredentials(), other.basicAuthCredentials())
                && Objects.equals(enableBasicAuth(), other.enableBasicAuth())
                && Objects.equals(enablePerformanceMode(), other.enablePerformanceMode())
                && Objects.equals(buildSpec(), other.buildSpec())
                && Objects.equals(enablePullRequestPreview(), other.enablePullRequestPreview())
                && Objects.equals(pullRequestEnvironmentName(), other.pullRequestEnvironmentName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoBranchCreationConfig").add("Stage", stageAsString()).add("Framework", framework())
                .add("EnableAutoBuild", enableAutoBuild())
                .add("EnvironmentVariables", hasEnvironmentVariables() ? environmentVariables() : null)
                .add("BasicAuthCredentials", basicAuthCredentials() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EnableBasicAuth", enableBasicAuth()).add("EnablePerformanceMode", enablePerformanceMode())
                .add("BuildSpec", buildSpec() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EnablePullRequestPreview", enablePullRequestPreview())
                .add("PullRequestEnvironmentName", pullRequestEnvironmentName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stage":
            return Optional.ofNullable(clazz.cast(stageAsString()));
        case "framework":
            return Optional.ofNullable(clazz.cast(framework()));
        case "enableAutoBuild":
            return Optional.ofNullable(clazz.cast(enableAutoBuild()));
        case "environmentVariables":
            return Optional.ofNullable(clazz.cast(environmentVariables()));
        case "basicAuthCredentials":
            return Optional.ofNullable(clazz.cast(basicAuthCredentials()));
        case "enableBasicAuth":
            return Optional.ofNullable(clazz.cast(enableBasicAuth()));
        case "enablePerformanceMode":
            return Optional.ofNullable(clazz.cast(enablePerformanceMode()));
        case "buildSpec":
            return Optional.ofNullable(clazz.cast(buildSpec()));
        case "enablePullRequestPreview":
            return Optional.ofNullable(clazz.cast(enablePullRequestPreview()));
        case "pullRequestEnvironmentName":
            return Optional.ofNullable(clazz.cast(pullRequestEnvironmentName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoBranchCreationConfig, T> g) {
        return obj -> g.apply((AutoBranchCreationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoBranchCreationConfig> {
        /**
         * <p>
         * Describes the current stage for the autocreated branch.
         * </p>
         * 
         * @param stage
         *        Describes the current stage for the autocreated branch.
         * @see Stage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Stage
         */
        Builder stage(String stage);

        /**
         * <p>
         * Describes the current stage for the autocreated branch.
         * </p>
         * 
         * @param stage
         *        Describes the current stage for the autocreated branch.
         * @see Stage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Stage
         */
        Builder stage(Stage stage);

        /**
         * <p>
         * The framework for the autocreated branch.
         * </p>
         * 
         * @param framework
         *        The framework for the autocreated branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framework(String framework);

        /**
         * <p>
         * Enables auto building for the autocreated branch.
         * </p>
         * 
         * @param enableAutoBuild
         *        Enables auto building for the autocreated branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableAutoBuild(Boolean enableAutoBuild);

        /**
         * <p>
         * The environment variables for the autocreated branch.
         * </p>
         * 
         * @param environmentVariables
         *        The environment variables for the autocreated branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentVariables(Map<String, String> environmentVariables);

        /**
         * <p>
         * The basic authorization credentials for the autocreated branch. You must base64-encode the authorization
         * credentials and provide them in the format <code>user:password</code>.
         * </p>
         * 
         * @param basicAuthCredentials
         *        The basic authorization credentials for the autocreated branch. You must base64-encode the
         *        authorization credentials and provide them in the format <code>user:password</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basicAuthCredentials(String basicAuthCredentials);

        /**
         * <p>
         * Enables basic authorization for the autocreated branch.
         * </p>
         * 
         * @param enableBasicAuth
         *        Enables basic authorization for the autocreated branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableBasicAuth(Boolean enableBasicAuth);

        /**
         * <p>
         * Enables performance mode for the branch.
         * </p>
         * <p>
         * Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer
         * interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes
         * to roll out.
         * </p>
         * 
         * @param enablePerformanceMode
         *        Enables performance mode for the branch.</p>
         *        <p>
         *        Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a
         *        longer interval. When performance mode is enabled, hosting configuration or code changes can take up
         *        to 10 minutes to roll out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePerformanceMode(Boolean enablePerformanceMode);

        /**
         * <p>
         * The build specification (build spec) for the autocreated branch.
         * </p>
         * 
         * @param buildSpec
         *        The build specification (build spec) for the autocreated branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildSpec(String buildSpec);

        /**
         * <p>
         * Enables pull request previews for the autocreated branch.
         * </p>
         * 
         * @param enablePullRequestPreview
         *        Enables pull request previews for the autocreated branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePullRequestPreview(Boolean enablePullRequestPreview);

        /**
         * <p>
         * The Amplify environment name for the pull request.
         * </p>
         * 
         * @param pullRequestEnvironmentName
         *        The Amplify environment name for the pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullRequestEnvironmentName(String pullRequestEnvironmentName);
    }

    static final class BuilderImpl implements Builder {
        private String stage;

        private String framework;

        private Boolean enableAutoBuild;

        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();

        private String basicAuthCredentials;

        private Boolean enableBasicAuth;

        private Boolean enablePerformanceMode;

        private String buildSpec;

        private Boolean enablePullRequestPreview;

        private String pullRequestEnvironmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoBranchCreationConfig model) {
            stage(model.stage);
            framework(model.framework);
            enableAutoBuild(model.enableAutoBuild);
            environmentVariables(model.environmentVariables);
            basicAuthCredentials(model.basicAuthCredentials);
            enableBasicAuth(model.enableBasicAuth);
            enablePerformanceMode(model.enablePerformanceMode);
            buildSpec(model.buildSpec);
            enablePullRequestPreview(model.enablePullRequestPreview);
            pullRequestEnvironmentName(model.pullRequestEnvironmentName);
        }

        public final String getStage() {
            return stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public final Builder stage(Stage stage) {
            this.stage(stage == null ? null : stage.toString());
            return this;
        }

        public final String getFramework() {
            return framework;
        }

        public final void setFramework(String framework) {
            this.framework = framework;
        }

        @Override
        public final Builder framework(String framework) {
            this.framework = framework;
            return this;
        }

        public final Boolean getEnableAutoBuild() {
            return enableAutoBuild;
        }

        public final void setEnableAutoBuild(Boolean enableAutoBuild) {
            this.enableAutoBuild = enableAutoBuild;
        }

        @Override
        public final Builder enableAutoBuild(Boolean enableAutoBuild) {
            this.enableAutoBuild = enableAutoBuild;
            return this;
        }

        public final Map<String, String> getEnvironmentVariables() {
            if (environmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return environmentVariables;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
            return this;
        }

        public final String getBasicAuthCredentials() {
            return basicAuthCredentials;
        }

        public final void setBasicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
        }

        @Override
        public final Builder basicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
            return this;
        }

        public final Boolean getEnableBasicAuth() {
            return enableBasicAuth;
        }

        public final void setEnableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
        }

        @Override
        public final Builder enableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
            return this;
        }

        public final Boolean getEnablePerformanceMode() {
            return enablePerformanceMode;
        }

        public final void setEnablePerformanceMode(Boolean enablePerformanceMode) {
            this.enablePerformanceMode = enablePerformanceMode;
        }

        @Override
        public final Builder enablePerformanceMode(Boolean enablePerformanceMode) {
            this.enablePerformanceMode = enablePerformanceMode;
            return this;
        }

        public final String getBuildSpec() {
            return buildSpec;
        }

        public final void setBuildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
        }

        @Override
        public final Builder buildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        public final Boolean getEnablePullRequestPreview() {
            return enablePullRequestPreview;
        }

        public final void setEnablePullRequestPreview(Boolean enablePullRequestPreview) {
            this.enablePullRequestPreview = enablePullRequestPreview;
        }

        @Override
        public final Builder enablePullRequestPreview(Boolean enablePullRequestPreview) {
            this.enablePullRequestPreview = enablePullRequestPreview;
            return this;
        }

        public final String getPullRequestEnvironmentName() {
            return pullRequestEnvironmentName;
        }

        public final void setPullRequestEnvironmentName(String pullRequestEnvironmentName) {
            this.pullRequestEnvironmentName = pullRequestEnvironmentName;
        }

        @Override
        public final Builder pullRequestEnvironmentName(String pullRequestEnvironmentName) {
            this.pullRequestEnvironmentName = pullRequestEnvironmentName;
            return this;
        }

        @Override
        public AutoBranchCreationConfig build() {
            return new AutoBranchCreationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
