/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the current SSL/TLS certificate that is in use for the domain. If you are using
 * <code>CreateDomainAssociation</code> to create a new domain association, <code>Certificate</code> describes the new
 * certificate that you are creating.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Certificate implements SdkPojo, Serializable, ToCopyableBuilder<Certificate.Builder, Certificate> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(Certificate::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> CUSTOM_CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customCertificateArn").getter(getter(Certificate::customCertificateArn))
            .setter(setter(Builder::customCertificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customCertificateArn").build())
            .build();

    private static final SdkField<String> CERTIFICATE_VERIFICATION_DNS_RECORD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("certificateVerificationDNSRecord")
            .getter(getter(Certificate::certificateVerificationDNSRecord))
            .setter(setter(Builder::certificateVerificationDNSRecord))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateVerificationDNSRecord")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            CUSTOM_CERTIFICATE_ARN_FIELD, CERTIFICATE_VERIFICATION_DNS_RECORD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String customCertificateArn;

    private final String certificateVerificationDNSRecord;

    private Certificate(BuilderImpl builder) {
        this.type = builder.type;
        this.customCertificateArn = builder.customCertificateArn;
        this.certificateVerificationDNSRecord = builder.certificateVerificationDNSRecord;
    }

    /**
     * <p>
     * The type of SSL/TLS certificate that you want to use.
     * </p>
     * <p>
     * Specify <code>AMPLIFY_MANAGED</code> to use the default certificate that Amplify provisions for you.
     * </p>
     * <p>
     * Specify <code>CUSTOM</code> to use your own certificate that you have already added to Certificate Manager in
     * your Amazon Web Services account. Make sure you request (or import) the certificate in the US East (N. Virginia)
     * Region (us-east-1). For more information about using ACM, see <a
     * href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into
     * Certificate Manager</a> in the <i>ACM User guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CertificateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of SSL/TLS certificate that you want to use.</p>
     *         <p>
     *         Specify <code>AMPLIFY_MANAGED</code> to use the default certificate that Amplify provisions for you.
     *         </p>
     *         <p>
     *         Specify <code>CUSTOM</code> to use your own certificate that you have already added to Certificate
     *         Manager in your Amazon Web Services account. Make sure you request (or import) the certificate in the US
     *         East (N. Virginia) Region (us-east-1). For more information about using ACM, see <a
     *         href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates
     *         into Certificate Manager</a> in the <i>ACM User guide</i>.
     * @see CertificateType
     */
    public final CertificateType type() {
        return CertificateType.fromValue(type);
    }

    /**
     * <p>
     * The type of SSL/TLS certificate that you want to use.
     * </p>
     * <p>
     * Specify <code>AMPLIFY_MANAGED</code> to use the default certificate that Amplify provisions for you.
     * </p>
     * <p>
     * Specify <code>CUSTOM</code> to use your own certificate that you have already added to Certificate Manager in
     * your Amazon Web Services account. Make sure you request (or import) the certificate in the US East (N. Virginia)
     * Region (us-east-1). For more information about using ACM, see <a
     * href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into
     * Certificate Manager</a> in the <i>ACM User guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CertificateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of SSL/TLS certificate that you want to use.</p>
     *         <p>
     *         Specify <code>AMPLIFY_MANAGED</code> to use the default certificate that Amplify provisions for you.
     *         </p>
     *         <p>
     *         Specify <code>CUSTOM</code> to use your own certificate that you have already added to Certificate
     *         Manager in your Amazon Web Services account. Make sure you request (or import) the certificate in the US
     *         East (N. Virginia) Region (us-east-1). For more information about using ACM, see <a
     *         href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates
     *         into Certificate Manager</a> in the <i>ACM User guide</i>.
     * @see CertificateType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) for a custom certificate that you have already added to Certificate Manager in
     * your Amazon Web Services account.
     * </p>
     * <p>
     * This field is required only when the certificate type is <code>CUSTOM</code>.
     * </p>
     * 
     * @return The Amazon resource name (ARN) for a custom certificate that you have already added to Certificate
     *         Manager in your Amazon Web Services account. </p>
     *         <p>
     *         This field is required only when the certificate type is <code>CUSTOM</code>.
     */
    public final String customCertificateArn() {
        return customCertificateArn;
    }

    /**
     * <p>
     * The DNS record for certificate verification.
     * </p>
     * 
     * @return The DNS record for certificate verification.
     */
    public final String certificateVerificationDNSRecord() {
        return certificateVerificationDNSRecord;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateVerificationDNSRecord());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(customCertificateArn(), other.customCertificateArn())
                && Objects.equals(certificateVerificationDNSRecord(), other.certificateVerificationDNSRecord());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Certificate").add("Type", typeAsString()).add("CustomCertificateArn", customCertificateArn())
                .add("CertificateVerificationDNSRecord", certificateVerificationDNSRecord()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "customCertificateArn":
            return Optional.ofNullable(clazz.cast(customCertificateArn()));
        case "certificateVerificationDNSRecord":
            return Optional.ofNullable(clazz.cast(certificateVerificationDNSRecord()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Certificate, T> g) {
        return obj -> g.apply((Certificate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Certificate> {
        /**
         * <p>
         * The type of SSL/TLS certificate that you want to use.
         * </p>
         * <p>
         * Specify <code>AMPLIFY_MANAGED</code> to use the default certificate that Amplify provisions for you.
         * </p>
         * <p>
         * Specify <code>CUSTOM</code> to use your own certificate that you have already added to Certificate Manager in
         * your Amazon Web Services account. Make sure you request (or import) the certificate in the US East (N.
         * Virginia) Region (us-east-1). For more information about using ACM, see <a
         * href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into
         * Certificate Manager</a> in the <i>ACM User guide</i>.
         * </p>
         * 
         * @param type
         *        The type of SSL/TLS certificate that you want to use.</p>
         *        <p>
         *        Specify <code>AMPLIFY_MANAGED</code> to use the default certificate that Amplify provisions for you.
         *        </p>
         *        <p>
         *        Specify <code>CUSTOM</code> to use your own certificate that you have already added to Certificate
         *        Manager in your Amazon Web Services account. Make sure you request (or import) the certificate in the
         *        US East (N. Virginia) Region (us-east-1). For more information about using ACM, see <a
         *        href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates
         *        into Certificate Manager</a> in the <i>ACM User guide</i>.
         * @see CertificateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of SSL/TLS certificate that you want to use.
         * </p>
         * <p>
         * Specify <code>AMPLIFY_MANAGED</code> to use the default certificate that Amplify provisions for you.
         * </p>
         * <p>
         * Specify <code>CUSTOM</code> to use your own certificate that you have already added to Certificate Manager in
         * your Amazon Web Services account. Make sure you request (or import) the certificate in the US East (N.
         * Virginia) Region (us-east-1). For more information about using ACM, see <a
         * href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into
         * Certificate Manager</a> in the <i>ACM User guide</i>.
         * </p>
         * 
         * @param type
         *        The type of SSL/TLS certificate that you want to use.</p>
         *        <p>
         *        Specify <code>AMPLIFY_MANAGED</code> to use the default certificate that Amplify provisions for you.
         *        </p>
         *        <p>
         *        Specify <code>CUSTOM</code> to use your own certificate that you have already added to Certificate
         *        Manager in your Amazon Web Services account. Make sure you request (or import) the certificate in the
         *        US East (N. Virginia) Region (us-east-1). For more information about using ACM, see <a
         *        href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates
         *        into Certificate Manager</a> in the <i>ACM User guide</i>.
         * @see CertificateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateType
         */
        Builder type(CertificateType type);

        /**
         * <p>
         * The Amazon resource name (ARN) for a custom certificate that you have already added to Certificate Manager in
         * your Amazon Web Services account.
         * </p>
         * <p>
         * This field is required only when the certificate type is <code>CUSTOM</code>.
         * </p>
         * 
         * @param customCertificateArn
         *        The Amazon resource name (ARN) for a custom certificate that you have already added to Certificate
         *        Manager in your Amazon Web Services account. </p>
         *        <p>
         *        This field is required only when the certificate type is <code>CUSTOM</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customCertificateArn(String customCertificateArn);

        /**
         * <p>
         * The DNS record for certificate verification.
         * </p>
         * 
         * @param certificateVerificationDNSRecord
         *        The DNS record for certificate verification.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateVerificationDNSRecord(String certificateVerificationDNSRecord);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String customCertificateArn;

        private String certificateVerificationDNSRecord;

        private BuilderImpl() {
        }

        private BuilderImpl(Certificate model) {
            type(model.type);
            customCertificateArn(model.customCertificateArn);
            certificateVerificationDNSRecord(model.certificateVerificationDNSRecord);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CertificateType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getCustomCertificateArn() {
            return customCertificateArn;
        }

        public final void setCustomCertificateArn(String customCertificateArn) {
            this.customCertificateArn = customCertificateArn;
        }

        @Override
        public final Builder customCertificateArn(String customCertificateArn) {
            this.customCertificateArn = customCertificateArn;
            return this;
        }

        public final String getCertificateVerificationDNSRecord() {
            return certificateVerificationDNSRecord;
        }

        public final void setCertificateVerificationDNSRecord(String certificateVerificationDNSRecord) {
            this.certificateVerificationDNSRecord = certificateVerificationDNSRecord;
        }

        @Override
        public final Builder certificateVerificationDNSRecord(String certificateVerificationDNSRecord) {
            this.certificateVerificationDNSRecord = certificateVerificationDNSRecord;
            return this;
        }

        @Override
        public Certificate build() {
            return new Certificate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
