/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result structure for the generate access logs request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerateAccessLogsResponse extends AmplifyResponse implements
        ToCopyableBuilder<GenerateAccessLogsResponse.Builder, GenerateAccessLogsResponse> {
    private static final SdkField<String> LOG_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("logUrl")
            .getter(getter(GenerateAccessLogsResponse::logUrl)).setter(setter(Builder::logUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_URL_FIELD));

    private final String logUrl;

    private GenerateAccessLogsResponse(BuilderImpl builder) {
        super(builder);
        this.logUrl = builder.logUrl;
    }

    /**
     * <p>
     * The pre-signed URL for the requested access logs.
     * </p>
     * 
     * @return The pre-signed URL for the requested access logs.
     */
    public final String logUrl() {
        return logUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(logUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateAccessLogsResponse)) {
            return false;
        }
        GenerateAccessLogsResponse other = (GenerateAccessLogsResponse) obj;
        return Objects.equals(logUrl(), other.logUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerateAccessLogsResponse").add("LogUrl", logUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logUrl":
            return Optional.ofNullable(clazz.cast(logUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GenerateAccessLogsResponse, T> g) {
        return obj -> g.apply((GenerateAccessLogsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyResponse.Builder, SdkPojo, CopyableBuilder<Builder, GenerateAccessLogsResponse> {
        /**
         * <p>
         * The pre-signed URL for the requested access logs.
         * </p>
         * 
         * @param logUrl
         *        The pre-signed URL for the requested access logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logUrl(String logUrl);
    }

    static final class BuilderImpl extends AmplifyResponse.BuilderImpl implements Builder {
        private String logUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateAccessLogsResponse model) {
            super(model);
            logUrl(model.logUrl);
        }

        public final String getLogUrl() {
            return logUrl;
        }

        public final void setLogUrl(String logUrl) {
            this.logUrl = logUrl;
        }

        @Override
        public final Builder logUrl(String logUrl) {
            this.logUrl = logUrl;
            return this;
        }

        @Override
        public GenerateAccessLogsResponse build() {
            return new GenerateAccessLogsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
