/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request structure for the start a deployment request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDeploymentRequest extends AmplifyRequest implements
        ToCopyableBuilder<StartDeploymentRequest.Builder, StartDeploymentRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(StartDeploymentRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()).build();

    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("branchName").getter(getter(StartDeploymentRequest::branchName)).setter(setter(Builder::branchName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("branchName").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(StartDeploymentRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> SOURCE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceUrl").getter(getter(StartDeploymentRequest::sourceUrl)).setter(setter(Builder::sourceUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            BRANCH_NAME_FIELD, JOB_ID_FIELD, SOURCE_URL_FIELD));

    private final String appId;

    private final String branchName;

    private final String jobId;

    private final String sourceUrl;

    private StartDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.branchName = builder.branchName;
        this.jobId = builder.jobId;
        this.sourceUrl = builder.sourceUrl;
    }

    /**
     * <p>
     * The unique ID for an Amplify app.
     * </p>
     * 
     * @return The unique ID for an Amplify app.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The name of the branch to use for the job.
     * </p>
     * 
     * @return The name of the branch to use for the job.
     */
    public final String branchName() {
        return branchName;
    }

    /**
     * <p>
     * The job ID for this deployment, generated by the create deployment request.
     * </p>
     * 
     * @return The job ID for this deployment, generated by the create deployment request.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The source URL for this deployment, used when calling start deployment without create deployment. The source URL
     * can be any HTTP GET URL that is publicly accessible and downloads a single .zip file.
     * </p>
     * 
     * @return The source URL for this deployment, used when calling start deployment without create deployment. The
     *         source URL can be any HTTP GET URL that is publicly accessible and downloads a single .zip file.
     */
    public final String sourceUrl() {
        return sourceUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(branchName());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDeploymentRequest)) {
            return false;
        }
        StartDeploymentRequest other = (StartDeploymentRequest) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(branchName(), other.branchName())
                && Objects.equals(jobId(), other.jobId()) && Objects.equals(sourceUrl(), other.sourceUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartDeploymentRequest").add("AppId", appId()).add("BranchName", branchName())
                .add("JobId", jobId()).add("SourceUrl", sourceUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "branchName":
            return Optional.ofNullable(clazz.cast(branchName()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "sourceUrl":
            return Optional.ofNullable(clazz.cast(sourceUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDeploymentRequest, T> g) {
        return obj -> g.apply((StartDeploymentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartDeploymentRequest> {
        /**
         * <p>
         * The unique ID for an Amplify app.
         * </p>
         * 
         * @param appId
         *        The unique ID for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The name of the branch to use for the job.
         * </p>
         * 
         * @param branchName
         *        The name of the branch to use for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchName(String branchName);

        /**
         * <p>
         * The job ID for this deployment, generated by the create deployment request.
         * </p>
         * 
         * @param jobId
         *        The job ID for this deployment, generated by the create deployment request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The source URL for this deployment, used when calling start deployment without create deployment. The source
         * URL can be any HTTP GET URL that is publicly accessible and downloads a single .zip file.
         * </p>
         * 
         * @param sourceUrl
         *        The source URL for this deployment, used when calling start deployment without create deployment. The
         *        source URL can be any HTTP GET URL that is publicly accessible and downloads a single .zip file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceUrl(String sourceUrl);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmplifyRequest.BuilderImpl implements Builder {
        private String appId;

        private String branchName;

        private String jobId;

        private String sourceUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDeploymentRequest model) {
            super(model);
            appId(model.appId);
            branchName(model.branchName);
            jobId(model.jobId);
            sourceUrl(model.sourceUrl);
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getBranchName() {
            return branchName;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getSourceUrl() {
            return sourceUrl;
        }

        public final void setSourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
        }

        @Override
        public final Builder sourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDeploymentRequest build() {
            return new StartDeploymentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
