/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplify.model.AmplifyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBackendEnvironmentRequest
extends AmplifyRequest
implements ToCopyableBuilder<Builder, CreateBackendEnvironmentRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appId").getter(CreateBackendEnvironmentRequest.getter(CreateBackendEnvironmentRequest::appId)).setter(CreateBackendEnvironmentRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentName").getter(CreateBackendEnvironmentRequest.getter(CreateBackendEnvironmentRequest::environmentName)).setter(CreateBackendEnvironmentRequest.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()}).build();
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stackName").getter(CreateBackendEnvironmentRequest.getter(CreateBackendEnvironmentRequest::stackName)).setter(CreateBackendEnvironmentRequest.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stackName").build()}).build();
    private static final SdkField<String> DEPLOYMENT_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentArtifacts").getter(CreateBackendEnvironmentRequest.getter(CreateBackendEnvironmentRequest::deploymentArtifacts)).setter(CreateBackendEnvironmentRequest.setter(Builder::deploymentArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentArtifacts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, ENVIRONMENT_NAME_FIELD, STACK_NAME_FIELD, DEPLOYMENT_ARTIFACTS_FIELD));
    private final String appId;
    private final String environmentName;
    private final String stackName;
    private final String deploymentArtifacts;

    private CreateBackendEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.environmentName = builder.environmentName;
        this.stackName = builder.stackName;
        this.deploymentArtifacts = builder.deploymentArtifacts;
    }

    public final String appId() {
        return this.appId;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final String stackName() {
        return this.stackName;
    }

    public final String deploymentArtifacts() {
        return this.deploymentArtifacts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentArtifacts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackendEnvironmentRequest)) {
            return false;
        }
        CreateBackendEnvironmentRequest other = (CreateBackendEnvironmentRequest)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.deploymentArtifacts(), other.deploymentArtifacts());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBackendEnvironmentRequest").add("AppId", (Object)this.appId()).add("EnvironmentName", (Object)this.environmentName()).add("StackName", (Object)this.stackName()).add("DeploymentArtifacts", (Object)this.deploymentArtifacts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "environmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "stackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "deploymentArtifacts": {
                return Optional.ofNullable(clazz.cast(this.deploymentArtifacts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBackendEnvironmentRequest, T> g) {
        return obj -> g.apply((CreateBackendEnvironmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyRequest.BuilderImpl
    implements Builder {
        private String appId;
        private String environmentName;
        private String stackName;
        private String deploymentArtifacts;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackendEnvironmentRequest model) {
            super(model);
            this.appId(model.appId);
            this.environmentName(model.environmentName);
            this.stackName(model.stackName);
            this.deploymentArtifacts(model.deploymentArtifacts);
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        @Transient
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        @Transient
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getStackName() {
            return this.stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        @Transient
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getDeploymentArtifacts() {
            return this.deploymentArtifacts;
        }

        public final void setDeploymentArtifacts(String deploymentArtifacts) {
            this.deploymentArtifacts = deploymentArtifacts;
        }

        @Override
        @Transient
        public final Builder deploymentArtifacts(String deploymentArtifacts) {
            this.deploymentArtifacts = deploymentArtifacts;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBackendEnvironmentRequest build() {
            return new CreateBackendEnvironmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AmplifyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBackendEnvironmentRequest> {
        public Builder appId(String var1);

        public Builder environmentName(String var1);

        public Builder stackName(String var1);

        public Builder deploymentArtifacts(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

