/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request structure for the update branch request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBranchRequest extends AmplifyRequest implements
        ToCopyableBuilder<UpdateBranchRequest.Builder, UpdateBranchRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(UpdateBranchRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()).build();

    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("branchName").getter(getter(UpdateBranchRequest::branchName)).setter(setter(Builder::branchName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("branchName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateBranchRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> FRAMEWORK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("framework").getter(getter(UpdateBranchRequest::framework)).setter(setter(Builder::framework))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framework").build()).build();

    private static final SdkField<String> STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("stage")
            .getter(getter(UpdateBranchRequest::stageAsString)).setter(setter(Builder::stage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stage").build()).build();

    private static final SdkField<Boolean> ENABLE_NOTIFICATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableNotification").getter(getter(UpdateBranchRequest::enableNotification))
            .setter(setter(Builder::enableNotification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableNotification").build())
            .build();

    private static final SdkField<Boolean> ENABLE_AUTO_BUILD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableAutoBuild").getter(getter(UpdateBranchRequest::enableAutoBuild))
            .setter(setter(Builder::enableAutoBuild))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableAutoBuild").build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("environmentVariables")
            .getter(getter(UpdateBranchRequest::environmentVariables))
            .setter(setter(Builder::environmentVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> BASIC_AUTH_CREDENTIALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("basicAuthCredentials").getter(getter(UpdateBranchRequest::basicAuthCredentials))
            .setter(setter(Builder::basicAuthCredentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basicAuthCredentials").build())
            .build();

    private static final SdkField<Boolean> ENABLE_BASIC_AUTH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableBasicAuth").getter(getter(UpdateBranchRequest::enableBasicAuth))
            .setter(setter(Builder::enableBasicAuth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBasicAuth").build()).build();

    private static final SdkField<Boolean> ENABLE_PERFORMANCE_MODE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enablePerformanceMode").getter(getter(UpdateBranchRequest::enablePerformanceMode))
            .setter(setter(Builder::enablePerformanceMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enablePerformanceMode").build())
            .build();

    private static final SdkField<String> BUILD_SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("buildSpec").getter(getter(UpdateBranchRequest::buildSpec)).setter(setter(Builder::buildSpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildSpec").build()).build();

    private static final SdkField<String> TTL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ttl")
            .getter(getter(UpdateBranchRequest::ttl)).setter(setter(Builder::ttl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttl").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(UpdateBranchRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<Boolean> ENABLE_PULL_REQUEST_PREVIEW_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("enablePullRequestPreview")
            .getter(getter(UpdateBranchRequest::enablePullRequestPreview)).setter(setter(Builder::enablePullRequestPreview))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enablePullRequestPreview").build())
            .build();

    private static final SdkField<String> PULL_REQUEST_ENVIRONMENT_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("pullRequestEnvironmentName")
            .getter(getter(UpdateBranchRequest::pullRequestEnvironmentName))
            .setter(setter(Builder::pullRequestEnvironmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestEnvironmentName").build())
            .build();

    private static final SdkField<String> BACKEND_ENVIRONMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("backendEnvironmentArn").getter(getter(UpdateBranchRequest::backendEnvironmentArn))
            .setter(setter(Builder::backendEnvironmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendEnvironmentArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            BRANCH_NAME_FIELD, DESCRIPTION_FIELD, FRAMEWORK_FIELD, STAGE_FIELD, ENABLE_NOTIFICATION_FIELD,
            ENABLE_AUTO_BUILD_FIELD, ENVIRONMENT_VARIABLES_FIELD, BASIC_AUTH_CREDENTIALS_FIELD, ENABLE_BASIC_AUTH_FIELD,
            ENABLE_PERFORMANCE_MODE_FIELD, BUILD_SPEC_FIELD, TTL_FIELD, DISPLAY_NAME_FIELD, ENABLE_PULL_REQUEST_PREVIEW_FIELD,
            PULL_REQUEST_ENVIRONMENT_NAME_FIELD, BACKEND_ENVIRONMENT_ARN_FIELD));

    private final String appId;

    private final String branchName;

    private final String description;

    private final String framework;

    private final String stage;

    private final Boolean enableNotification;

    private final Boolean enableAutoBuild;

    private final Map<String, String> environmentVariables;

    private final String basicAuthCredentials;

    private final Boolean enableBasicAuth;

    private final Boolean enablePerformanceMode;

    private final String buildSpec;

    private final String ttl;

    private final String displayName;

    private final Boolean enablePullRequestPreview;

    private final String pullRequestEnvironmentName;

    private final String backendEnvironmentArn;

    private UpdateBranchRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.branchName = builder.branchName;
        this.description = builder.description;
        this.framework = builder.framework;
        this.stage = builder.stage;
        this.enableNotification = builder.enableNotification;
        this.enableAutoBuild = builder.enableAutoBuild;
        this.environmentVariables = builder.environmentVariables;
        this.basicAuthCredentials = builder.basicAuthCredentials;
        this.enableBasicAuth = builder.enableBasicAuth;
        this.enablePerformanceMode = builder.enablePerformanceMode;
        this.buildSpec = builder.buildSpec;
        this.ttl = builder.ttl;
        this.displayName = builder.displayName;
        this.enablePullRequestPreview = builder.enablePullRequestPreview;
        this.pullRequestEnvironmentName = builder.pullRequestEnvironmentName;
        this.backendEnvironmentArn = builder.backendEnvironmentArn;
    }

    /**
     * <p>
     * The unique ID for an Amplify app.
     * </p>
     * 
     * @return The unique ID for an Amplify app.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The name for the branch.
     * </p>
     * 
     * @return The name for the branch.
     */
    public final String branchName() {
        return branchName;
    }

    /**
     * <p>
     * The description for the branch.
     * </p>
     * 
     * @return The description for the branch.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The framework for the branch.
     * </p>
     * 
     * @return The framework for the branch.
     */
    public final String framework() {
        return framework;
    }

    /**
     * <p>
     * Describes the current stage for the branch.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link Stage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return Describes the current stage for the branch.
     * @see Stage
     */
    public final Stage stage() {
        return Stage.fromValue(stage);
    }

    /**
     * <p>
     * Describes the current stage for the branch.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link Stage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return Describes the current stage for the branch.
     * @see Stage
     */
    public final String stageAsString() {
        return stage;
    }

    /**
     * <p>
     * Enables notifications for the branch.
     * </p>
     * 
     * @return Enables notifications for the branch.
     */
    public final Boolean enableNotification() {
        return enableNotification;
    }

    /**
     * <p>
     * Enables auto building for the branch.
     * </p>
     * 
     * @return Enables auto building for the branch.
     */
    public final Boolean enableAutoBuild() {
        return enableAutoBuild;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentVariables property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironmentVariables() {
        return environmentVariables != null && !(environmentVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The environment variables for the branch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentVariables} method.
     * </p>
     * 
     * @return The environment variables for the branch.
     */
    public final Map<String, String> environmentVariables() {
        return environmentVariables;
    }

    /**
     * <p>
     * The basic authorization credentials for the branch.
     * </p>
     * 
     * @return The basic authorization credentials for the branch.
     */
    public final String basicAuthCredentials() {
        return basicAuthCredentials;
    }

    /**
     * <p>
     * Enables basic authorization for the branch.
     * </p>
     * 
     * @return Enables basic authorization for the branch.
     */
    public final Boolean enableBasicAuth() {
        return enableBasicAuth;
    }

    /**
     * <p>
     * Enables performance mode for the branch.
     * </p>
     * <p>
     * Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer
     * interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to
     * roll out.
     * </p>
     * 
     * @return Enables performance mode for the branch.</p>
     *         <p>
     *         Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a
     *         longer interval. When performance mode is enabled, hosting configuration or code changes can take up to
     *         10 minutes to roll out.
     */
    public final Boolean enablePerformanceMode() {
        return enablePerformanceMode;
    }

    /**
     * <p>
     * The build specification (build spec) for the branch.
     * </p>
     * 
     * @return The build specification (build spec) for the branch.
     */
    public final String buildSpec() {
        return buildSpec;
    }

    /**
     * <p>
     * The content Time to Live (TTL) for the website in seconds.
     * </p>
     * 
     * @return The content Time to Live (TTL) for the website in seconds.
     */
    public final String ttl() {
        return ttl;
    }

    /**
     * <p>
     * The display name for a branch. This is used as the default domain prefix.
     * </p>
     * 
     * @return The display name for a branch. This is used as the default domain prefix.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * Enables pull request previews for this branch.
     * </p>
     * 
     * @return Enables pull request previews for this branch.
     */
    public final Boolean enablePullRequestPreview() {
        return enablePullRequestPreview;
    }

    /**
     * <p>
     * The Amplify environment name for the pull request.
     * </p>
     * 
     * @return The Amplify environment name for the pull request.
     */
    public final String pullRequestEnvironmentName() {
        return pullRequestEnvironmentName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app.
     */
    public final String backendEnvironmentArn() {
        return backendEnvironmentArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(branchName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(framework());
        hashCode = 31 * hashCode + Objects.hashCode(stageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enableNotification());
        hashCode = 31 * hashCode + Objects.hashCode(enableAutoBuild());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentVariables() ? environmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(basicAuthCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(enableBasicAuth());
        hashCode = 31 * hashCode + Objects.hashCode(enablePerformanceMode());
        hashCode = 31 * hashCode + Objects.hashCode(buildSpec());
        hashCode = 31 * hashCode + Objects.hashCode(ttl());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(enablePullRequestPreview());
        hashCode = 31 * hashCode + Objects.hashCode(pullRequestEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(backendEnvironmentArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBranchRequest)) {
            return false;
        }
        UpdateBranchRequest other = (UpdateBranchRequest) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(branchName(), other.branchName())
                && Objects.equals(description(), other.description()) && Objects.equals(framework(), other.framework())
                && Objects.equals(stageAsString(), other.stageAsString())
                && Objects.equals(enableNotification(), other.enableNotification())
                && Objects.equals(enableAutoBuild(), other.enableAutoBuild())
                && hasEnvironmentVariables() == other.hasEnvironmentVariables()
                && Objects.equals(environmentVariables(), other.environmentVariables())
                && Objects.equals(basicAuthCredentials(), other.basicAuthCredentials())
                && Objects.equals(enableBasicAuth(), other.enableBasicAuth())
                && Objects.equals(enablePerformanceMode(), other.enablePerformanceMode())
                && Objects.equals(buildSpec(), other.buildSpec()) && Objects.equals(ttl(), other.ttl())
                && Objects.equals(displayName(), other.displayName())
                && Objects.equals(enablePullRequestPreview(), other.enablePullRequestPreview())
                && Objects.equals(pullRequestEnvironmentName(), other.pullRequestEnvironmentName())
                && Objects.equals(backendEnvironmentArn(), other.backendEnvironmentArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBranchRequest").add("AppId", appId()).add("BranchName", branchName())
                .add("Description", description()).add("Framework", framework()).add("Stage", stageAsString())
                .add("EnableNotification", enableNotification()).add("EnableAutoBuild", enableAutoBuild())
                .add("EnvironmentVariables", hasEnvironmentVariables() ? environmentVariables() : null)
                .add("BasicAuthCredentials", basicAuthCredentials() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EnableBasicAuth", enableBasicAuth()).add("EnablePerformanceMode", enablePerformanceMode())
                .add("BuildSpec", buildSpec()).add("Ttl", ttl()).add("DisplayName", displayName())
                .add("EnablePullRequestPreview", enablePullRequestPreview())
                .add("PullRequestEnvironmentName", pullRequestEnvironmentName())
                .add("BackendEnvironmentArn", backendEnvironmentArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "branchName":
            return Optional.ofNullable(clazz.cast(branchName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "framework":
            return Optional.ofNullable(clazz.cast(framework()));
        case "stage":
            return Optional.ofNullable(clazz.cast(stageAsString()));
        case "enableNotification":
            return Optional.ofNullable(clazz.cast(enableNotification()));
        case "enableAutoBuild":
            return Optional.ofNullable(clazz.cast(enableAutoBuild()));
        case "environmentVariables":
            return Optional.ofNullable(clazz.cast(environmentVariables()));
        case "basicAuthCredentials":
            return Optional.ofNullable(clazz.cast(basicAuthCredentials()));
        case "enableBasicAuth":
            return Optional.ofNullable(clazz.cast(enableBasicAuth()));
        case "enablePerformanceMode":
            return Optional.ofNullable(clazz.cast(enablePerformanceMode()));
        case "buildSpec":
            return Optional.ofNullable(clazz.cast(buildSpec()));
        case "ttl":
            return Optional.ofNullable(clazz.cast(ttl()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "enablePullRequestPreview":
            return Optional.ofNullable(clazz.cast(enablePullRequestPreview()));
        case "pullRequestEnvironmentName":
            return Optional.ofNullable(clazz.cast(pullRequestEnvironmentName()));
        case "backendEnvironmentArn":
            return Optional.ofNullable(clazz.cast(backendEnvironmentArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBranchRequest, T> g) {
        return obj -> g.apply((UpdateBranchRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBranchRequest> {
        /**
         * <p>
         * The unique ID for an Amplify app.
         * </p>
         * 
         * @param appId
         *        The unique ID for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The name for the branch.
         * </p>
         * 
         * @param branchName
         *        The name for the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchName(String branchName);

        /**
         * <p>
         * The description for the branch.
         * </p>
         * 
         * @param description
         *        The description for the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The framework for the branch.
         * </p>
         * 
         * @param framework
         *        The framework for the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder framework(String framework);

        /**
         * <p>
         * Describes the current stage for the branch.
         * </p>
         * 
         * @param stage
         *        Describes the current stage for the branch.
         * @see Stage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Stage
         */
        Builder stage(String stage);

        /**
         * <p>
         * Describes the current stage for the branch.
         * </p>
         * 
         * @param stage
         *        Describes the current stage for the branch.
         * @see Stage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Stage
         */
        Builder stage(Stage stage);

        /**
         * <p>
         * Enables notifications for the branch.
         * </p>
         * 
         * @param enableNotification
         *        Enables notifications for the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableNotification(Boolean enableNotification);

        /**
         * <p>
         * Enables auto building for the branch.
         * </p>
         * 
         * @param enableAutoBuild
         *        Enables auto building for the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableAutoBuild(Boolean enableAutoBuild);

        /**
         * <p>
         * The environment variables for the branch.
         * </p>
         * 
         * @param environmentVariables
         *        The environment variables for the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentVariables(Map<String, String> environmentVariables);

        /**
         * <p>
         * The basic authorization credentials for the branch.
         * </p>
         * 
         * @param basicAuthCredentials
         *        The basic authorization credentials for the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basicAuthCredentials(String basicAuthCredentials);

        /**
         * <p>
         * Enables basic authorization for the branch.
         * </p>
         * 
         * @param enableBasicAuth
         *        Enables basic authorization for the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableBasicAuth(Boolean enableBasicAuth);

        /**
         * <p>
         * Enables performance mode for the branch.
         * </p>
         * <p>
         * Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer
         * interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes
         * to roll out.
         * </p>
         * 
         * @param enablePerformanceMode
         *        Enables performance mode for the branch.</p>
         *        <p>
         *        Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a
         *        longer interval. When performance mode is enabled, hosting configuration or code changes can take up
         *        to 10 minutes to roll out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePerformanceMode(Boolean enablePerformanceMode);

        /**
         * <p>
         * The build specification (build spec) for the branch.
         * </p>
         * 
         * @param buildSpec
         *        The build specification (build spec) for the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildSpec(String buildSpec);

        /**
         * <p>
         * The content Time to Live (TTL) for the website in seconds.
         * </p>
         * 
         * @param ttl
         *        The content Time to Live (TTL) for the website in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttl(String ttl);

        /**
         * <p>
         * The display name for a branch. This is used as the default domain prefix.
         * </p>
         * 
         * @param displayName
         *        The display name for a branch. This is used as the default domain prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * Enables pull request previews for this branch.
         * </p>
         * 
         * @param enablePullRequestPreview
         *        Enables pull request previews for this branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enablePullRequestPreview(Boolean enablePullRequestPreview);

        /**
         * <p>
         * The Amplify environment name for the pull request.
         * </p>
         * 
         * @param pullRequestEnvironmentName
         *        The Amplify environment name for the pull request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullRequestEnvironmentName(String pullRequestEnvironmentName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app.
         * </p>
         * 
         * @param backendEnvironmentArn
         *        The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backendEnvironmentArn(String backendEnvironmentArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmplifyRequest.BuilderImpl implements Builder {
        private String appId;

        private String branchName;

        private String description;

        private String framework;

        private String stage;

        private Boolean enableNotification;

        private Boolean enableAutoBuild;

        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();

        private String basicAuthCredentials;

        private Boolean enableBasicAuth;

        private Boolean enablePerformanceMode;

        private String buildSpec;

        private String ttl;

        private String displayName;

        private Boolean enablePullRequestPreview;

        private String pullRequestEnvironmentName;

        private String backendEnvironmentArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBranchRequest model) {
            super(model);
            appId(model.appId);
            branchName(model.branchName);
            description(model.description);
            framework(model.framework);
            stage(model.stage);
            enableNotification(model.enableNotification);
            enableAutoBuild(model.enableAutoBuild);
            environmentVariables(model.environmentVariables);
            basicAuthCredentials(model.basicAuthCredentials);
            enableBasicAuth(model.enableBasicAuth);
            enablePerformanceMode(model.enablePerformanceMode);
            buildSpec(model.buildSpec);
            ttl(model.ttl);
            displayName(model.displayName);
            enablePullRequestPreview(model.enablePullRequestPreview);
            pullRequestEnvironmentName(model.pullRequestEnvironmentName);
            backendEnvironmentArn(model.backendEnvironmentArn);
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        @Transient
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getBranchName() {
            return branchName;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        @Override
        @Transient
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFramework() {
            return framework;
        }

        public final void setFramework(String framework) {
            this.framework = framework;
        }

        @Override
        @Transient
        public final Builder framework(String framework) {
            this.framework = framework;
            return this;
        }

        public final String getStage() {
            return stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        @Transient
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        @Transient
        public final Builder stage(Stage stage) {
            this.stage(stage == null ? null : stage.toString());
            return this;
        }

        public final Boolean getEnableNotification() {
            return enableNotification;
        }

        public final void setEnableNotification(Boolean enableNotification) {
            this.enableNotification = enableNotification;
        }

        @Override
        @Transient
        public final Builder enableNotification(Boolean enableNotification) {
            this.enableNotification = enableNotification;
            return this;
        }

        public final Boolean getEnableAutoBuild() {
            return enableAutoBuild;
        }

        public final void setEnableAutoBuild(Boolean enableAutoBuild) {
            this.enableAutoBuild = enableAutoBuild;
        }

        @Override
        @Transient
        public final Builder enableAutoBuild(Boolean enableAutoBuild) {
            this.enableAutoBuild = enableAutoBuild;
            return this;
        }

        public final Map<String, String> getEnvironmentVariables() {
            if (environmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return environmentVariables;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
        }

        @Override
        @Transient
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
            return this;
        }

        public final String getBasicAuthCredentials() {
            return basicAuthCredentials;
        }

        public final void setBasicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
        }

        @Override
        @Transient
        public final Builder basicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
            return this;
        }

        public final Boolean getEnableBasicAuth() {
            return enableBasicAuth;
        }

        public final void setEnableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
        }

        @Override
        @Transient
        public final Builder enableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
            return this;
        }

        public final Boolean getEnablePerformanceMode() {
            return enablePerformanceMode;
        }

        public final void setEnablePerformanceMode(Boolean enablePerformanceMode) {
            this.enablePerformanceMode = enablePerformanceMode;
        }

        @Override
        @Transient
        public final Builder enablePerformanceMode(Boolean enablePerformanceMode) {
            this.enablePerformanceMode = enablePerformanceMode;
            return this;
        }

        public final String getBuildSpec() {
            return buildSpec;
        }

        public final void setBuildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
        }

        @Override
        @Transient
        public final Builder buildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        public final String getTtl() {
            return ttl;
        }

        public final void setTtl(String ttl) {
            this.ttl = ttl;
        }

        @Override
        @Transient
        public final Builder ttl(String ttl) {
            this.ttl = ttl;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        @Transient
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Boolean getEnablePullRequestPreview() {
            return enablePullRequestPreview;
        }

        public final void setEnablePullRequestPreview(Boolean enablePullRequestPreview) {
            this.enablePullRequestPreview = enablePullRequestPreview;
        }

        @Override
        @Transient
        public final Builder enablePullRequestPreview(Boolean enablePullRequestPreview) {
            this.enablePullRequestPreview = enablePullRequestPreview;
            return this;
        }

        public final String getPullRequestEnvironmentName() {
            return pullRequestEnvironmentName;
        }

        public final void setPullRequestEnvironmentName(String pullRequestEnvironmentName) {
            this.pullRequestEnvironmentName = pullRequestEnvironmentName;
        }

        @Override
        @Transient
        public final Builder pullRequestEnvironmentName(String pullRequestEnvironmentName) {
            this.pullRequestEnvironmentName = pullRequestEnvironmentName;
            return this;
        }

        public final String getBackendEnvironmentArn() {
            return backendEnvironmentArn;
        }

        public final void setBackendEnvironmentArn(String backendEnvironmentArn) {
            this.backendEnvironmentArn = backendEnvironmentArn;
        }

        @Override
        @Transient
        public final Builder backendEnvironmentArn(String backendEnvironmentArn) {
            this.backendEnvironmentArn = backendEnvironmentArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBranchRequest build() {
            return new UpdateBranchRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
