/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request structure for the create domain association request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDomainAssociationRequest extends AmplifyRequest implements
        ToCopyableBuilder<CreateDomainAssociationRequest.Builder, CreateDomainAssociationRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("appId")
            .getter(getter(CreateDomainAssociationRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainName").getter(getter(CreateDomainAssociationRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<Boolean> ENABLE_AUTO_SUB_DOMAIN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableAutoSubDomain").getter(getter(CreateDomainAssociationRequest::enableAutoSubDomain))
            .setter(setter(Builder::enableAutoSubDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableAutoSubDomain").build())
            .build();

    private static final SdkField<List<SubDomainSetting>> SUB_DOMAIN_SETTINGS_FIELD = SdkField
            .<List<SubDomainSetting>> builder(MarshallingType.LIST)
            .memberName("subDomainSettings")
            .getter(getter(CreateDomainAssociationRequest::subDomainSettings))
            .setter(setter(Builder::subDomainSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subDomainSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SubDomainSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubDomainSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AUTO_SUB_DOMAIN_CREATION_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("autoSubDomainCreationPatterns")
            .getter(getter(CreateDomainAssociationRequest::autoSubDomainCreationPatterns))
            .setter(setter(Builder::autoSubDomainCreationPatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoSubDomainCreationPatterns")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AUTO_SUB_DOMAIN_IAM_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("autoSubDomainIAMRole").getter(getter(CreateDomainAssociationRequest::autoSubDomainIAMRole))
            .setter(setter(Builder::autoSubDomainIAMRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoSubDomainIAMRole").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            DOMAIN_NAME_FIELD, ENABLE_AUTO_SUB_DOMAIN_FIELD, SUB_DOMAIN_SETTINGS_FIELD, AUTO_SUB_DOMAIN_CREATION_PATTERNS_FIELD,
            AUTO_SUB_DOMAIN_IAM_ROLE_FIELD));

    private final String appId;

    private final String domainName;

    private final Boolean enableAutoSubDomain;

    private final List<SubDomainSetting> subDomainSettings;

    private final List<String> autoSubDomainCreationPatterns;

    private final String autoSubDomainIAMRole;

    private CreateDomainAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.domainName = builder.domainName;
        this.enableAutoSubDomain = builder.enableAutoSubDomain;
        this.subDomainSettings = builder.subDomainSettings;
        this.autoSubDomainCreationPatterns = builder.autoSubDomainCreationPatterns;
        this.autoSubDomainIAMRole = builder.autoSubDomainIAMRole;
    }

    /**
     * <p>
     * The unique ID for an Amplify app.
     * </p>
     * 
     * @return The unique ID for an Amplify app.
     */
    public final String appId() {
        return appId;
    }

    /**
     * <p>
     * The domain name for the domain association.
     * </p>
     * 
     * @return The domain name for the domain association.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Enables the automated creation of subdomains for branches.
     * </p>
     * 
     * @return Enables the automated creation of subdomains for branches.
     */
    public final Boolean enableAutoSubDomain() {
        return enableAutoSubDomain;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubDomainSettings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubDomainSettings() {
        return subDomainSettings != null && !(subDomainSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The setting for the subdomain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubDomainSettings} method.
     * </p>
     * 
     * @return The setting for the subdomain.
     */
    public final List<SubDomainSetting> subDomainSettings() {
        return subDomainSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the AutoSubDomainCreationPatterns property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAutoSubDomainCreationPatterns() {
        return autoSubDomainCreationPatterns != null && !(autoSubDomainCreationPatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Sets the branch patterns for automatic subdomain creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutoSubDomainCreationPatterns} method.
     * </p>
     * 
     * @return Sets the branch patterns for automatic subdomain creation.
     */
    public final List<String> autoSubDomainCreationPatterns() {
        return autoSubDomainCreationPatterns;
    }

    /**
     * <p>
     * The required AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) for
     * automatically creating subdomains.
     * </p>
     * 
     * @return The required AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) for
     *         automatically creating subdomains.
     */
    public final String autoSubDomainIAMRole() {
        return autoSubDomainIAMRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(enableAutoSubDomain());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubDomainSettings() ? subDomainSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAutoSubDomainCreationPatterns() ? autoSubDomainCreationPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(autoSubDomainIAMRole());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDomainAssociationRequest)) {
            return false;
        }
        CreateDomainAssociationRequest other = (CreateDomainAssociationRequest) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(domainName(), other.domainName())
                && Objects.equals(enableAutoSubDomain(), other.enableAutoSubDomain())
                && hasSubDomainSettings() == other.hasSubDomainSettings()
                && Objects.equals(subDomainSettings(), other.subDomainSettings())
                && hasAutoSubDomainCreationPatterns() == other.hasAutoSubDomainCreationPatterns()
                && Objects.equals(autoSubDomainCreationPatterns(), other.autoSubDomainCreationPatterns())
                && Objects.equals(autoSubDomainIAMRole(), other.autoSubDomainIAMRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateDomainAssociationRequest")
                .add("AppId", appId())
                .add("DomainName", domainName())
                .add("EnableAutoSubDomain", enableAutoSubDomain())
                .add("SubDomainSettings", hasSubDomainSettings() ? subDomainSettings() : null)
                .add("AutoSubDomainCreationPatterns", hasAutoSubDomainCreationPatterns() ? autoSubDomainCreationPatterns() : null)
                .add("AutoSubDomainIAMRole", autoSubDomainIAMRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "enableAutoSubDomain":
            return Optional.ofNullable(clazz.cast(enableAutoSubDomain()));
        case "subDomainSettings":
            return Optional.ofNullable(clazz.cast(subDomainSettings()));
        case "autoSubDomainCreationPatterns":
            return Optional.ofNullable(clazz.cast(autoSubDomainCreationPatterns()));
        case "autoSubDomainIAMRole":
            return Optional.ofNullable(clazz.cast(autoSubDomainIAMRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDomainAssociationRequest, T> g) {
        return obj -> g.apply((CreateDomainAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDomainAssociationRequest> {
        /**
         * <p>
         * The unique ID for an Amplify app.
         * </p>
         * 
         * @param appId
         *        The unique ID for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The domain name for the domain association.
         * </p>
         * 
         * @param domainName
         *        The domain name for the domain association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Enables the automated creation of subdomains for branches.
         * </p>
         * 
         * @param enableAutoSubDomain
         *        Enables the automated creation of subdomains for branches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableAutoSubDomain(Boolean enableAutoSubDomain);

        /**
         * <p>
         * The setting for the subdomain.
         * </p>
         * 
         * @param subDomainSettings
         *        The setting for the subdomain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subDomainSettings(Collection<SubDomainSetting> subDomainSettings);

        /**
         * <p>
         * The setting for the subdomain.
         * </p>
         * 
         * @param subDomainSettings
         *        The setting for the subdomain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subDomainSettings(SubDomainSetting... subDomainSettings);

        /**
         * <p>
         * The setting for the subdomain.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<SubDomainSetting>.Builder} avoiding
         * the need to create one manually via {@link List<SubDomainSetting>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SubDomainSetting>.Builder#build()} is called immediately and
         * its result is passed to {@link #subDomainSettings(List<SubDomainSetting>)}.
         * 
         * @param subDomainSettings
         *        a consumer that will call methods on {@link List<SubDomainSetting>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subDomainSettings(List<SubDomainSetting>)
         */
        Builder subDomainSettings(Consumer<SubDomainSetting.Builder>... subDomainSettings);

        /**
         * <p>
         * Sets the branch patterns for automatic subdomain creation.
         * </p>
         * 
         * @param autoSubDomainCreationPatterns
         *        Sets the branch patterns for automatic subdomain creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoSubDomainCreationPatterns(Collection<String> autoSubDomainCreationPatterns);

        /**
         * <p>
         * Sets the branch patterns for automatic subdomain creation.
         * </p>
         * 
         * @param autoSubDomainCreationPatterns
         *        Sets the branch patterns for automatic subdomain creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoSubDomainCreationPatterns(String... autoSubDomainCreationPatterns);

        /**
         * <p>
         * The required AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) for
         * automatically creating subdomains.
         * </p>
         * 
         * @param autoSubDomainIAMRole
         *        The required AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN)
         *        for automatically creating subdomains.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoSubDomainIAMRole(String autoSubDomainIAMRole);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmplifyRequest.BuilderImpl implements Builder {
        private String appId;

        private String domainName;

        private Boolean enableAutoSubDomain;

        private List<SubDomainSetting> subDomainSettings = DefaultSdkAutoConstructList.getInstance();

        private List<String> autoSubDomainCreationPatterns = DefaultSdkAutoConstructList.getInstance();

        private String autoSubDomainIAMRole;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDomainAssociationRequest model) {
            super(model);
            appId(model.appId);
            domainName(model.domainName);
            enableAutoSubDomain(model.enableAutoSubDomain);
            subDomainSettings(model.subDomainSettings);
            autoSubDomainCreationPatterns(model.autoSubDomainCreationPatterns);
            autoSubDomainIAMRole(model.autoSubDomainIAMRole);
        }

        public final String getAppId() {
            return appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        @Transient
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        @Transient
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Boolean getEnableAutoSubDomain() {
            return enableAutoSubDomain;
        }

        public final void setEnableAutoSubDomain(Boolean enableAutoSubDomain) {
            this.enableAutoSubDomain = enableAutoSubDomain;
        }

        @Override
        @Transient
        public final Builder enableAutoSubDomain(Boolean enableAutoSubDomain) {
            this.enableAutoSubDomain = enableAutoSubDomain;
            return this;
        }

        public final List<SubDomainSetting.Builder> getSubDomainSettings() {
            List<SubDomainSetting.Builder> result = SubDomainSettingsCopier.copyToBuilder(this.subDomainSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubDomainSettings(Collection<SubDomainSetting.BuilderImpl> subDomainSettings) {
            this.subDomainSettings = SubDomainSettingsCopier.copyFromBuilder(subDomainSettings);
        }

        @Override
        @Transient
        public final Builder subDomainSettings(Collection<SubDomainSetting> subDomainSettings) {
            this.subDomainSettings = SubDomainSettingsCopier.copy(subDomainSettings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subDomainSettings(SubDomainSetting... subDomainSettings) {
            subDomainSettings(Arrays.asList(subDomainSettings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subDomainSettings(Consumer<SubDomainSetting.Builder>... subDomainSettings) {
            subDomainSettings(Stream.of(subDomainSettings).map(c -> SubDomainSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAutoSubDomainCreationPatterns() {
            if (autoSubDomainCreationPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return autoSubDomainCreationPatterns;
        }

        public final void setAutoSubDomainCreationPatterns(Collection<String> autoSubDomainCreationPatterns) {
            this.autoSubDomainCreationPatterns = AutoSubDomainCreationPatternsCopier.copy(autoSubDomainCreationPatterns);
        }

        @Override
        @Transient
        public final Builder autoSubDomainCreationPatterns(Collection<String> autoSubDomainCreationPatterns) {
            this.autoSubDomainCreationPatterns = AutoSubDomainCreationPatternsCopier.copy(autoSubDomainCreationPatterns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder autoSubDomainCreationPatterns(String... autoSubDomainCreationPatterns) {
            autoSubDomainCreationPatterns(Arrays.asList(autoSubDomainCreationPatterns));
            return this;
        }

        public final String getAutoSubDomainIAMRole() {
            return autoSubDomainIAMRole;
        }

        public final void setAutoSubDomainIAMRole(String autoSubDomainIAMRole) {
            this.autoSubDomainIAMRole = autoSubDomainIAMRole;
        }

        @Override
        @Transient
        public final Builder autoSubDomainIAMRole(String autoSubDomainIAMRole) {
            this.autoSubDomainIAMRole = autoSubDomainIAMRole;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDomainAssociationRequest build() {
            return new CreateDomainAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
