/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request structure used to create apps in Amplify.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAppRequest extends AmplifyRequest implements
        ToCopyableBuilder<CreateAppRequest.Builder, CreateAppRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateAppRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateAppRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> REPOSITORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repository").getter(getter(CreateAppRequest::repository)).setter(setter(Builder::repository))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repository").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("platform").getter(getter(CreateAppRequest::platformAsString)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()).build();

    private static final SdkField<String> IAM_SERVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamServiceRoleArn").getter(getter(CreateAppRequest::iamServiceRoleArn))
            .setter(setter(Builder::iamServiceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamServiceRoleArn").build()).build();

    private static final SdkField<String> OAUTH_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("oauthToken").getter(getter(CreateAppRequest::oauthToken)).setter(setter(Builder::oauthToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oauthToken").build()).build();

    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessToken").getter(getter(CreateAppRequest::accessToken)).setter(setter(Builder::accessToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("environmentVariables")
            .getter(getter(CreateAppRequest::environmentVariables))
            .setter(setter(Builder::environmentVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_BRANCH_AUTO_BUILD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableBranchAutoBuild").getter(getter(CreateAppRequest::enableBranchAutoBuild))
            .setter(setter(Builder::enableBranchAutoBuild))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBranchAutoBuild").build())
            .build();

    private static final SdkField<Boolean> ENABLE_BRANCH_AUTO_DELETION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("enableBranchAutoDeletion")
            .getter(getter(CreateAppRequest::enableBranchAutoDeletion)).setter(setter(Builder::enableBranchAutoDeletion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBranchAutoDeletion").build())
            .build();

    private static final SdkField<Boolean> ENABLE_BASIC_AUTH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableBasicAuth").getter(getter(CreateAppRequest::enableBasicAuth))
            .setter(setter(Builder::enableBasicAuth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableBasicAuth").build()).build();

    private static final SdkField<String> BASIC_AUTH_CREDENTIALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("basicAuthCredentials").getter(getter(CreateAppRequest::basicAuthCredentials))
            .setter(setter(Builder::basicAuthCredentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basicAuthCredentials").build())
            .build();

    private static final SdkField<List<CustomRule>> CUSTOM_RULES_FIELD = SdkField
            .<List<CustomRule>> builder(MarshallingType.LIST)
            .memberName("customRules")
            .getter(getter(CreateAppRequest::customRules))
            .setter(setter(Builder::customRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateAppRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> BUILD_SPEC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("buildSpec").getter(getter(CreateAppRequest::buildSpec)).setter(setter(Builder::buildSpec))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildSpec").build()).build();

    private static final SdkField<String> CUSTOM_HEADERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customHeaders").getter(getter(CreateAppRequest::customHeaders)).setter(setter(Builder::customHeaders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customHeaders").build()).build();

    private static final SdkField<Boolean> ENABLE_AUTO_BRANCH_CREATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("enableAutoBranchCreation")
            .getter(getter(CreateAppRequest::enableAutoBranchCreation)).setter(setter(Builder::enableAutoBranchCreation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableAutoBranchCreation").build())
            .build();

    private static final SdkField<List<String>> AUTO_BRANCH_CREATION_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("autoBranchCreationPatterns")
            .getter(getter(CreateAppRequest::autoBranchCreationPatterns))
            .setter(setter(Builder::autoBranchCreationPatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoBranchCreationPatterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AutoBranchCreationConfig> AUTO_BRANCH_CREATION_CONFIG_FIELD = SdkField
            .<AutoBranchCreationConfig> builder(MarshallingType.SDK_POJO).memberName("autoBranchCreationConfig")
            .getter(getter(CreateAppRequest::autoBranchCreationConfig)).setter(setter(Builder::autoBranchCreationConfig))
            .constructor(AutoBranchCreationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoBranchCreationConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            REPOSITORY_FIELD, PLATFORM_FIELD, IAM_SERVICE_ROLE_ARN_FIELD, OAUTH_TOKEN_FIELD, ACCESS_TOKEN_FIELD,
            ENVIRONMENT_VARIABLES_FIELD, ENABLE_BRANCH_AUTO_BUILD_FIELD, ENABLE_BRANCH_AUTO_DELETION_FIELD,
            ENABLE_BASIC_AUTH_FIELD, BASIC_AUTH_CREDENTIALS_FIELD, CUSTOM_RULES_FIELD, TAGS_FIELD, BUILD_SPEC_FIELD,
            CUSTOM_HEADERS_FIELD, ENABLE_AUTO_BRANCH_CREATION_FIELD, AUTO_BRANCH_CREATION_PATTERNS_FIELD,
            AUTO_BRANCH_CREATION_CONFIG_FIELD));

    private final String name;

    private final String description;

    private final String repository;

    private final String platform;

    private final String iamServiceRoleArn;

    private final String oauthToken;

    private final String accessToken;

    private final Map<String, String> environmentVariables;

    private final Boolean enableBranchAutoBuild;

    private final Boolean enableBranchAutoDeletion;

    private final Boolean enableBasicAuth;

    private final String basicAuthCredentials;

    private final List<CustomRule> customRules;

    private final Map<String, String> tags;

    private final String buildSpec;

    private final String customHeaders;

    private final Boolean enableAutoBranchCreation;

    private final List<String> autoBranchCreationPatterns;

    private final AutoBranchCreationConfig autoBranchCreationConfig;

    private CreateAppRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.repository = builder.repository;
        this.platform = builder.platform;
        this.iamServiceRoleArn = builder.iamServiceRoleArn;
        this.oauthToken = builder.oauthToken;
        this.accessToken = builder.accessToken;
        this.environmentVariables = builder.environmentVariables;
        this.enableBranchAutoBuild = builder.enableBranchAutoBuild;
        this.enableBranchAutoDeletion = builder.enableBranchAutoDeletion;
        this.enableBasicAuth = builder.enableBasicAuth;
        this.basicAuthCredentials = builder.basicAuthCredentials;
        this.customRules = builder.customRules;
        this.tags = builder.tags;
        this.buildSpec = builder.buildSpec;
        this.customHeaders = builder.customHeaders;
        this.enableAutoBranchCreation = builder.enableAutoBranchCreation;
        this.autoBranchCreationPatterns = builder.autoBranchCreationPatterns;
        this.autoBranchCreationConfig = builder.autoBranchCreationConfig;
    }

    /**
     * <p>
     * The name for an Amplify app.
     * </p>
     * 
     * @return The name for an Amplify app.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description for an Amplify app.
     * </p>
     * 
     * @return The description for an Amplify app.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The repository for an Amplify app.
     * </p>
     * 
     * @return The repository for an Amplify app.
     */
    public final String repository() {
        return repository;
    }

    /**
     * <p>
     * The platform or framework for an Amplify app.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform or framework for an Amplify app.
     * @see Platform
     */
    public final Platform platform() {
        return Platform.fromValue(platform);
    }

    /**
     * <p>
     * The platform or framework for an Amplify app.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link Platform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform or framework for an Amplify app.
     * @see Platform
     */
    public final String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * The AWS Identity and Access Management (IAM) service role for an Amplify app.
     * </p>
     * 
     * @return The AWS Identity and Access Management (IAM) service role for an Amplify app.
     */
    public final String iamServiceRoleArn() {
        return iamServiceRoleArn;
    }

    /**
     * <p>
     * The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a
     * webhook and a read-only deploy key. The OAuth token is not stored.
     * </p>
     * 
     * @return The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to
     *         create a webhook and a read-only deploy key. The OAuth token is not stored.
     */
    public final String oauthToken() {
        return oauthToken;
    }

    /**
     * <p>
     * The personal access token for a third-party source control system for an Amplify app. The personal access token
     * is used to create a webhook and a read-only deploy key. The token is not stored.
     * </p>
     * 
     * @return The personal access token for a third-party source control system for an Amplify app. The personal access
     *         token is used to create a webhook and a read-only deploy key. The token is not stored.
     */
    public final String accessToken() {
        return accessToken;
    }

    /**
     * Returns true if the EnvironmentVariables property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasEnvironmentVariables() {
        return environmentVariables != null && !(environmentVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The environment variables map for an Amplify app.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEnvironmentVariables()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The environment variables map for an Amplify app.
     */
    public final Map<String, String> environmentVariables() {
        return environmentVariables;
    }

    /**
     * <p>
     * Enables the auto building of branches for an Amplify app.
     * </p>
     * 
     * @return Enables the auto building of branches for an Amplify app.
     */
    public final Boolean enableBranchAutoBuild() {
        return enableBranchAutoBuild;
    }

    /**
     * <p>
     * Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository.
     * </p>
     * 
     * @return Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git
     *         repository.
     */
    public final Boolean enableBranchAutoDeletion() {
        return enableBranchAutoDeletion;
    }

    /**
     * <p>
     * Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
     * </p>
     * 
     * @return Enables basic authorization for an Amplify app. This will apply to all branches that are part of this
     *         app.
     */
    public final Boolean enableBasicAuth() {
        return enableBasicAuth;
    }

    /**
     * <p>
     * The credentials for basic authorization for an Amplify app.
     * </p>
     * 
     * @return The credentials for basic authorization for an Amplify app.
     */
    public final String basicAuthCredentials() {
        return basicAuthCredentials;
    }

    /**
     * Returns true if the CustomRules property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCustomRules() {
        return customRules != null && !(customRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The custom rewrite and redirect rules for an Amplify app.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCustomRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The custom rewrite and redirect rules for an Amplify app.
     */
    public final List<CustomRule> customRules() {
        return customRules;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tag for an Amplify app.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tag for an Amplify app.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The build specification (build spec) for an Amplify app.
     * </p>
     * 
     * @return The build specification (build spec) for an Amplify app.
     */
    public final String buildSpec() {
        return buildSpec;
    }

    /**
     * <p>
     * The custom HTTP headers for an Amplify app.
     * </p>
     * 
     * @return The custom HTTP headers for an Amplify app.
     */
    public final String customHeaders() {
        return customHeaders;
    }

    /**
     * <p>
     * Enables automated branch creation for an Amplify app.
     * </p>
     * 
     * @return Enables automated branch creation for an Amplify app.
     */
    public final Boolean enableAutoBranchCreation() {
        return enableAutoBranchCreation;
    }

    /**
     * Returns true if the AutoBranchCreationPatterns property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasAutoBranchCreationPatterns() {
        return autoBranchCreationPatterns != null && !(autoBranchCreationPatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The automated branch creation glob patterns for an Amplify app.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAutoBranchCreationPatterns()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The automated branch creation glob patterns for an Amplify app.
     */
    public final List<String> autoBranchCreationPatterns() {
        return autoBranchCreationPatterns;
    }

    /**
     * <p>
     * The automated branch creation configuration for an Amplify app.
     * </p>
     * 
     * @return The automated branch creation configuration for an Amplify app.
     */
    public final AutoBranchCreationConfig autoBranchCreationConfig() {
        return autoBranchCreationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(repository());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(iamServiceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(oauthToken());
        hashCode = 31 * hashCode + Objects.hashCode(accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentVariables() ? environmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enableBranchAutoBuild());
        hashCode = 31 * hashCode + Objects.hashCode(enableBranchAutoDeletion());
        hashCode = 31 * hashCode + Objects.hashCode(enableBasicAuth());
        hashCode = 31 * hashCode + Objects.hashCode(basicAuthCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomRules() ? customRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(buildSpec());
        hashCode = 31 * hashCode + Objects.hashCode(customHeaders());
        hashCode = 31 * hashCode + Objects.hashCode(enableAutoBranchCreation());
        hashCode = 31 * hashCode + Objects.hashCode(hasAutoBranchCreationPatterns() ? autoBranchCreationPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(autoBranchCreationConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppRequest)) {
            return false;
        }
        CreateAppRequest other = (CreateAppRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(repository(), other.repository())
                && Objects.equals(platformAsString(), other.platformAsString())
                && Objects.equals(iamServiceRoleArn(), other.iamServiceRoleArn())
                && Objects.equals(oauthToken(), other.oauthToken()) && Objects.equals(accessToken(), other.accessToken())
                && hasEnvironmentVariables() == other.hasEnvironmentVariables()
                && Objects.equals(environmentVariables(), other.environmentVariables())
                && Objects.equals(enableBranchAutoBuild(), other.enableBranchAutoBuild())
                && Objects.equals(enableBranchAutoDeletion(), other.enableBranchAutoDeletion())
                && Objects.equals(enableBasicAuth(), other.enableBasicAuth())
                && Objects.equals(basicAuthCredentials(), other.basicAuthCredentials())
                && hasCustomRules() == other.hasCustomRules() && Objects.equals(customRules(), other.customRules())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(buildSpec(), other.buildSpec()) && Objects.equals(customHeaders(), other.customHeaders())
                && Objects.equals(enableAutoBranchCreation(), other.enableAutoBranchCreation())
                && hasAutoBranchCreationPatterns() == other.hasAutoBranchCreationPatterns()
                && Objects.equals(autoBranchCreationPatterns(), other.autoBranchCreationPatterns())
                && Objects.equals(autoBranchCreationConfig(), other.autoBranchCreationConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAppRequest").add("Name", name()).add("Description", description())
                .add("Repository", repository()).add("Platform", platformAsString())
                .add("IamServiceRoleArn", iamServiceRoleArn())
                .add("OauthToken", oauthToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AccessToken", accessToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EnvironmentVariables", hasEnvironmentVariables() ? environmentVariables() : null)
                .add("EnableBranchAutoBuild", enableBranchAutoBuild())
                .add("EnableBranchAutoDeletion", enableBranchAutoDeletion()).add("EnableBasicAuth", enableBasicAuth())
                .add("BasicAuthCredentials", basicAuthCredentials() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CustomRules", hasCustomRules() ? customRules() : null).add("Tags", hasTags() ? tags() : null)
                .add("BuildSpec", buildSpec()).add("CustomHeaders", customHeaders())
                .add("EnableAutoBranchCreation", enableAutoBranchCreation())
                .add("AutoBranchCreationPatterns", hasAutoBranchCreationPatterns() ? autoBranchCreationPatterns() : null)
                .add("AutoBranchCreationConfig", autoBranchCreationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "repository":
            return Optional.ofNullable(clazz.cast(repository()));
        case "platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "iamServiceRoleArn":
            return Optional.ofNullable(clazz.cast(iamServiceRoleArn()));
        case "oauthToken":
            return Optional.ofNullable(clazz.cast(oauthToken()));
        case "accessToken":
            return Optional.ofNullable(clazz.cast(accessToken()));
        case "environmentVariables":
            return Optional.ofNullable(clazz.cast(environmentVariables()));
        case "enableBranchAutoBuild":
            return Optional.ofNullable(clazz.cast(enableBranchAutoBuild()));
        case "enableBranchAutoDeletion":
            return Optional.ofNullable(clazz.cast(enableBranchAutoDeletion()));
        case "enableBasicAuth":
            return Optional.ofNullable(clazz.cast(enableBasicAuth()));
        case "basicAuthCredentials":
            return Optional.ofNullable(clazz.cast(basicAuthCredentials()));
        case "customRules":
            return Optional.ofNullable(clazz.cast(customRules()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "buildSpec":
            return Optional.ofNullable(clazz.cast(buildSpec()));
        case "customHeaders":
            return Optional.ofNullable(clazz.cast(customHeaders()));
        case "enableAutoBranchCreation":
            return Optional.ofNullable(clazz.cast(enableAutoBranchCreation()));
        case "autoBranchCreationPatterns":
            return Optional.ofNullable(clazz.cast(autoBranchCreationPatterns()));
        case "autoBranchCreationConfig":
            return Optional.ofNullable(clazz.cast(autoBranchCreationConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAppRequest, T> g) {
        return obj -> g.apply((CreateAppRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAppRequest> {
        /**
         * <p>
         * The name for an Amplify app.
         * </p>
         * 
         * @param name
         *        The name for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description for an Amplify app.
         * </p>
         * 
         * @param description
         *        The description for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The repository for an Amplify app.
         * </p>
         * 
         * @param repository
         *        The repository for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repository(String repository);

        /**
         * <p>
         * The platform or framework for an Amplify app.
         * </p>
         * 
         * @param platform
         *        The platform or framework for an Amplify app.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(String platform);

        /**
         * <p>
         * The platform or framework for an Amplify app.
         * </p>
         * 
         * @param platform
         *        The platform or framework for an Amplify app.
         * @see Platform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Platform
         */
        Builder platform(Platform platform);

        /**
         * <p>
         * The AWS Identity and Access Management (IAM) service role for an Amplify app.
         * </p>
         * 
         * @param iamServiceRoleArn
         *        The AWS Identity and Access Management (IAM) service role for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamServiceRoleArn(String iamServiceRoleArn);

        /**
         * <p>
         * The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create
         * a webhook and a read-only deploy key. The OAuth token is not stored.
         * </p>
         * 
         * @param oauthToken
         *        The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to
         *        create a webhook and a read-only deploy key. The OAuth token is not stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oauthToken(String oauthToken);

        /**
         * <p>
         * The personal access token for a third-party source control system for an Amplify app. The personal access
         * token is used to create a webhook and a read-only deploy key. The token is not stored.
         * </p>
         * 
         * @param accessToken
         *        The personal access token for a third-party source control system for an Amplify app. The personal
         *        access token is used to create a webhook and a read-only deploy key. The token is not stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessToken(String accessToken);

        /**
         * <p>
         * The environment variables map for an Amplify app.
         * </p>
         * 
         * @param environmentVariables
         *        The environment variables map for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentVariables(Map<String, String> environmentVariables);

        /**
         * <p>
         * Enables the auto building of branches for an Amplify app.
         * </p>
         * 
         * @param enableBranchAutoBuild
         *        Enables the auto building of branches for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableBranchAutoBuild(Boolean enableBranchAutoBuild);

        /**
         * <p>
         * Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository.
         * </p>
         * 
         * @param enableBranchAutoDeletion
         *        Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git
         *        repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableBranchAutoDeletion(Boolean enableBranchAutoDeletion);

        /**
         * <p>
         * Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
         * </p>
         * 
         * @param enableBasicAuth
         *        Enables basic authorization for an Amplify app. This will apply to all branches that are part of this
         *        app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableBasicAuth(Boolean enableBasicAuth);

        /**
         * <p>
         * The credentials for basic authorization for an Amplify app.
         * </p>
         * 
         * @param basicAuthCredentials
         *        The credentials for basic authorization for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basicAuthCredentials(String basicAuthCredentials);

        /**
         * <p>
         * The custom rewrite and redirect rules for an Amplify app.
         * </p>
         * 
         * @param customRules
         *        The custom rewrite and redirect rules for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customRules(Collection<CustomRule> customRules);

        /**
         * <p>
         * The custom rewrite and redirect rules for an Amplify app.
         * </p>
         * 
         * @param customRules
         *        The custom rewrite and redirect rules for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customRules(CustomRule... customRules);

        /**
         * <p>
         * The custom rewrite and redirect rules for an Amplify app.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CustomRule>.Builder} avoiding the need to
         * create one manually via {@link List<CustomRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CustomRule>.Builder#build()} is called immediately and its
         * result is passed to {@link #customRules(List<CustomRule>)}.
         * 
         * @param customRules
         *        a consumer that will call methods on {@link List<CustomRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customRules(List<CustomRule>)
         */
        Builder customRules(Consumer<CustomRule.Builder>... customRules);

        /**
         * <p>
         * The tag for an Amplify app.
         * </p>
         * 
         * @param tags
         *        The tag for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The build specification (build spec) for an Amplify app.
         * </p>
         * 
         * @param buildSpec
         *        The build specification (build spec) for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildSpec(String buildSpec);

        /**
         * <p>
         * The custom HTTP headers for an Amplify app.
         * </p>
         * 
         * @param customHeaders
         *        The custom HTTP headers for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customHeaders(String customHeaders);

        /**
         * <p>
         * Enables automated branch creation for an Amplify app.
         * </p>
         * 
         * @param enableAutoBranchCreation
         *        Enables automated branch creation for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableAutoBranchCreation(Boolean enableAutoBranchCreation);

        /**
         * <p>
         * The automated branch creation glob patterns for an Amplify app.
         * </p>
         * 
         * @param autoBranchCreationPatterns
         *        The automated branch creation glob patterns for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoBranchCreationPatterns(Collection<String> autoBranchCreationPatterns);

        /**
         * <p>
         * The automated branch creation glob patterns for an Amplify app.
         * </p>
         * 
         * @param autoBranchCreationPatterns
         *        The automated branch creation glob patterns for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoBranchCreationPatterns(String... autoBranchCreationPatterns);

        /**
         * <p>
         * The automated branch creation configuration for an Amplify app.
         * </p>
         * 
         * @param autoBranchCreationConfig
         *        The automated branch creation configuration for an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoBranchCreationConfig(AutoBranchCreationConfig autoBranchCreationConfig);

        /**
         * <p>
         * The automated branch creation configuration for an Amplify app.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoBranchCreationConfig.Builder} avoiding the
         * need to create one manually via {@link AutoBranchCreationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoBranchCreationConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #autoBranchCreationConfig(AutoBranchCreationConfig)}.
         * 
         * @param autoBranchCreationConfig
         *        a consumer that will call methods on {@link AutoBranchCreationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoBranchCreationConfig(AutoBranchCreationConfig)
         */
        default Builder autoBranchCreationConfig(Consumer<AutoBranchCreationConfig.Builder> autoBranchCreationConfig) {
            return autoBranchCreationConfig(AutoBranchCreationConfig.builder().applyMutation(autoBranchCreationConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmplifyRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String repository;

        private String platform;

        private String iamServiceRoleArn;

        private String oauthToken;

        private String accessToken;

        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();

        private Boolean enableBranchAutoBuild;

        private Boolean enableBranchAutoDeletion;

        private Boolean enableBasicAuth;

        private String basicAuthCredentials;

        private List<CustomRule> customRules = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String buildSpec;

        private String customHeaders;

        private Boolean enableAutoBranchCreation;

        private List<String> autoBranchCreationPatterns = DefaultSdkAutoConstructList.getInstance();

        private AutoBranchCreationConfig autoBranchCreationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            repository(model.repository);
            platform(model.platform);
            iamServiceRoleArn(model.iamServiceRoleArn);
            oauthToken(model.oauthToken);
            accessToken(model.accessToken);
            environmentVariables(model.environmentVariables);
            enableBranchAutoBuild(model.enableBranchAutoBuild);
            enableBranchAutoDeletion(model.enableBranchAutoDeletion);
            enableBasicAuth(model.enableBasicAuth);
            basicAuthCredentials(model.basicAuthCredentials);
            customRules(model.customRules);
            tags(model.tags);
            buildSpec(model.buildSpec);
            customHeaders(model.customHeaders);
            enableAutoBranchCreation(model.enableAutoBranchCreation);
            autoBranchCreationPatterns(model.autoBranchCreationPatterns);
            autoBranchCreationConfig(model.autoBranchCreationConfig);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRepository() {
            return repository;
        }

        public final void setRepository(String repository) {
            this.repository = repository;
        }

        @Override
        @Transient
        public final Builder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        @Transient
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        @Transient
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final String getIamServiceRoleArn() {
            return iamServiceRoleArn;
        }

        public final void setIamServiceRoleArn(String iamServiceRoleArn) {
            this.iamServiceRoleArn = iamServiceRoleArn;
        }

        @Override
        @Transient
        public final Builder iamServiceRoleArn(String iamServiceRoleArn) {
            this.iamServiceRoleArn = iamServiceRoleArn;
            return this;
        }

        public final String getOauthToken() {
            return oauthToken;
        }

        public final void setOauthToken(String oauthToken) {
            this.oauthToken = oauthToken;
        }

        @Override
        @Transient
        public final Builder oauthToken(String oauthToken) {
            this.oauthToken = oauthToken;
            return this;
        }

        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        @Transient
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final Map<String, String> getEnvironmentVariables() {
            if (environmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return environmentVariables;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
        }

        @Override
        @Transient
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesCopier.copy(environmentVariables);
            return this;
        }

        public final Boolean getEnableBranchAutoBuild() {
            return enableBranchAutoBuild;
        }

        public final void setEnableBranchAutoBuild(Boolean enableBranchAutoBuild) {
            this.enableBranchAutoBuild = enableBranchAutoBuild;
        }

        @Override
        @Transient
        public final Builder enableBranchAutoBuild(Boolean enableBranchAutoBuild) {
            this.enableBranchAutoBuild = enableBranchAutoBuild;
            return this;
        }

        public final Boolean getEnableBranchAutoDeletion() {
            return enableBranchAutoDeletion;
        }

        public final void setEnableBranchAutoDeletion(Boolean enableBranchAutoDeletion) {
            this.enableBranchAutoDeletion = enableBranchAutoDeletion;
        }

        @Override
        @Transient
        public final Builder enableBranchAutoDeletion(Boolean enableBranchAutoDeletion) {
            this.enableBranchAutoDeletion = enableBranchAutoDeletion;
            return this;
        }

        public final Boolean getEnableBasicAuth() {
            return enableBasicAuth;
        }

        public final void setEnableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
        }

        @Override
        @Transient
        public final Builder enableBasicAuth(Boolean enableBasicAuth) {
            this.enableBasicAuth = enableBasicAuth;
            return this;
        }

        public final String getBasicAuthCredentials() {
            return basicAuthCredentials;
        }

        public final void setBasicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
        }

        @Override
        @Transient
        public final Builder basicAuthCredentials(String basicAuthCredentials) {
            this.basicAuthCredentials = basicAuthCredentials;
            return this;
        }

        public final List<CustomRule.Builder> getCustomRules() {
            List<CustomRule.Builder> result = CustomRulesCopier.copyToBuilder(this.customRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomRules(Collection<CustomRule.BuilderImpl> customRules) {
            this.customRules = CustomRulesCopier.copyFromBuilder(customRules);
        }

        @Override
        @Transient
        public final Builder customRules(Collection<CustomRule> customRules) {
            this.customRules = CustomRulesCopier.copy(customRules);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder customRules(CustomRule... customRules) {
            customRules(Arrays.asList(customRules));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder customRules(Consumer<CustomRule.Builder>... customRules) {
            customRules(Stream.of(customRules).map(c -> CustomRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getBuildSpec() {
            return buildSpec;
        }

        public final void setBuildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
        }

        @Override
        @Transient
        public final Builder buildSpec(String buildSpec) {
            this.buildSpec = buildSpec;
            return this;
        }

        public final String getCustomHeaders() {
            return customHeaders;
        }

        public final void setCustomHeaders(String customHeaders) {
            this.customHeaders = customHeaders;
        }

        @Override
        @Transient
        public final Builder customHeaders(String customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public final Boolean getEnableAutoBranchCreation() {
            return enableAutoBranchCreation;
        }

        public final void setEnableAutoBranchCreation(Boolean enableAutoBranchCreation) {
            this.enableAutoBranchCreation = enableAutoBranchCreation;
        }

        @Override
        @Transient
        public final Builder enableAutoBranchCreation(Boolean enableAutoBranchCreation) {
            this.enableAutoBranchCreation = enableAutoBranchCreation;
            return this;
        }

        public final Collection<String> getAutoBranchCreationPatterns() {
            if (autoBranchCreationPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return autoBranchCreationPatterns;
        }

        public final void setAutoBranchCreationPatterns(Collection<String> autoBranchCreationPatterns) {
            this.autoBranchCreationPatterns = AutoBranchCreationPatternsCopier.copy(autoBranchCreationPatterns);
        }

        @Override
        @Transient
        public final Builder autoBranchCreationPatterns(Collection<String> autoBranchCreationPatterns) {
            this.autoBranchCreationPatterns = AutoBranchCreationPatternsCopier.copy(autoBranchCreationPatterns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder autoBranchCreationPatterns(String... autoBranchCreationPatterns) {
            autoBranchCreationPatterns(Arrays.asList(autoBranchCreationPatterns));
            return this;
        }

        public final AutoBranchCreationConfig.Builder getAutoBranchCreationConfig() {
            return autoBranchCreationConfig != null ? autoBranchCreationConfig.toBuilder() : null;
        }

        public final void setAutoBranchCreationConfig(AutoBranchCreationConfig.BuilderImpl autoBranchCreationConfig) {
            this.autoBranchCreationConfig = autoBranchCreationConfig != null ? autoBranchCreationConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder autoBranchCreationConfig(AutoBranchCreationConfig autoBranchCreationConfig) {
            this.autoBranchCreationConfig = autoBranchCreationConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAppRequest build() {
            return new CreateAppRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
