/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the summary for an execution job for an Amplify app.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobSummary implements SdkPojo, Serializable, ToCopyableBuilder<JobSummary.Builder, JobSummary> {
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobArn")
            .getter(getter(JobSummary::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(JobSummary::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commitId").getter(getter(JobSummary::commitId)).setter(setter(Builder::commitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitId").build()).build();

    private static final SdkField<String> COMMIT_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commitMessage").getter(getter(JobSummary::commitMessage)).setter(setter(Builder::commitMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitMessage").build()).build();

    private static final SdkField<Instant> COMMIT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("commitTime").getter(getter(JobSummary::commitTime)).setter(setter(Builder::commitTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitTime").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(JobSummary::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(JobSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(JobSummary::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobType").getter(getter(JobSummary::jobTypeAsString)).setter(setter(Builder::jobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ARN_FIELD, JOB_ID_FIELD,
            COMMIT_ID_FIELD, COMMIT_MESSAGE_FIELD, COMMIT_TIME_FIELD, START_TIME_FIELD, STATUS_FIELD, END_TIME_FIELD,
            JOB_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobArn;

    private final String jobId;

    private final String commitId;

    private final String commitMessage;

    private final Instant commitTime;

    private final Instant startTime;

    private final String status;

    private final Instant endTime;

    private final String jobType;

    private JobSummary(BuilderImpl builder) {
        this.jobArn = builder.jobArn;
        this.jobId = builder.jobId;
        this.commitId = builder.commitId;
        this.commitMessage = builder.commitMessage;
        this.commitTime = builder.commitTime;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.endTime = builder.endTime;
        this.jobType = builder.jobType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the job.
     */
    public String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * The unique ID for the job.
     * </p>
     * 
     * @return The unique ID for the job.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The commit ID from a third-party repository provider for the job.
     * </p>
     * 
     * @return The commit ID from a third-party repository provider for the job.
     */
    public String commitId() {
        return commitId;
    }

    /**
     * <p>
     * The commit message from a third-party repository provider for the job.
     * </p>
     * 
     * @return The commit message from a third-party repository provider for the job.
     */
    public String commitMessage() {
        return commitMessage;
    }

    /**
     * <p>
     * The commit date and time for the job.
     * </p>
     * 
     * @return The commit date and time for the job.
     */
    public Instant commitTime() {
        return commitTime;
    }

    /**
     * <p>
     * The start date and time for the job.
     * </p>
     * 
     * @return The start date and time for the job.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The current status for the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status for the job.
     * @see JobStatus
     */
    public JobStatus status() {
        return JobStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status for the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status for the job.
     * @see JobStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The end date and time for the job.
     * </p>
     * 
     * @return The end date and time for the job.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The type for the job. If the value is <code>RELEASE</code>, the job was manually released from its source by
     * using the <code>StartJob</code> API. If the value is <code>RETRY</code>, the job was manually retried using the
     * <code>StartJob</code> API. If the value is <code>WEB_HOOK</code>, the job was automatically triggered by
     * webhooks.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The type for the job. If the value is <code>RELEASE</code>, the job was manually released from its source
     *         by using the <code>StartJob</code> API. If the value is <code>RETRY</code>, the job was manually retried
     *         using the <code>StartJob</code> API. If the value is <code>WEB_HOOK</code>, the job was automatically
     *         triggered by webhooks.
     * @see JobType
     */
    public JobType jobType() {
        return JobType.fromValue(jobType);
    }

    /**
     * <p>
     * The type for the job. If the value is <code>RELEASE</code>, the job was manually released from its source by
     * using the <code>StartJob</code> API. If the value is <code>RETRY</code>, the job was manually retried using the
     * <code>StartJob</code> API. If the value is <code>WEB_HOOK</code>, the job was automatically triggered by
     * webhooks.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The type for the job. If the value is <code>RELEASE</code>, the job was manually released from its source
     *         by using the <code>StartJob</code> API. If the value is <code>RETRY</code>, the job was manually retried
     *         using the <code>StartJob</code> API. If the value is <code>WEB_HOOK</code>, the job was automatically
     *         triggered by webhooks.
     * @see JobType
     */
    public String jobTypeAsString() {
        return jobType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(commitId());
        hashCode = 31 * hashCode + Objects.hashCode(commitMessage());
        hashCode = 31 * hashCode + Objects.hashCode(commitTime());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(jobTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobSummary)) {
            return false;
        }
        JobSummary other = (JobSummary) obj;
        return Objects.equals(jobArn(), other.jobArn()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(commitId(), other.commitId()) && Objects.equals(commitMessage(), other.commitMessage())
                && Objects.equals(commitTime(), other.commitTime()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(jobTypeAsString(), other.jobTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("JobSummary").add("JobArn", jobArn()).add("JobId", jobId()).add("CommitId", commitId())
                .add("CommitMessage", commitMessage()).add("CommitTime", commitTime()).add("StartTime", startTime())
                .add("Status", statusAsString()).add("EndTime", endTime()).add("JobType", jobTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "commitId":
            return Optional.ofNullable(clazz.cast(commitId()));
        case "commitMessage":
            return Optional.ofNullable(clazz.cast(commitMessage()));
        case "commitTime":
            return Optional.ofNullable(clazz.cast(commitTime()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "jobType":
            return Optional.ofNullable(clazz.cast(jobTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobSummary, T> g) {
        return obj -> g.apply((JobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the job.
         * </p>
         * 
         * @param jobArn
         *        The Amazon Resource Name (ARN) for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * The unique ID for the job.
         * </p>
         * 
         * @param jobId
         *        The unique ID for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The commit ID from a third-party repository provider for the job.
         * </p>
         * 
         * @param commitId
         *        The commit ID from a third-party repository provider for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitId(String commitId);

        /**
         * <p>
         * The commit message from a third-party repository provider for the job.
         * </p>
         * 
         * @param commitMessage
         *        The commit message from a third-party repository provider for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitMessage(String commitMessage);

        /**
         * <p>
         * The commit date and time for the job.
         * </p>
         * 
         * @param commitTime
         *        The commit date and time for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitTime(Instant commitTime);

        /**
         * <p>
         * The start date and time for the job.
         * </p>
         * 
         * @param startTime
         *        The start date and time for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The current status for the job.
         * </p>
         * 
         * @param status
         *        The current status for the job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status for the job.
         * </p>
         * 
         * @param status
         *        The current status for the job.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder status(JobStatus status);

        /**
         * <p>
         * The end date and time for the job.
         * </p>
         * 
         * @param endTime
         *        The end date and time for the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The type for the job. If the value is <code>RELEASE</code>, the job was manually released from its source by
         * using the <code>StartJob</code> API. If the value is <code>RETRY</code>, the job was manually retried using
         * the <code>StartJob</code> API. If the value is <code>WEB_HOOK</code>, the job was automatically triggered by
         * webhooks.
         * </p>
         * 
         * @param jobType
         *        The type for the job. If the value is <code>RELEASE</code>, the job was manually released from its
         *        source by using the <code>StartJob</code> API. If the value is <code>RETRY</code>, the job was
         *        manually retried using the <code>StartJob</code> API. If the value is <code>WEB_HOOK</code>, the job
         *        was automatically triggered by webhooks.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * The type for the job. If the value is <code>RELEASE</code>, the job was manually released from its source by
         * using the <code>StartJob</code> API. If the value is <code>RETRY</code>, the job was manually retried using
         * the <code>StartJob</code> API. If the value is <code>WEB_HOOK</code>, the job was automatically triggered by
         * webhooks.
         * </p>
         * 
         * @param jobType
         *        The type for the job. If the value is <code>RELEASE</code>, the job was manually released from its
         *        source by using the <code>StartJob</code> API. If the value is <code>RETRY</code>, the job was
         *        manually retried using the <code>StartJob</code> API. If the value is <code>WEB_HOOK</code>, the job
         *        was automatically triggered by webhooks.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(JobType jobType);
    }

    static final class BuilderImpl implements Builder {
        private String jobArn;

        private String jobId;

        private String commitId;

        private String commitMessage;

        private Instant commitTime;

        private Instant startTime;

        private String status;

        private Instant endTime;

        private String jobType;

        private BuilderImpl() {
        }

        private BuilderImpl(JobSummary model) {
            jobArn(model.jobArn);
            jobId(model.jobId);
            commitId(model.commitId);
            commitMessage(model.commitMessage);
            commitTime(model.commitTime);
            startTime(model.startTime);
            status(model.status);
            endTime(model.endTime);
            jobType(model.jobType);
        }

        public final String getJobArn() {
            return jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getCommitId() {
            return commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        public final String getCommitMessage() {
            return commitMessage;
        }

        @Override
        public final Builder commitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
            return this;
        }

        public final void setCommitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
        }

        public final Instant getCommitTime() {
            return commitTime;
        }

        @Override
        public final Builder commitTime(Instant commitTime) {
            this.commitTime = commitTime;
            return this;
        }

        public final void setCommitTime(Instant commitTime) {
            this.commitTime = commitTime;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getJobType() {
            return jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public JobSummary build() {
            return new JobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
