/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an artifact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Artifact implements SdkPojo, Serializable, ToCopyableBuilder<Artifact.Builder, Artifact> {
    private static final SdkField<String> ARTIFACT_FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("artifactFileName").getter(getter(Artifact::artifactFileName)).setter(setter(Builder::artifactFileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactFileName").build()).build();

    private static final SdkField<String> ARTIFACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("artifactId").getter(getter(Artifact::artifactId)).setter(setter(Builder::artifactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARTIFACT_FILE_NAME_FIELD,
            ARTIFACT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String artifactFileName;

    private final String artifactId;

    private Artifact(BuilderImpl builder) {
        this.artifactFileName = builder.artifactFileName;
        this.artifactId = builder.artifactId;
    }

    /**
     * <p>
     * The file name for the artifact.
     * </p>
     * 
     * @return The file name for the artifact.
     */
    public String artifactFileName() {
        return artifactFileName;
    }

    /**
     * <p>
     * The unique ID for the artifact.
     * </p>
     * 
     * @return The unique ID for the artifact.
     */
    public String artifactId() {
        return artifactId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(artifactFileName());
        hashCode = 31 * hashCode + Objects.hashCode(artifactId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Artifact)) {
            return false;
        }
        Artifact other = (Artifact) obj;
        return Objects.equals(artifactFileName(), other.artifactFileName()) && Objects.equals(artifactId(), other.artifactId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Artifact").add("ArtifactFileName", artifactFileName()).add("ArtifactId", artifactId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "artifactFileName":
            return Optional.ofNullable(clazz.cast(artifactFileName()));
        case "artifactId":
            return Optional.ofNullable(clazz.cast(artifactId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Artifact, T> g) {
        return obj -> g.apply((Artifact) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Artifact> {
        /**
         * <p>
         * The file name for the artifact.
         * </p>
         * 
         * @param artifactFileName
         *        The file name for the artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactFileName(String artifactFileName);

        /**
         * <p>
         * The unique ID for the artifact.
         * </p>
         * 
         * @param artifactId
         *        The unique ID for the artifact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactId(String artifactId);
    }

    static final class BuilderImpl implements Builder {
        private String artifactFileName;

        private String artifactId;

        private BuilderImpl() {
        }

        private BuilderImpl(Artifact model) {
            artifactFileName(model.artifactFileName);
            artifactId(model.artifactId);
        }

        public final String getArtifactFileName() {
            return artifactFileName;
        }

        @Override
        public final Builder artifactFileName(String artifactFileName) {
            this.artifactFileName = artifactFileName;
            return this;
        }

        public final void setArtifactFileName(String artifactFileName) {
            this.artifactFileName = artifactFileName;
        }

        public final String getArtifactId() {
            return artifactId;
        }

        @Override
        public final Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public final void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        @Override
        public Artifact build() {
            return new Artifact(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
