/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amplify.model.JobStatus;
import software.amazon.awssdk.services.amplify.model.ScreenshotsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Step
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Step> {
    private static final SdkField<String> STEP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepName").getter(Step.getter(Step::stepName)).setter(Step.setter(Builder::stepName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepName").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(Step.getter(Step::startTime)).setter(Step.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Step.getter(Step::statusAsString)).setter(Step.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(Step.getter(Step::endTime)).setter(Step.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> LOG_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logUrl").getter(Step.getter(Step::logUrl)).setter(Step.setter(Builder::logUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logUrl").build()}).build();
    private static final SdkField<String> ARTIFACTS_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("artifactsUrl").getter(Step.getter(Step::artifactsUrl)).setter(Step.setter(Builder::artifactsUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactsUrl").build()}).build();
    private static final SdkField<String> TEST_ARTIFACTS_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testArtifactsUrl").getter(Step.getter(Step::testArtifactsUrl)).setter(Step.setter(Builder::testArtifactsUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testArtifactsUrl").build()}).build();
    private static final SdkField<String> TEST_CONFIG_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testConfigUrl").getter(Step.getter(Step::testConfigUrl)).setter(Step.setter(Builder::testConfigUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testConfigUrl").build()}).build();
    private static final SdkField<Map<String, String>> SCREENSHOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("screenshots").getter(Step.getter(Step::screenshots)).setter(Step.setter(Builder::screenshots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("screenshots").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(Step.getter(Step::statusReason)).setter(Step.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<String> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("context").getter(Step.getter(Step::context)).setter(Step.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_NAME_FIELD, START_TIME_FIELD, STATUS_FIELD, END_TIME_FIELD, LOG_URL_FIELD, ARTIFACTS_URL_FIELD, TEST_ARTIFACTS_URL_FIELD, TEST_CONFIG_URL_FIELD, SCREENSHOTS_FIELD, STATUS_REASON_FIELD, CONTEXT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String stepName;
    private final Instant startTime;
    private final String status;
    private final Instant endTime;
    private final String logUrl;
    private final String artifactsUrl;
    private final String testArtifactsUrl;
    private final String testConfigUrl;
    private final Map<String, String> screenshots;
    private final String statusReason;
    private final String context;

    private Step(BuilderImpl builder) {
        this.stepName = builder.stepName;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.endTime = builder.endTime;
        this.logUrl = builder.logUrl;
        this.artifactsUrl = builder.artifactsUrl;
        this.testArtifactsUrl = builder.testArtifactsUrl;
        this.testConfigUrl = builder.testConfigUrl;
        this.screenshots = builder.screenshots;
        this.statusReason = builder.statusReason;
        this.context = builder.context;
    }

    public String stepName() {
        return this.stepName;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public JobStatus status() {
        return JobStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public String logUrl() {
        return this.logUrl;
    }

    public String artifactsUrl() {
        return this.artifactsUrl;
    }

    public String testArtifactsUrl() {
        return this.testArtifactsUrl;
    }

    public String testConfigUrl() {
        return this.testConfigUrl;
    }

    public boolean hasScreenshots() {
        return this.screenshots != null && !(this.screenshots instanceof SdkAutoConstructMap);
    }

    public Map<String, String> screenshots() {
        return this.screenshots;
    }

    public String statusReason() {
        return this.statusReason;
    }

    public String context() {
        return this.context;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stepName());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.logUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactsUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.testArtifactsUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.testConfigUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScreenshots() ? this.screenshots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.context());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Step)) {
            return false;
        }
        Step other = (Step)obj;
        return Objects.equals(this.stepName(), other.stepName()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.logUrl(), other.logUrl()) && Objects.equals(this.artifactsUrl(), other.artifactsUrl()) && Objects.equals(this.testArtifactsUrl(), other.testArtifactsUrl()) && Objects.equals(this.testConfigUrl(), other.testConfigUrl()) && this.hasScreenshots() == other.hasScreenshots() && Objects.equals(this.screenshots(), other.screenshots()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.context(), other.context());
    }

    public String toString() {
        return ToString.builder((String)"Step").add("StepName", (Object)this.stepName()).add("StartTime", (Object)this.startTime()).add("Status", (Object)this.statusAsString()).add("EndTime", (Object)this.endTime()).add("LogUrl", (Object)this.logUrl()).add("ArtifactsUrl", (Object)this.artifactsUrl()).add("TestArtifactsUrl", (Object)this.testArtifactsUrl()).add("TestConfigUrl", (Object)this.testConfigUrl()).add("Screenshots", this.hasScreenshots() ? this.screenshots() : null).add("StatusReason", (Object)this.statusReason()).add("Context", (Object)this.context()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stepName": {
                return Optional.ofNullable(clazz.cast(this.stepName()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "logUrl": {
                return Optional.ofNullable(clazz.cast(this.logUrl()));
            }
            case "artifactsUrl": {
                return Optional.ofNullable(clazz.cast(this.artifactsUrl()));
            }
            case "testArtifactsUrl": {
                return Optional.ofNullable(clazz.cast(this.testArtifactsUrl()));
            }
            case "testConfigUrl": {
                return Optional.ofNullable(clazz.cast(this.testConfigUrl()));
            }
            case "screenshots": {
                return Optional.ofNullable(clazz.cast(this.screenshots()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Step, T> g) {
        return obj -> g.apply((Step)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stepName;
        private Instant startTime;
        private String status;
        private Instant endTime;
        private String logUrl;
        private String artifactsUrl;
        private String testArtifactsUrl;
        private String testConfigUrl;
        private Map<String, String> screenshots = DefaultSdkAutoConstructMap.getInstance();
        private String statusReason;
        private String context;

        private BuilderImpl() {
        }

        private BuilderImpl(Step model) {
            this.stepName(model.stepName);
            this.startTime(model.startTime);
            this.status(model.status);
            this.endTime(model.endTime);
            this.logUrl(model.logUrl);
            this.artifactsUrl(model.artifactsUrl);
            this.testArtifactsUrl(model.testArtifactsUrl);
            this.testConfigUrl(model.testConfigUrl);
            this.screenshots(model.screenshots);
            this.statusReason(model.statusReason);
            this.context(model.context);
        }

        public final String getStepName() {
            return this.stepName;
        }

        @Override
        public final Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public final void setStepName(String stepName) {
            this.stepName = stepName;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getLogUrl() {
            return this.logUrl;
        }

        @Override
        public final Builder logUrl(String logUrl) {
            this.logUrl = logUrl;
            return this;
        }

        public final void setLogUrl(String logUrl) {
            this.logUrl = logUrl;
        }

        public final String getArtifactsUrl() {
            return this.artifactsUrl;
        }

        @Override
        public final Builder artifactsUrl(String artifactsUrl) {
            this.artifactsUrl = artifactsUrl;
            return this;
        }

        public final void setArtifactsUrl(String artifactsUrl) {
            this.artifactsUrl = artifactsUrl;
        }

        public final String getTestArtifactsUrl() {
            return this.testArtifactsUrl;
        }

        @Override
        public final Builder testArtifactsUrl(String testArtifactsUrl) {
            this.testArtifactsUrl = testArtifactsUrl;
            return this;
        }

        public final void setTestArtifactsUrl(String testArtifactsUrl) {
            this.testArtifactsUrl = testArtifactsUrl;
        }

        public final String getTestConfigUrl() {
            return this.testConfigUrl;
        }

        @Override
        public final Builder testConfigUrl(String testConfigUrl) {
            this.testConfigUrl = testConfigUrl;
            return this;
        }

        public final void setTestConfigUrl(String testConfigUrl) {
            this.testConfigUrl = testConfigUrl;
        }

        public final Map<String, String> getScreenshots() {
            if (this.screenshots instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.screenshots;
        }

        @Override
        public final Builder screenshots(Map<String, String> screenshots) {
            this.screenshots = ScreenshotsCopier.copy(screenshots);
            return this;
        }

        public final void setScreenshots(Map<String, String> screenshots) {
            this.screenshots = ScreenshotsCopier.copy(screenshots);
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final String getContext() {
            return this.context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        public Step build() {
            return new Step(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Step> {
        public Builder stepName(String var1);

        public Builder startTime(Instant var1);

        public Builder status(String var1);

        public Builder status(JobStatus var1);

        public Builder endTime(Instant var1);

        public Builder logUrl(String var1);

        public Builder artifactsUrl(String var1);

        public Builder testArtifactsUrl(String var1);

        public Builder testConfigUrl(String var1);

        public Builder screenshots(Map<String, String> var1);

        public Builder statusReason(String var1);

        public Builder context(String var1);
    }
}

