/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result structure for an Amplify app list request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAppsResponse extends AmplifyResponse implements
        ToCopyableBuilder<ListAppsResponse.Builder, ListAppsResponse> {
    private static final SdkField<List<App>> APPS_FIELD = SdkField
            .<List<App>> builder(MarshallingType.LIST)
            .memberName("apps")
            .getter(getter(ListAppsResponse::apps))
            .setter(setter(Builder::apps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<App> builder(MarshallingType.SDK_POJO)
                                            .constructor(App::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAppsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPS_FIELD, NEXT_TOKEN_FIELD));

    private final List<App> apps;

    private final String nextToken;

    private ListAppsResponse(BuilderImpl builder) {
        super(builder);
        this.apps = builder.apps;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Apps property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasApps() {
        return apps != null && !(apps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amplify apps.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasApps()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of Amplify apps.
     */
    public List<App> apps() {
        return apps;
    }

    /**
     * <p>
     * A pagination token. Set to null to start listing apps from start. If non-null, the pagination token is returned
     * in a result. Pass its value in here to list more projects.
     * </p>
     * 
     * @return A pagination token. Set to null to start listing apps from start. If non-null, the pagination token is
     *         returned in a result. Pass its value in here to list more projects.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasApps() ? apps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppsResponse)) {
            return false;
        }
        ListAppsResponse other = (ListAppsResponse) obj;
        return hasApps() == other.hasApps() && Objects.equals(apps(), other.apps())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListAppsResponse").add("Apps", hasApps() ? apps() : null).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apps":
            return Optional.ofNullable(clazz.cast(apps()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppsResponse, T> g) {
        return obj -> g.apply((ListAppsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAppsResponse> {
        /**
         * <p>
         * A list of Amplify apps.
         * </p>
         * 
         * @param apps
         *        A list of Amplify apps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apps(Collection<App> apps);

        /**
         * <p>
         * A list of Amplify apps.
         * </p>
         * 
         * @param apps
         *        A list of Amplify apps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apps(App... apps);

        /**
         * <p>
         * A list of Amplify apps.
         * </p>
         * This is a convenience that creates an instance of the {@link List<App>.Builder} avoiding the need to create
         * one manually via {@link List<App>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<App>.Builder#build()} is called immediately and its result
         * is passed to {@link #apps(List<App>)}.
         * 
         * @param apps
         *        a consumer that will call methods on {@link List<App>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apps(List<App>)
         */
        Builder apps(Consumer<App.Builder>... apps);

        /**
         * <p>
         * A pagination token. Set to null to start listing apps from start. If non-null, the pagination token is
         * returned in a result. Pass its value in here to list more projects.
         * </p>
         * 
         * @param nextToken
         *        A pagination token. Set to null to start listing apps from start. If non-null, the pagination token is
         *        returned in a result. Pass its value in here to list more projects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AmplifyResponse.BuilderImpl implements Builder {
        private List<App> apps = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppsResponse model) {
            super(model);
            apps(model.apps);
            nextToken(model.nextToken);
        }

        public final Collection<App.Builder> getApps() {
            if (apps instanceof SdkAutoConstructList) {
                return null;
            }
            return apps != null ? apps.stream().map(App::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder apps(Collection<App> apps) {
            this.apps = AppsCopier.copy(apps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apps(App... apps) {
            apps(Arrays.asList(apps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apps(Consumer<App.Builder>... apps) {
            apps(Stream.of(apps).map(c -> App.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setApps(Collection<App.BuilderImpl> apps) {
            this.apps = AppsCopier.copyFromBuilder(apps);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAppsResponse build() {
            return new ListAppsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
