/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result structure for the get domain association request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDomainAssociationResponse extends AmplifyResponse implements
        ToCopyableBuilder<GetDomainAssociationResponse.Builder, GetDomainAssociationResponse> {
    private static final SdkField<DomainAssociation> DOMAIN_ASSOCIATION_FIELD = SdkField
            .<DomainAssociation> builder(MarshallingType.SDK_POJO).memberName("domainAssociation")
            .getter(getter(GetDomainAssociationResponse::domainAssociation)).setter(setter(Builder::domainAssociation))
            .constructor(DomainAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainAssociation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ASSOCIATION_FIELD));

    private final DomainAssociation domainAssociation;

    private GetDomainAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.domainAssociation = builder.domainAssociation;
    }

    /**
     * <p>
     * Describes the structure of a domain association, which associates a custom domain with an Amplify app.
     * </p>
     * 
     * @return Describes the structure of a domain association, which associates a custom domain with an Amplify app.
     */
    public DomainAssociation domainAssociation() {
        return domainAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainAssociation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainAssociationResponse)) {
            return false;
        }
        GetDomainAssociationResponse other = (GetDomainAssociationResponse) obj;
        return Objects.equals(domainAssociation(), other.domainAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDomainAssociationResponse").add("DomainAssociation", domainAssociation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainAssociation":
            return Optional.ofNullable(clazz.cast(domainAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDomainAssociationResponse, T> g) {
        return obj -> g.apply((GetDomainAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDomainAssociationResponse> {
        /**
         * <p>
         * Describes the structure of a domain association, which associates a custom domain with an Amplify app.
         * </p>
         * 
         * @param domainAssociation
         *        Describes the structure of a domain association, which associates a custom domain with an Amplify app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainAssociation(DomainAssociation domainAssociation);

        /**
         * <p>
         * Describes the structure of a domain association, which associates a custom domain with an Amplify app.
         * </p>
         * This is a convenience that creates an instance of the {@link DomainAssociation.Builder} avoiding the need to
         * create one manually via {@link DomainAssociation#builder()}.
         *
         * When the {@link Consumer} completes, {@link DomainAssociation.Builder#build()} is called immediately and its
         * result is passed to {@link #domainAssociation(DomainAssociation)}.
         * 
         * @param domainAssociation
         *        a consumer that will call methods on {@link DomainAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainAssociation(DomainAssociation)
         */
        default Builder domainAssociation(Consumer<DomainAssociation.Builder> domainAssociation) {
            return domainAssociation(DomainAssociation.builder().applyMutation(domainAssociation).build());
        }
    }

    static final class BuilderImpl extends AmplifyResponse.BuilderImpl implements Builder {
        private DomainAssociation domainAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainAssociationResponse model) {
            super(model);
            domainAssociation(model.domainAssociation);
        }

        public final DomainAssociation.Builder getDomainAssociation() {
            return domainAssociation != null ? domainAssociation.toBuilder() : null;
        }

        @Override
        public final Builder domainAssociation(DomainAssociation domainAssociation) {
            this.domainAssociation = domainAssociation;
            return this;
        }

        public final void setDomainAssociation(DomainAssociation.BuilderImpl domainAssociation) {
            this.domainAssociation = domainAssociation != null ? domainAssociation.build() : null;
        }

        @Override
        public GetDomainAssociationResponse build() {
            return new GetDomainAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
