/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.amplify.model.AmplifyResponse;
import software.amazon.awssdk.services.amplify.model.FileUploadUrlsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDeploymentResponse
extends AmplifyResponse
implements ToCopyableBuilder<Builder, CreateDeploymentResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(CreateDeploymentResponse.getter(CreateDeploymentResponse::jobId)).setter(CreateDeploymentResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<Map<String, String>> FILE_UPLOAD_URLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("fileUploadUrls").getter(CreateDeploymentResponse.getter(CreateDeploymentResponse::fileUploadUrls)).setter(CreateDeploymentResponse.setter(Builder::fileUploadUrls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileUploadUrls").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ZIP_UPLOAD_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("zipUploadUrl").getter(CreateDeploymentResponse.getter(CreateDeploymentResponse::zipUploadUrl)).setter(CreateDeploymentResponse.setter(Builder::zipUploadUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zipUploadUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, FILE_UPLOAD_URLS_FIELD, ZIP_UPLOAD_URL_FIELD));
    private final String jobId;
    private final Map<String, String> fileUploadUrls;
    private final String zipUploadUrl;

    private CreateDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.fileUploadUrls = builder.fileUploadUrls;
        this.zipUploadUrl = builder.zipUploadUrl;
    }

    public String jobId() {
        return this.jobId;
    }

    public boolean hasFileUploadUrls() {
        return this.fileUploadUrls != null && !(this.fileUploadUrls instanceof SdkAutoConstructMap);
    }

    public Map<String, String> fileUploadUrls() {
        return this.fileUploadUrls;
    }

    public String zipUploadUrl() {
        return this.zipUploadUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileUploadUrls());
        hashCode = 31 * hashCode + Objects.hashCode(this.zipUploadUrl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentResponse)) {
            return false;
        }
        CreateDeploymentResponse other = (CreateDeploymentResponse)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.fileUploadUrls(), other.fileUploadUrls()) && Objects.equals(this.zipUploadUrl(), other.zipUploadUrl());
    }

    public String toString() {
        return ToString.builder((String)"CreateDeploymentResponse").add("JobId", (Object)this.jobId()).add("FileUploadUrls", this.fileUploadUrls()).add("ZipUploadUrl", (Object)this.zipUploadUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "fileUploadUrls": {
                return Optional.ofNullable(clazz.cast(this.fileUploadUrls()));
            }
            case "zipUploadUrl": {
                return Optional.ofNullable(clazz.cast(this.zipUploadUrl()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentResponse, T> g) {
        return obj -> g.apply((CreateDeploymentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyResponse.BuilderImpl
    implements Builder {
        private String jobId;
        private Map<String, String> fileUploadUrls = DefaultSdkAutoConstructMap.getInstance();
        private String zipUploadUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentResponse model) {
            super(model);
            this.jobId(model.jobId);
            this.fileUploadUrls(model.fileUploadUrls);
            this.zipUploadUrl(model.zipUploadUrl);
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final Map<String, String> getFileUploadUrls() {
            return this.fileUploadUrls;
        }

        @Override
        public final Builder fileUploadUrls(Map<String, String> fileUploadUrls) {
            this.fileUploadUrls = FileUploadUrlsCopier.copy(fileUploadUrls);
            return this;
        }

        public final void setFileUploadUrls(Map<String, String> fileUploadUrls) {
            this.fileUploadUrls = FileUploadUrlsCopier.copy(fileUploadUrls);
        }

        public final String getZipUploadUrl() {
            return this.zipUploadUrl;
        }

        @Override
        public final Builder zipUploadUrl(String zipUploadUrl) {
            this.zipUploadUrl = zipUploadUrl;
            return this;
        }

        public final void setZipUploadUrl(String zipUploadUrl) {
            this.zipUploadUrl = zipUploadUrl;
        }

        @Override
        public CreateDeploymentResponse build() {
            return new CreateDeploymentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AmplifyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDeploymentResponse> {
        public Builder jobId(String var1);

        public Builder fileUploadUrls(Map<String, String> var1);

        public Builder zipUploadUrl(String var1);
    }
}

