/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplify.model.JobStatus;
import software.amazon.awssdk.services.amplify.model.JobType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobSummary> {
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobSummary.getter(JobSummary::jobArn)).setter(JobSummary.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobSummary.getter(JobSummary::jobId)).setter(JobSummary.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobSummary.getter(JobSummary::commitId)).setter(JobSummary.setter(Builder::commitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitId").build()}).build();
    private static final SdkField<String> COMMIT_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobSummary.getter(JobSummary::commitMessage)).setter(JobSummary.setter(Builder::commitMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitMessage").build()}).build();
    private static final SdkField<Instant> COMMIT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(JobSummary.getter(JobSummary::commitTime)).setter(JobSummary.setter(Builder::commitTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitTime").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(JobSummary.getter(JobSummary::startTime)).setter(JobSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobSummary.getter(JobSummary::statusAsString)).setter(JobSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(JobSummary.getter(JobSummary::endTime)).setter(JobSummary.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobSummary.getter(JobSummary::jobTypeAsString)).setter(JobSummary.setter(Builder::jobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ARN_FIELD, JOB_ID_FIELD, COMMIT_ID_FIELD, COMMIT_MESSAGE_FIELD, COMMIT_TIME_FIELD, START_TIME_FIELD, STATUS_FIELD, END_TIME_FIELD, JOB_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobArn;
    private final String jobId;
    private final String commitId;
    private final String commitMessage;
    private final Instant commitTime;
    private final Instant startTime;
    private final String status;
    private final Instant endTime;
    private final String jobType;

    private JobSummary(BuilderImpl builder) {
        this.jobArn = builder.jobArn;
        this.jobId = builder.jobId;
        this.commitId = builder.commitId;
        this.commitMessage = builder.commitMessage;
        this.commitTime = builder.commitTime;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.endTime = builder.endTime;
        this.jobType = builder.jobType;
    }

    public String jobArn() {
        return this.jobArn;
    }

    public String jobId() {
        return this.jobId;
    }

    public String commitId() {
        return this.commitId;
    }

    public String commitMessage() {
        return this.commitMessage;
    }

    public Instant commitTime() {
        return this.commitTime;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public JobStatus status() {
        return JobStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public JobType jobType() {
        return JobType.fromValue(this.jobType);
    }

    public String jobTypeAsString() {
        return this.jobType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobSummary)) {
            return false;
        }
        JobSummary other = (JobSummary)obj;
        return Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.commitId(), other.commitId()) && Objects.equals(this.commitMessage(), other.commitMessage()) && Objects.equals(this.commitTime(), other.commitTime()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.jobTypeAsString(), other.jobTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"JobSummary").add("JobArn", (Object)this.jobArn()).add("JobId", (Object)this.jobId()).add("CommitId", (Object)this.commitId()).add("CommitMessage", (Object)this.commitMessage()).add("CommitTime", (Object)this.commitTime()).add("StartTime", (Object)this.startTime()).add("Status", (Object)this.statusAsString()).add("EndTime", (Object)this.endTime()).add("JobType", (Object)this.jobTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "commitId": {
                return Optional.ofNullable(clazz.cast(this.commitId()));
            }
            case "commitMessage": {
                return Optional.ofNullable(clazz.cast(this.commitMessage()));
            }
            case "commitTime": {
                return Optional.ofNullable(clazz.cast(this.commitTime()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "jobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobSummary, T> g) {
        return obj -> g.apply((JobSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobArn;
        private String jobId;
        private String commitId;
        private String commitMessage;
        private Instant commitTime;
        private Instant startTime;
        private String status;
        private Instant endTime;
        private String jobType;

        private BuilderImpl() {
        }

        private BuilderImpl(JobSummary model) {
            this.jobArn(model.jobArn);
            this.jobId(model.jobId);
            this.commitId(model.commitId);
            this.commitMessage(model.commitMessage);
            this.commitTime(model.commitTime);
            this.startTime(model.startTime);
            this.status(model.status);
            this.endTime(model.endTime);
            this.jobType(model.jobType);
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getCommitId() {
            return this.commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        public final String getCommitMessage() {
            return this.commitMessage;
        }

        @Override
        public final Builder commitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
            return this;
        }

        public final void setCommitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
        }

        public final Instant getCommitTime() {
            return this.commitTime;
        }

        @Override
        public final Builder commitTime(Instant commitTime) {
            this.commitTime = commitTime;
            return this;
        }

        public final void setCommitTime(Instant commitTime) {
            this.commitTime = commitTime;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getJobType() {
            return this.jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public JobSummary build() {
            return new JobSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobSummary> {
        public Builder jobArn(String var1);

        public Builder jobId(String var1);

        public Builder commitId(String var1);

        public Builder commitMessage(String var1);

        public Builder commitTime(Instant var1);

        public Builder startTime(Instant var1);

        public Builder status(String var1);

        public Builder status(JobStatus var1);

        public Builder endTime(Instant var1);

        public Builder jobType(String var1);

        public Builder jobType(JobType var1);
    }
}

