/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request structure for a backend environment create request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBackendEnvironmentRequest extends AmplifyRequest implements
        ToCopyableBuilder<CreateBackendEnvironmentRequest.Builder, CreateBackendEnvironmentRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateBackendEnvironmentRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()).build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateBackendEnvironmentRequest::environmentName)).setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()).build();

    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateBackendEnvironmentRequest::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stackName").build()).build();

    private static final SdkField<String> DEPLOYMENT_ARTIFACTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateBackendEnvironmentRequest::deploymentArtifacts)).setter(setter(Builder::deploymentArtifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentArtifacts").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            ENVIRONMENT_NAME_FIELD, STACK_NAME_FIELD, DEPLOYMENT_ARTIFACTS_FIELD));

    private final String appId;

    private final String environmentName;

    private final String stackName;

    private final String deploymentArtifacts;

    private CreateBackendEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.environmentName = builder.environmentName;
        this.stackName = builder.stackName;
        this.deploymentArtifacts = builder.deploymentArtifacts;
    }

    /**
     * <p>
     * Unique Id for an Amplify App.
     * </p>
     * 
     * @return Unique Id for an Amplify App.
     */
    public String appId() {
        return appId;
    }

    /**
     * <p>
     * Name for the backend environment.
     * </p>
     * 
     * @return Name for the backend environment.
     */
    public String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * CloudFormation stack name of backend environment.
     * </p>
     * 
     * @return CloudFormation stack name of backend environment.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * Name of deployment artifacts.
     * </p>
     * 
     * @return Name of deployment artifacts.
     */
    public String deploymentArtifacts() {
        return deploymentArtifacts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentArtifacts());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackendEnvironmentRequest)) {
            return false;
        }
        CreateBackendEnvironmentRequest other = (CreateBackendEnvironmentRequest) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(environmentName(), other.environmentName())
                && Objects.equals(stackName(), other.stackName())
                && Objects.equals(deploymentArtifacts(), other.deploymentArtifacts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateBackendEnvironmentRequest").add("AppId", appId())
                .add("EnvironmentName", environmentName()).add("StackName", stackName())
                .add("DeploymentArtifacts", deploymentArtifacts()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "environmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "stackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "deploymentArtifacts":
            return Optional.ofNullable(clazz.cast(deploymentArtifacts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBackendEnvironmentRequest, T> g) {
        return obj -> g.apply((CreateBackendEnvironmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateBackendEnvironmentRequest> {
        /**
         * <p>
         * Unique Id for an Amplify App.
         * </p>
         * 
         * @param appId
         *        Unique Id for an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * Name for the backend environment.
         * </p>
         * 
         * @param environmentName
         *        Name for the backend environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * CloudFormation stack name of backend environment.
         * </p>
         * 
         * @param stackName
         *        CloudFormation stack name of backend environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * Name of deployment artifacts.
         * </p>
         * 
         * @param deploymentArtifacts
         *        Name of deployment artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentArtifacts(String deploymentArtifacts);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmplifyRequest.BuilderImpl implements Builder {
        private String appId;

        private String environmentName;

        private String stackName;

        private String deploymentArtifacts;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackendEnvironmentRequest model) {
            super(model);
            appId(model.appId);
            environmentName(model.environmentName);
            stackName(model.stackName);
            deploymentArtifacts(model.deploymentArtifacts);
        }

        public final String getAppId() {
            return appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getDeploymentArtifacts() {
            return deploymentArtifacts;
        }

        @Override
        public final Builder deploymentArtifacts(String deploymentArtifacts) {
            this.deploymentArtifacts = deploymentArtifacts;
            return this;
        }

        public final void setDeploymentArtifacts(String deploymentArtifacts) {
            this.deploymentArtifacts = deploymentArtifacts;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBackendEnvironmentRequest build() {
            return new CreateBackendEnvironmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
