/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Result structure for list backend environments result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBackendEnvironmentsResponse extends AmplifyResponse implements
        ToCopyableBuilder<ListBackendEnvironmentsResponse.Builder, ListBackendEnvironmentsResponse> {
    private static final SdkField<List<BackendEnvironment>> BACKEND_ENVIRONMENTS_FIELD = SdkField
            .<List<BackendEnvironment>> builder(MarshallingType.LIST)
            .getter(getter(ListBackendEnvironmentsResponse::backendEnvironments))
            .setter(setter(Builder::backendEnvironments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backendEnvironments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BackendEnvironment> builder(MarshallingType.SDK_POJO)
                                            .constructor(BackendEnvironment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListBackendEnvironmentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKEND_ENVIRONMENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<BackendEnvironment> backendEnvironments;

    private final String nextToken;

    private ListBackendEnvironmentsResponse(BuilderImpl builder) {
        super(builder);
        this.backendEnvironments = builder.backendEnvironments;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the BackendEnvironments property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasBackendEnvironments() {
        return backendEnvironments != null && !(backendEnvironments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of backend environments for an Amplify App.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBackendEnvironments()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of backend environments for an Amplify App.
     */
    public List<BackendEnvironment> backendEnvironments() {
        return backendEnvironments;
    }

    /**
     * <p>
     * Pagination token. If non-null pagination token is returned in a result, then pass its value in another request to
     * fetch more entries.
     * </p>
     * 
     * @return Pagination token. If non-null pagination token is returned in a result, then pass its value in another
     *         request to fetch more entries.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backendEnvironments());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBackendEnvironmentsResponse)) {
            return false;
        }
        ListBackendEnvironmentsResponse other = (ListBackendEnvironmentsResponse) obj;
        return Objects.equals(backendEnvironments(), other.backendEnvironments())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListBackendEnvironmentsResponse").add("BackendEnvironments", backendEnvironments())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "backendEnvironments":
            return Optional.ofNullable(clazz.cast(backendEnvironments()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBackendEnvironmentsResponse, T> g) {
        return obj -> g.apply((ListBackendEnvironmentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListBackendEnvironmentsResponse> {
        /**
         * <p>
         * List of backend environments for an Amplify App.
         * </p>
         * 
         * @param backendEnvironments
         *        List of backend environments for an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backendEnvironments(Collection<BackendEnvironment> backendEnvironments);

        /**
         * <p>
         * List of backend environments for an Amplify App.
         * </p>
         * 
         * @param backendEnvironments
         *        List of backend environments for an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backendEnvironments(BackendEnvironment... backendEnvironments);

        /**
         * <p>
         * List of backend environments for an Amplify App.
         * </p>
         * This is a convenience that creates an instance of the {@link List<BackendEnvironment>.Builder} avoiding the
         * need to create one manually via {@link List<BackendEnvironment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BackendEnvironment>.Builder#build()} is called immediately
         * and its result is passed to {@link #backendEnvironments(List<BackendEnvironment>)}.
         * 
         * @param backendEnvironments
         *        a consumer that will call methods on {@link List<BackendEnvironment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backendEnvironments(List<BackendEnvironment>)
         */
        Builder backendEnvironments(Consumer<BackendEnvironment.Builder>... backendEnvironments);

        /**
         * <p>
         * Pagination token. If non-null pagination token is returned in a result, then pass its value in another
         * request to fetch more entries.
         * </p>
         * 
         * @param nextToken
         *        Pagination token. If non-null pagination token is returned in a result, then pass its value in another
         *        request to fetch more entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AmplifyResponse.BuilderImpl implements Builder {
        private List<BackendEnvironment> backendEnvironments = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBackendEnvironmentsResponse model) {
            super(model);
            backendEnvironments(model.backendEnvironments);
            nextToken(model.nextToken);
        }

        public final Collection<BackendEnvironment.Builder> getBackendEnvironments() {
            return backendEnvironments != null ? backendEnvironments.stream().map(BackendEnvironment::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder backendEnvironments(Collection<BackendEnvironment> backendEnvironments) {
            this.backendEnvironments = BackendEnvironmentsCopier.copy(backendEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backendEnvironments(BackendEnvironment... backendEnvironments) {
            backendEnvironments(Arrays.asList(backendEnvironments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backendEnvironments(Consumer<BackendEnvironment.Builder>... backendEnvironments) {
            backendEnvironments(Stream.of(backendEnvironments).map(c -> BackendEnvironment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setBackendEnvironments(Collection<BackendEnvironment.BuilderImpl> backendEnvironments) {
            this.backendEnvironments = BackendEnvironmentsCopier.copyFromBuilder(backendEnvironments);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListBackendEnvironmentsResponse build() {
            return new ListBackendEnvironmentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
