/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request structure for create a new deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDeploymentRequest extends AmplifyRequest implements
        ToCopyableBuilder<CreateDeploymentRequest.Builder, CreateDeploymentRequest> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDeploymentRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("appId").build()).build();

    private static final SdkField<String> BRANCH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDeploymentRequest::branchName)).setter(setter(Builder::branchName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("branchName").build()).build();

    private static final SdkField<Map<String, String>> FILE_MAP_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateDeploymentRequest::fileMap))
            .setter(setter(Builder::fileMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD,
            BRANCH_NAME_FIELD, FILE_MAP_FIELD));

    private final String appId;

    private final String branchName;

    private final Map<String, String> fileMap;

    private CreateDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.branchName = builder.branchName;
        this.fileMap = builder.fileMap;
    }

    /**
     * <p>
     * Unique Id for an Amplify App.
     * </p>
     * 
     * @return Unique Id for an Amplify App.
     */
    public String appId() {
        return appId;
    }

    /**
     * <p>
     * Name for the branch, for the Job.
     * </p>
     * 
     * @return Name for the branch, for the Job.
     */
    public String branchName() {
        return branchName;
    }

    /**
     * Returns true if the FileMap property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFileMap() {
        return fileMap != null && !(fileMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Optional file map that contains file name as the key and file content md5 hash as the value. If this argument is
     * provided, the service will generate different upload url per file. Otherwise, the service will only generate a
     * single upload url for the zipped files.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFileMap()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Optional file map that contains file name as the key and file content md5 hash as the value. If this
     *         argument is provided, the service will generate different upload url per file. Otherwise, the service
     *         will only generate a single upload url for the zipped files.
     */
    public Map<String, String> fileMap() {
        return fileMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(branchName());
        hashCode = 31 * hashCode + Objects.hashCode(fileMap());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentRequest)) {
            return false;
        }
        CreateDeploymentRequest other = (CreateDeploymentRequest) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(branchName(), other.branchName())
                && Objects.equals(fileMap(), other.fileMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDeploymentRequest").add("AppId", appId()).add("BranchName", branchName())
                .add("FileMap", fileMap()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "branchName":
            return Optional.ofNullable(clazz.cast(branchName()));
        case "fileMap":
            return Optional.ofNullable(clazz.cast(fileMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentRequest, T> g) {
        return obj -> g.apply((CreateDeploymentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AmplifyRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDeploymentRequest> {
        /**
         * <p>
         * Unique Id for an Amplify App.
         * </p>
         * 
         * @param appId
         *        Unique Id for an Amplify App.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * Name for the branch, for the Job.
         * </p>
         * 
         * @param branchName
         *        Name for the branch, for the Job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchName(String branchName);

        /**
         * <p>
         * Optional file map that contains file name as the key and file content md5 hash as the value. If this argument
         * is provided, the service will generate different upload url per file. Otherwise, the service will only
         * generate a single upload url for the zipped files.
         * </p>
         * 
         * @param fileMap
         *        Optional file map that contains file name as the key and file content md5 hash as the value. If this
         *        argument is provided, the service will generate different upload url per file. Otherwise, the service
         *        will only generate a single upload url for the zipped files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileMap(Map<String, String> fileMap);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AmplifyRequest.BuilderImpl implements Builder {
        private String appId;

        private String branchName;

        private Map<String, String> fileMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentRequest model) {
            super(model);
            appId(model.appId);
            branchName(model.branchName);
            fileMap(model.fileMap);
        }

        public final String getAppId() {
            return appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getBranchName() {
            return branchName;
        }

        @Override
        public final Builder branchName(String branchName) {
            this.branchName = branchName;
            return this;
        }

        public final void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        public final Map<String, String> getFileMap() {
            return fileMap;
        }

        @Override
        public final Builder fileMap(Map<String, String> fileMap) {
            this.fileMap = FileMapCopier.copy(fileMap);
            return this;
        }

        public final void setFileMap(Map<String, String> fileMap) {
            this.fileMap = FileMapCopier.copy(fileMap);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeploymentRequest build() {
            return new CreateDeploymentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
