/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplify.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.amplify.model.AmplifyResponse;
import software.amazon.awssdk.services.amplify.model.JobSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDeploymentResponse
extends AmplifyResponse
implements ToCopyableBuilder<Builder, StartDeploymentResponse> {
    private static final SdkField<JobSummary> JOB_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(StartDeploymentResponse.getter(StartDeploymentResponse::jobSummary)).setter(StartDeploymentResponse.setter(Builder::jobSummary)).constructor(JobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_SUMMARY_FIELD));
    private final JobSummary jobSummary;

    private StartDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.jobSummary = builder.jobSummary;
    }

    public JobSummary jobSummary() {
        return this.jobSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobSummary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDeploymentResponse)) {
            return false;
        }
        StartDeploymentResponse other = (StartDeploymentResponse)((Object)obj);
        return Objects.equals(this.jobSummary(), other.jobSummary());
    }

    public String toString() {
        return ToString.builder((String)"StartDeploymentResponse").add("JobSummary", (Object)this.jobSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobSummary": {
                return Optional.ofNullable(clazz.cast(this.jobSummary()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDeploymentResponse, T> g) {
        return obj -> g.apply((StartDeploymentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AmplifyResponse.BuilderImpl
    implements Builder {
        private JobSummary jobSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDeploymentResponse model) {
            super(model);
            this.jobSummary(model.jobSummary);
        }

        public final JobSummary.Builder getJobSummary() {
            return this.jobSummary != null ? this.jobSummary.toBuilder() : null;
        }

        @Override
        public final Builder jobSummary(JobSummary jobSummary) {
            this.jobSummary = jobSummary;
            return this;
        }

        public final void setJobSummary(JobSummary.BuilderImpl jobSummary) {
            this.jobSummary = jobSummary != null ? jobSummary.build() : null;
        }

        @Override
        public StartDeploymentResponse build() {
            return new StartDeploymentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AmplifyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDeploymentResponse> {
        public Builder jobSummary(JobSummary var1);

        default public Builder jobSummary(Consumer<JobSummary.Builder> jobSummary) {
            return this.jobSummary((JobSummary)((JobSummary.Builder)JobSummary.builder().applyMutation(jobSummary)).build());
        }
    }
}

